/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import com.mojang.serialization.MapCodec;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.BlockEntityPlayerGrave;

public final class BlockGrave
extends BlockGraveBase {
    public BlockGrave(GraveModel graveModel) {
        super(BlockGrave.getBuilder(), graveModel);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTrace) {
        if (!level.m_5776_()) {
            return this.activatePlayerGrave(level, pos, state, (ServerPlayer)player) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    private boolean activatePlayerGrave(Level level, BlockPos pos, BlockState state, ServerPlayer player) {
        if (level.m_5776_()) {
            return true;
        }
        BlockEntityPlayerGrave grave = Helper.getPlayerGrave(level, pos).orElse(null);
        if (grave == null || grave.countTicks < 30 || !player.m_6084_()) {
            return false;
        }
        boolean hasKey = ModItems.grave_key.removeKeyForGraveInInventory((Player)player, grave);
        boolean isOwner = grave.isOwner((Player)player);
        if (!hasKey && isOwner) {
            ModTriggers.EASY_OPENING.trigger(player);
        }
        boolean isTombRaiding = false;
        if (hasKey || isOwner || (isTombRaiding = !grave.getNeedAccess())) {
            grave.giveInventory(player);
            if (level.m_6106_().m_5472_() != Difficulty.PEACEFUL && (Integer)ConfigTombstone.player_death.chanceMobOnGraveRecovery.get() > 0 && Helper.RANDOM.nextInt(100) < (Integer)ConfigTombstone.player_death.chanceMobOnGraveRecovery.get()) {
                IntStream.range(0, Helper.RANDOM.nextInt(3) + 1).forEach(i -> Helper.spawnRandomMob((ServerLevel)level, pos));
            }
            if (isTombRaiding) {
                ModTriggers.TOMB_RAIDING.trigger(player);
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 0, (Integer)ConfigTombstone.alignment.pointsPlunderPlayerGrave.get()));
                LangKey.MESSAGE_TOMB_RAIDER_SUCCESS.sendMessage((Player)player, new Object[0]);
            }
        } else {
            LangKey.MESSAGE_OPEN_GRAVE_NEED_KEY.sendMessage((Player)player, new Object[0]);
        }
        return true;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        ServerPlayer player;
        if (!level.m_5776_() && entity.m_6144_() && entity.m_6084_() && TimeHelper.atInterval(entity, 20) && EntityHelper.isValidPlayer(entity) && PlayerPreference.get(player = (ServerPlayer)entity).activateGraveBySneaking() && this.activatePlayerGrave(level, pos, state, player)) {
            ModTriggers.SNEAK_GRAVE.trigger(player);
        }
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter blockGetter, BlockPos pos, Player player) {
        return false;
    }

    public float m_5880_(BlockState state, Player player, BlockGetter blockGetter, BlockPos pos) {
        return 0.0f;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        return null;
    }

    @Override
    protected void onDrop(Level level, BlockPos pos, BlockState oldState) {
        Helper.getPlayerGrave(level, pos).ifPresent(grave -> {
            for (int i = 0; i < grave.getInventory().getSlots(); ++i) {
                ItemStack stack = grave.getInventory().getStackInSlot(i);
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)grave.getInventory().extractItem(i, stack.m_41613_(), false));
            }
        });
    }

    public ItemStack asDecorativeStack() {
        Item item;
        ResourceLocation registryName = RegistryHelper.getRegistryName((Block)this);
        if (registryName != null && (item = RegistryHelper.getItem(new ResourceLocation(registryName.m_135827_(), "decorative_" + registryName.m_135815_()))) != null && item != Items.f_41852_) {
            return new ItemStack((ItemLike)item);
        }
        return ItemStack.f_41583_;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityPlayerGrave(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        return BlockGrave.createTickerHelper(entityType, ModBlocks.tile_grave, level.m_5776_() ? BlockEntityPlayerGrave::clientTick : BlockEntityPlayerGrave::serverTick);
    }

    private static BlockBehaviour.Properties getBuilder() {
        return BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60913_(-1.0f, 1.8E7f).m_60953_(s -> 5).m_60918_(SoundType.f_56742_);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> m_304657_() {
        return null;
    }
}

