/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.registry.ModLootFunctions;

public class PreciseEnchantFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "precise_enchant");
    public static final Codec<PreciseEnchantFunction> CODEC = RecordCodecBuilder.create(b -> PreciseEnchantFunction.m_294820_((RecordCodecBuilder.Instance)b).and(b.group((App)ExtraCodecs.f_263723_.fieldOf("id").orElse((Object)"tombstone:soulbound").forGetter(g -> g.id), (App)NumberProviders.f_291751_.fieldOf("level").orElse((Object)new ConstantValue(1.0f)).forGetter(g -> g.level))).apply((Applicative)b, PreciseEnchantFunction::new));
    private final String id;
    private final NumberProvider level;

    private PreciseEnchantFunction(List<LootItemCondition> conditionsIn, String id, NumberProvider level) {
        super(conditionsIn);
        this.id = id;
        this.level = level;
    }

    public LootItemFunctionType m_7162_() {
        return ModLootFunctions.PRECISE_ENCHANT;
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        ResourceLocation rl = new ResourceLocation(this.id);
        Enchantment enchant = RegistryHelper.getEnchantment(rl);
        if (enchant != null && (!"tombstone".equals(rl.m_135827_()) || ((TombstoneEnchantment)enchant).isEnabled())) {
            EnchantmentHelper.m_44865_(Collections.singletonMap(enchant, this.level.m_142683_(context)), (ItemStack)stack);
            return stack;
        }
        return stack.m_150930_(Items.f_42690_) ? ItemStack.f_41583_ : stack;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final String id;
        private final int level;

        public Builder(Enchantment enchantment) {
            this(enchantment, 1);
        }

        public Builder(Enchantment enchantment, int level) {
            this.id = RegistryHelper.getRegistryString(enchantment);
            this.level = level;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction m_7453_() {
            return new PreciseEnchantFunction(this.m_80699_(), this.id, (NumberProvider)new ConstantValue((float)this.level));
        }
    }
}

