/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.registry.ModLootFunctions;

public class RandomScrollBuffFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "random_scroll_buff");
    public static final Codec<RandomScrollBuffFunction> CODEC = RecordCodecBuilder.create(b -> RandomScrollBuffFunction.m_294820_((RecordCodecBuilder.Instance)b).and((App)Codec.BOOL.fieldOf("ancient").orElse((Object)false).forGetter(g -> g.isAncient)).apply((Applicative)b, RandomScrollBuffFunction::new));
    private final boolean isAncient;

    protected RandomScrollBuffFunction(List<LootItemCondition> conditionsIn, boolean isAncient) {
        super(conditionsIn);
        this.isAncient = isAncient;
    }

    public LootItemFunctionType m_7162_() {
        return ModLootFunctions.RANDOM_SCROLL_BUFF;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        return ItemScrollBuff.SpellBuff.getRandomEnchantedScroll(true).orElse(stack);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final boolean isAncient;

        public Builder(boolean isAncient) {
            this.isAncient = isAncient;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction m_7453_() {
            return new RandomScrollBuffFunction(this.m_80699_(), this.isAncient);
        }
    }
}

