/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class EquipCurioTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public static final EquipCurioTrigger INSTANCE = new EquipCurioTrigger();

    @Nonnull
    public Codec<TriggerInstance> m_5868_() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer serverPlayer, ItemStack stack) {
        LootParams lootparams = new LootParams.Builder(serverPlayer.m_284548_()).m_287286_(LootContextParams.f_81460_, (Object)serverPlayer.m_20183_().m_252807_()).m_287286_(LootContextParams.f_81455_, (Object)serverPlayer).m_287286_(LootContextParams.f_81461_, (Object)serverPlayer.m_20075_()).m_287286_(LootContextParams.f_81463_, (Object)stack).m_287235_(LootContextParamSets.f_285637_);
        LootContext lootcontext = new LootContext.Builder(lootparams).m_287259_(Optional.empty());
        this.m_66234_(serverPlayer, instance -> instance.matches(stack, lootcontext));
    }

    public static final class TriggerInstance
    extends Record
    implements SimpleCriterionTrigger.SimpleInstance {
        private final Optional<ContextAwarePredicate> player;
        private final Optional<ItemPredicate> item;
        private final Optional<LocationPredicate> location;
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(p_311432_ -> p_311432_.group((App)ExtraCodecs.m_294263_((Codec)EntityPredicate.f_303210_, (String)"player").forGetter(TriggerInstance::m_295156_), (App)ExtraCodecs.m_294263_((Codec)ItemPredicate.f_291722_, (String)"item").forGetter(TriggerInstance::item), (App)ExtraCodecs.m_294263_((Codec)LocationPredicate.f_291013_, (String)"location").forGetter(TriggerInstance::location)).apply((Applicative)p_311432_, TriggerInstance::new));

        public TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> item, Optional<LocationPredicate> location) {
            this.player = player;
            this.item = item;
            this.location = location;
        }

        public boolean matches(ItemStack stack, LootContext lootContext) {
            Vec3 vec3 = (Vec3)lootContext.m_165124_(LootContextParams.f_81460_);
            if (this.location.isEmpty() || this.location.get().m_52617_(lootContext.m_78952_(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_)) {
                return this.item.isEmpty() || this.item.get().m_45049_(stack);
            }
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TriggerInstance.class, "player;item;location", "player", "item", "location"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TriggerInstance.class, "player;item;location", "player", "item", "location"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TriggerInstance.class, "player;item;location", "player", "item", "location"}, this, o);
        }

        public Optional<ContextAwarePredicate> m_295156_() {
            return this.player;
        }

        public Optional<ItemPredicate> item() {
            return this.item;
        }

        public Optional<LocationPredicate> location() {
            return this.location;
        }
    }
}

