/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.customization;

import com.hidoni.customizableelytra.customization.ElytraCustomization;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.registry.ModItems;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizationUtils {
    @Nullable
    public static CompoundTag getElytraCustomizationTag(ItemStack elytra) {
        return elytra.m_41737_("customizableelytra:customization");
    }

    public static ElytraCustomization getElytraCustomization(ItemStack elytra) {
        CompoundTag tag = CustomizationUtils.getElytraCustomizationTag(elytra);
        if (tag == null) {
            ItemStack leftWing = new ItemStack((ItemLike)ModItems.ELYTRA_WING.get());
            ItemStack rightWing = leftWing.m_41777_();
            return new ElytraCustomization(leftWing, rightWing);
        }
        return CustomizationUtils.getElytraCustomization(tag);
    }

    public static ElytraCustomization getElytraCustomization(CompoundTag tag) {
        ItemStack leftWing = new ItemStack((ItemLike)ModItems.ELYTRA_WING.get());
        ItemStack rightWing = new ItemStack((ItemLike)ModItems.ELYTRA_WING.get());
        if (tag.m_128425_("left", 10)) {
            leftWing = CustomizationUtils.getWing(tag.m_128469_("left"));
        }
        if (tag.m_128425_("right", 10)) {
            rightWing = CustomizationUtils.getWing(tag.m_128469_("right"));
        }
        return new ElytraCustomization(leftWing, rightWing);
    }

    private static ItemStack getWing(CompoundTag tag) {
        return ItemStack.m_41712_((CompoundTag)tag);
    }

    public static int convertDyeColorToInt(DyeColor dyeColor) {
        float[] colorValues = dyeColor.m_41068_();
        int red = (int)(colorValues[0] * 255.0f) << 16;
        int green = (int)(colorValues[1] * 255.0f) << 8;
        int blue = (int)(colorValues[2] * 255.0f);
        return red | green | blue;
    }

    public static float[] convertIntToRGB(int color) {
        float redValue = (float)(color >> 16 & 0xFF) / 255.0f;
        float greenValue = (float)(color >> 8 & 0xFF) / 255.0f;
        float blueValue = (float)(color & 0xFF) / 255.0f;
        return new float[]{redValue, greenValue, blueValue};
    }

    public static ItemStack copyCustomizationTagToNewStack(ItemStack stack) {
        CompoundTag tag = CustomizationUtils.getElytraCustomizationTag(stack);
        ItemStack outStack = new ItemStack((ItemLike)stack.m_41720_());
        if (tag != null) {
            outStack.m_41784_().m_128365_("customizableelytra:customization", (Tag)tag);
        }
        return outStack;
    }

    public static List<Component> getElytraWingTooltipLines(ItemStack wing, TooltipFlag flag, @Nullable RegistryAccess access) {
        ArrayList<Component> lines = new ArrayList<Component>();
        Item item = wing.m_41720_();
        if (!(item instanceof CustomizableElytraItem)) {
            return lines;
        }
        CustomizableElytraItem item2 = (CustomizableElytraItem)item;
        if (item2.isCapeHidden(wing)) {
            lines.add(CustomizationUtils.getCapeHiddenComponent());
        }
        if (item2.isGlowing(wing)) {
            lines.add(CustomizationUtils.getGlowingComponent());
        }
        if (item2.m_41113_(wing)) {
            lines.add(CustomizationUtils.getColorComponent(wing, flag));
        }
        if (item2.hasBanner(wing)) {
            lines.addAll(CustomizationUtils.getBannerComponents(wing));
        }
        if (item2.hasArmorTrim(wing) && access != null) {
            lines.addAll(CustomizationUtils.getArmorTrimComponents(wing, access));
        }
        return lines;
    }

    @NotNull
    private static Component getCapeHiddenComponent() {
        return Component.m_237115_((String)"item.customizableelytra.cape_hidden").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
    }

    @NotNull
    private static Component getGlowingComponent() {
        return Component.m_237115_((String)"item.customizableelytra.glowing_wing").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
    }

    @NotNull
    private static Component getColorComponent(ItemStack wing, TooltipFlag flag) {
        if (flag.m_7050_()) {
            return Component.m_237110_((String)"item.color", (Object[])new Object[]{String.format("#%06X", ((CustomizableElytraItem)wing.m_41720_()).m_41121_(wing))}).m_130940_(ChatFormatting.GRAY);
        }
        return Component.m_237115_((String)"item.dyed").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
    }

    @NotNull
    private static List<Component> getBannerComponents(ItemStack wing) {
        List<Pair<Holder<BannerPattern>, DyeColor>> bannerPatterns = ((CustomizableElytraItem)wing.m_41720_()).getBannerPatterns(wing);
        ArrayList<Component> lines = new ArrayList<Component>(bannerPatterns.size());
        for (Pair<Holder<BannerPattern>, DyeColor> pattern : bannerPatterns) {
            Holder patternHolder = (Holder)pattern.getFirst();
            DyeColor dyeColor = (DyeColor)pattern.getSecond();
            patternHolder.m_203543_().map(bannerPatternResourceKey -> bannerPatternResourceKey.m_135782_().m_214299_()).ifPresent(location -> {
                ResourceLocation bannerPatternLocation = new ResourceLocation(location);
                lines.add((Component)Component.m_237115_((String)("block." + bannerPatternLocation.m_135827_() + ".banner." + bannerPatternLocation.m_135815_() + "." + dyeColor.m_41065_())).m_130940_(ChatFormatting.GRAY));
            });
        }
        return lines;
    }

    @NotNull
    private static List<Component> getArmorTrimComponents(ItemStack wing, @Nullable RegistryAccess access) {
        if (access == null) {
            return List.of();
        }
        ArrayList<Component> lines = new ArrayList<Component>(3);
        ArmorTrim.m_266563_((ItemStack)wing, (RegistryAccess)access, lines);
        return lines;
    }

    public static void addComponentsToLists(ElytraCustomization customization, List<Component> common, List<Component> left, List<Component> right, Predicate<ItemStack> hasComponent, Function<ItemStack, List<Component>> componentProvider) {
        ItemStack leftWing = customization.leftWing();
        ItemStack rightWing = customization.rightWing();
        if (hasComponent.test(leftWing)) {
            List<Component> leftWingComponents = componentProvider.apply(leftWing);
            if (hasComponent.test(rightWing)) {
                List<Component> rightWingComponents = componentProvider.apply(rightWing);
                if (leftWingComponents.equals(rightWingComponents)) {
                    common.addAll(leftWingComponents);
                } else {
                    left.addAll(leftWingComponents);
                    right.addAll(rightWingComponents);
                }
            } else {
                left.addAll(leftWingComponents);
            }
        } else if (hasComponent.test(rightWing)) {
            right.addAll((Collection<Component>)componentProvider.apply(rightWing));
        }
    }

    public static List<Component> getElytraTooltipLines(ItemStack elytra, TooltipFlag flag, @Nullable RegistryAccess access) {
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(elytra);
        ArrayList<Component> leftWingLines = new ArrayList<Component>();
        ArrayList<Component> rightWingLines = new ArrayList<Component>();
        ArrayList<Component> outputLines = new ArrayList<Component>();
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.m_41720_()).isGlowing((ItemStack)stack), stack -> List.of(CustomizationUtils.getGlowingComponent()));
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.m_41720_()).isCapeHidden((ItemStack)stack), stack -> List.of(CustomizationUtils.getCapeHiddenComponent()));
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.m_41720_()).m_41113_((ItemStack)stack), stack -> List.of(CustomizationUtils.getColorComponent(stack, flag)));
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.m_41720_()).hasBanner((ItemStack)stack), CustomizationUtils::getBannerComponents);
        CustomizationUtils.addComponentsToLists(customization, outputLines, leftWingLines, rightWingLines, stack -> ((CustomizableElytraItem)stack.m_41720_()).hasArmorTrim((ItemStack)stack), stack -> CustomizationUtils.getArmorTrimComponents(stack, access));
        if (!leftWingLines.isEmpty()) {
            outputLines.add((Component)Component.m_237115_((String)"item.customizableelytra.left_wing").m_130940_(ChatFormatting.GRAY));
            outputLines.addAll(leftWingLines);
        }
        if (!rightWingLines.isEmpty()) {
            outputLines.add((Component)Component.m_237115_((String)"item.customizableelytra.right_wing").m_130940_(ChatFormatting.GRAY));
            outputLines.addAll(rightWingLines);
        }
        return outputLines;
    }
}

