/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.data.client;

import com.hidoni.customizableelytra.Constants;
import com.hidoni.customizableelytra.mixin.datagen.ItemModelBuilderAccessor;
import com.hidoni.customizableelytra.mixin.datagen.ModelBuilderAccessor;
import com.hidoni.customizableelytra.mixin.datagen.OverrideBuilderAccessor;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, String modid, ExistingFileHelper existingFileHelper) {
        super(output, modid, existingFileHelper);
    }

    private static ResourceLocation getTrimmedItemPath(ResourceLocation path, ItemModelGenerators.TrimModelData trim) {
        if (!path.m_135815_().startsWith("item/")) {
            path = path.m_246208_("item/");
        }
        return path.m_266382_("_" + trim.f_265890_() + "_trim");
    }

    private ItemModelBuilder generateItemWithTrims(ResourceLocation path, ResourceLocation ... textures) {
        ItemModelBuilder baseItemBuilder = this.generateBaseItemBuilder(path, textures);
        for (ItemModelGenerators.TrimModelData trim : ItemModelGenerators.f_265952_) {
            ResourceLocation trimmedItemPath = ModItemModelProvider.getTrimmedItemPath(path, trim);
            baseItemBuilder.override().predicate(ItemModelGenerators.f_265922_, trim.f_265849_()).model((ModelFile)new ModelFile.UncheckedModelFile(trimmedItemPath)).end();
            ItemModelBuilder trimmedItemBuilder = this.generateBaseItemBuilder(trimmedItemPath, textures);
            ((ModelBuilderAccessor)trimmedItemBuilder).getTextures().put("layer" + textures.length, this.mcLoc(path.m_135815_() + "_trim_" + trim.f_265890_()).m_246208_("trims/items/").toString());
        }
        return baseItemBuilder;
    }

    private ItemModelBuilder generateItemWithWingTrims(ResourceLocation path, ResourceLocation ... textures) {
        ItemModelBuilder trimmedItemBuilder;
        ResourceLocation trimmedItemPath;
        ItemModelBuilder baseItemBuilder = this.generateBaseItemBuilder(path, textures);
        for (ItemModelGenerators.TrimModelData leftTrim : ItemModelGenerators.f_265952_) {
            trimmedItemPath = ModItemModelProvider.getTrimmedItemPath(path, leftTrim).m_266382_("_no_trim");
            baseItemBuilder.override().predicate(Constants.ELYTRA_LEFT_WING_TRIM_TYPE_PREDICATE, leftTrim.f_265849_()).model((ModelFile)new ModelFile.UncheckedModelFile(trimmedItemPath)).end();
            trimmedItemBuilder = this.generateBaseItemBuilder(trimmedItemPath, textures);
            ((ModelBuilderAccessor)trimmedItemBuilder).getTextures().put("layer" + textures.length, this.mcLoc(path.m_135815_() + "_left_wing_trim_" + leftTrim.f_265890_()).m_246208_("trims/items/").toString());
        }
        for (ItemModelGenerators.TrimModelData rightTrim : ItemModelGenerators.f_265952_) {
            trimmedItemPath = ModItemModelProvider.getTrimmedItemPath(path.m_266382_("_no_trim"), rightTrim);
            baseItemBuilder.override().predicate(Constants.ELYTRA_RIGHT_WING_TRIM_TYPE_PREDICATE, rightTrim.f_265849_()).model((ModelFile)new ModelFile.UncheckedModelFile(trimmedItemPath)).end();
            trimmedItemBuilder = this.generateBaseItemBuilder(trimmedItemPath, textures);
            ((ModelBuilderAccessor)trimmedItemBuilder).getTextures().put("layer" + textures.length, this.mcLoc(path.m_135815_() + "_right_wing_trim_" + rightTrim.f_265890_()).m_246208_("trims/items/").toString());
        }
        for (ItemModelGenerators.TrimModelData leftTrim : ItemModelGenerators.f_265952_) {
            for (ItemModelGenerators.TrimModelData rightTrim : ItemModelGenerators.f_265952_) {
                ResourceLocation trimmedItemPath2 = ModItemModelProvider.getTrimmedItemPath(ModItemModelProvider.getTrimmedItemPath(path, leftTrim), rightTrim);
                baseItemBuilder.override().predicate(Constants.ELYTRA_LEFT_WING_TRIM_TYPE_PREDICATE, leftTrim.f_265849_()).predicate(Constants.ELYTRA_RIGHT_WING_TRIM_TYPE_PREDICATE, rightTrim.f_265849_()).model((ModelFile)new ModelFile.UncheckedModelFile(trimmedItemPath2)).end();
                ItemModelBuilder trimmedItemBuilder2 = this.generateBaseItemBuilder(trimmedItemPath2, textures);
                ((ModelBuilderAccessor)trimmedItemBuilder2).getTextures().put("layer" + textures.length, this.mcLoc(path.m_135815_() + "_left_wing_trim_" + leftTrim.f_265890_()).m_246208_("trims/items/").toString());
                ((ModelBuilderAccessor)trimmedItemBuilder2).getTextures().put("layer" + (textures.length + 1), this.mcLoc(path.m_135815_() + "_right_wing_trim_" + rightTrim.f_265890_()).m_246208_("trims/items/").toString());
            }
        }
        return baseItemBuilder;
    }

    private ItemModelBuilder generateBaseItemBuilder(ResourceLocation path, ResourceLocation[] textures) {
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(this.mcLoc("item/generated"));
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path.toString())).parent((ModelFile)itemGenerated);
        for (int i = 0; i < textures.length; ++i) {
            builder.texture("layer" + i, textures[i]);
        }
        return builder;
    }

    protected void registerModels() {
        ItemModelBuilder brokenElytra = this.generateItemWithWingTrims(this.mcLoc("broken_elytra"), this.modLoc("item/broken_elytra_left"), this.modLoc("item/broken_elytra_right"));
        ItemModelBuilder elytra = this.generateItemWithWingTrims(this.mcLoc("elytra"), this.modLoc("item/elytra_left"), this.modLoc("item/elytra_right"));
        elytra.override().predicate(this.mcLoc("broken"), 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/broken_elytra"))).end();
        for (ItemModelBuilder.OverrideBuilder overrideBuilder : ((ItemModelBuilderAccessor)brokenElytra).getOverrides()) {
            ItemModelBuilder.OverrideBuilder override = elytra.override();
            for (Map.Entry<ResourceLocation, Float> predicate : ((OverrideBuilderAccessor)overrideBuilder).getPredicates().entrySet()) {
                override.predicate(predicate.getKey(), predicate.getValue().floatValue());
            }
            override.predicate(this.mcLoc("broken"), 1.0f).model(((OverrideBuilderAccessor)overrideBuilder).getModel()).end();
        }
        this.generateItemWithTrims(this.modLoc("elytra_wing"), this.modLoc("item/elytra_wing"));
    }
}

