/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.recipe;

import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.customization.ElytraCustomization;
import com.hidoni.customizableelytra.item.ElytraWingItem;
import com.hidoni.customizableelytra.registry.ModRecipes;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CombineWingsRecipe
extends CustomRecipe {
    public CombineWingsRecipe(CraftingBookCategory category) {
        super(category);
    }

    private static void copyWingAttributesToElytra(ItemStack leftWing, ItemStack rightWing, ItemStack elytra) {
        elytra.m_41721_((leftWing.m_41773_() + rightWing.m_41773_()) / 2);
        elytra.m_41742_((leftWing.m_41610_() + rightWing.m_41610_()) / 2);
        elytra.m_41787_();
        if (leftWing.m_41788_()) {
            elytra.m_41714_(leftWing.m_41786_());
        } else if (rightWing.m_41788_()) {
            elytra.m_41714_(rightWing.m_41786_());
        }
        if (!EnchantmentHelper.m_44831_((ItemStack)leftWing).isEmpty()) {
            EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)leftWing), (ItemStack)elytra);
        } else if (!EnchantmentHelper.m_44831_((ItemStack)rightWing).isEmpty()) {
            EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)rightWing), (ItemStack)elytra);
        }
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level level) {
        ItemStack leftWing = ItemStack.f_41583_;
        ItemStack rightWing = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (!(stack.m_41720_() instanceof ElytraWingItem)) {
                return false;
            }
            if (!leftWing.m_41619_()) {
                if (!rightWing.m_41619_()) {
                    return false;
                }
                rightWing = stack;
                continue;
            }
            leftWing = stack;
        }
        return !leftWing.m_41619_() && !rightWing.m_41619_();
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess access) {
        ItemStack leftWing = ItemStack.f_41583_;
        ItemStack rightWing = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (!(stack.m_41720_() instanceof ElytraWingItem)) {
                return ItemStack.f_41583_;
            }
            if (!leftWing.m_41619_()) {
                if (!rightWing.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                rightWing = stack;
                continue;
            }
            leftWing = stack;
        }
        ElytraCustomization customization = new ElytraCustomization(CustomizationUtils.copyCustomizationTagToNewStack(leftWing), CustomizationUtils.copyCustomizationTagToNewStack(rightWing));
        ItemStack elytra = new ItemStack((ItemLike)Items.f_42741_);
        CombineWingsRecipe.copyWingAttributesToElytra(leftWing, rightWing, elytra);
        customization.saveToElytra(elytra);
        return elytra;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.COMBINE_WINGS_RECIPE.get();
    }
}

