/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.recipe;

import com.hidoni.customizableelytra.ElytraUtils;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.customization.ElytraCustomization;
import com.hidoni.customizableelytra.item.CustomizableElytraItem;
import com.hidoni.customizableelytra.registry.ModRecipes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ElytraBannerRecipe
extends CustomRecipe {
    public ElytraBannerRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level level) {
        CustomizableElytraItem wingItem;
        ItemStack stack;
        ItemStack customizableStack = ItemStack.f_41583_;
        ItemStack bannerStack = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (ElytraUtils.isElytra(stack) || stack.m_41720_() instanceof CustomizableElytraItem) {
                if (!customizableStack.m_41619_()) {
                    return false;
                }
                customizableStack = stack;
                continue;
            }
            if (!(stack.m_41720_() instanceof BannerItem)) continue;
            if (!bannerStack.m_41619_()) {
                return false;
            }
            bannerStack = stack;
        }
        if (customizableStack.m_41619_() || bannerStack.m_41619_()) {
            return false;
        }
        stack = customizableStack.m_41720_();
        if (stack instanceof CustomizableElytraItem && ElytraBannerRecipe.isWingAlreadyCustomized(customizableStack, wingItem = (CustomizableElytraItem)stack)) {
            return false;
        }
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack);
        ItemStack leftWing = customization.leftWing();
        ItemStack rightWing = customization.rightWing();
        CustomizableElytraItem leftWingItem = (CustomizableElytraItem)leftWing.m_41720_();
        CustomizableElytraItem rightWingItem = (CustomizableElytraItem)rightWing.m_41720_();
        return ElytraBannerRecipe.canWingBeCustomized(leftWing, leftWingItem) && (ElytraBannerRecipe.canWingBeCustomized(rightWing, rightWingItem) || !ElytraBannerRecipe.isWingAlreadyCustomized(leftWing, leftWingItem) || !ElytraBannerRecipe.isWingAlreadyCustomized(rightWing, rightWingItem));
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess access) {
        ItemStack stack;
        ItemStack customizableStack = ItemStack.f_41583_;
        ItemStack bannerStack = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (ElytraUtils.isElytra(stack) || stack.m_41720_() instanceof CustomizableElytraItem) {
                if (!customizableStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                customizableStack = stack.m_41777_();
                continue;
            }
            if (!(stack.m_41720_() instanceof BannerItem)) continue;
            if (!bannerStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            bannerStack = stack;
        }
        if (customizableStack.m_41619_() || bannerStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        stack = customizableStack.m_41720_();
        if (stack instanceof CustomizableElytraItem) {
            CustomizableElytraItem wingItem = (CustomizableElytraItem)stack;
            if (ElytraBannerRecipe.isWingAlreadyCustomized(customizableStack, wingItem)) {
                return ItemStack.f_41583_;
            }
            ElytraBannerRecipe.modifyWing(customizableStack, bannerStack, wingItem);
        } else {
            ElytraCustomization customization = CustomizationUtils.getElytraCustomization(customizableStack);
            ItemStack leftWing = customization.leftWing();
            ItemStack rightWing = customization.rightWing();
            CustomizableElytraItem leftWingItem = (CustomizableElytraItem)leftWing.m_41720_();
            CustomizableElytraItem rightWingItem = (CustomizableElytraItem)rightWing.m_41720_();
            if (!ElytraBannerRecipe.canWingBeCustomized(leftWing, leftWingItem) || !ElytraBannerRecipe.canWingBeCustomized(rightWing, rightWingItem) || ElytraBannerRecipe.isWingAlreadyCustomized(leftWing, leftWingItem) && ElytraBannerRecipe.isWingAlreadyCustomized(rightWing, rightWingItem)) {
                return ItemStack.f_41583_;
            }
            ElytraBannerRecipe.modifyWing(leftWing, bannerStack, leftWingItem);
            ElytraBannerRecipe.modifyWing(rightWing, bannerStack, rightWingItem);
            customization.saveToElytra(customizableStack);
        }
        return customizableStack;
    }

    private static void modifyWing(ItemStack wingStack, ItemStack modifier, CustomizableElytraItem wingItem) {
        wingItem.setBanner(wingStack, modifier);
    }

    private static boolean isWingAlreadyCustomized(ItemStack wingStack, CustomizableElytraItem wingItem) {
        return wingItem.hasBanner(wingStack);
    }

    private static boolean canWingBeCustomized(ItemStack wingStack, CustomizableElytraItem wingItem) {
        return wingItem.canApplyBanner(wingStack);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ELYTRA_BANNER_RECIPE.get();
    }
}

