/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.recipe;

import com.hidoni.customizableelytra.ElytraUtils;
import com.hidoni.customizableelytra.customization.CustomizationUtils;
import com.hidoni.customizableelytra.customization.ElytraCustomization;
import com.hidoni.customizableelytra.registry.ModRecipes;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class SplitToWingsRecipe
extends CustomRecipe {
    public SplitToWingsRecipe(CraftingBookCategory category) {
        super(category);
    }

    private ItemStack getElytraItem(@NotNull CraftingContainer inv) {
        ItemStack elytraItem = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack item = inv.m_8020_(i);
            if (item.m_41619_()) continue;
            if (!ElytraUtils.isElytra(item)) {
                return ItemStack.f_41583_;
            }
            if (!elytraItem.m_41619_()) {
                return ItemStack.f_41583_;
            }
            elytraItem = item;
        }
        return elytraItem;
    }

    private static void copyElytraAttributesToWing(ItemStack wing, ItemStack elytra) {
        wing.m_41721_(elytra.m_41773_());
        wing.m_41742_(elytra.m_41610_());
        wing.m_41787_();
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level level) {
        return !this.getElytraItem(inv).m_41619_();
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registryAccess) {
        ItemStack elytraItem = this.getElytraItem(inv);
        if (elytraItem.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ElytraCustomization customization = CustomizationUtils.getElytraCustomization(elytraItem);
        ItemStack leftWing = customization.leftWing();
        SplitToWingsRecipe.copyElytraAttributesToWing(leftWing, elytraItem);
        EnchantmentHelper.m_44865_((Map)EnchantmentHelper.m_44831_((ItemStack)elytraItem), (ItemStack)leftWing);
        if (elytraItem.m_41788_()) {
            leftWing.m_41714_(elytraItem.m_41786_());
        }
        return leftWing;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer inv) {
        NonNullList remainingItems = super.m_7457_((Container)inv);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack elytraItem = inv.m_8020_(i);
            if (!ElytraUtils.isElytra(elytraItem) || remainingItems.get(i) != ItemStack.f_41583_) continue;
            ElytraCustomization customization = CustomizationUtils.getElytraCustomization(elytraItem);
            ItemStack rightWing = customization.rightWing();
            SplitToWingsRecipe.copyElytraAttributesToWing(rightWing, elytraItem);
            remainingItems.set(i, (Object)rightWing);
        }
        return remainingItems;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.SPLIT_TO_WINGS_RECIPE.get();
    }
}

