/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.rsx.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lupicus.rsx.block.ModBlocks;
import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class BluestoneWireBlock
extends Block {
    public static final MapCodec<BluestoneWireBlock> CODEC = BluestoneWireBlock.m_306223_(BluestoneWireBlock::new);
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.f_61383_;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.f_61382_;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.f_61384_;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.f_61385_;
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final Map<Direction, EnumProperty<RedstoneSide>> FACING_PROPERTY_MAP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    private static final VoxelShape DOT_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final Map<Direction, VoxelShape> SIDE_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<Direction, VoxelShape> UP_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.m_83110_((VoxelShape)SIDE_SHAPES.get(Direction.NORTH), (VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)Direction.SOUTH, (Object)Shapes.m_83110_((VoxelShape)SIDE_SHAPES.get(Direction.SOUTH), (VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)Direction.EAST, (Object)Shapes.m_83110_((VoxelShape)SIDE_SHAPES.get(Direction.EAST), (VoxelShape)Block.m_49796_((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)Direction.WEST, (Object)Shapes.m_83110_((VoxelShape)SIDE_SHAPES.get(Direction.WEST), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private static final Map<BlockState, VoxelShape> SHAPES_CACHE = Maps.newHashMap();
    private static final Vector3f[] COLORS = new Vector3f[16];
    private final BlockState powerDot;
    private RedStoneWireBlock wire = (RedStoneWireBlock)Blocks.f_50088_;

    public MapCodec<BluestoneWireBlock> m_304657_() {
        return CODEC;
    }

    public BluestoneWireBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(NORTH, (Comparable)RedstoneSide.NONE)).m_61124_(EAST, (Comparable)RedstoneSide.NONE)).m_61124_(SOUTH, (Comparable)RedstoneSide.NONE)).m_61124_(WEST, (Comparable)RedstoneSide.NONE)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
        this.powerDot = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(NORTH, (Comparable)RedstoneSide.SIDE)).m_61124_(EAST, (Comparable)RedstoneSide.SIDE)).m_61124_(SOUTH, (Comparable)RedstoneSide.SIDE)).m_61124_(WEST, (Comparable)RedstoneSide.SIDE);
        for (BlockState blockstate : this.m_49965_().m_61056_()) {
            if ((Integer)blockstate.m_61143_((Property)POWER) != 0) continue;
            SHAPES_CACHE.put(blockstate, this.calculateShape(blockstate));
        }
    }

    private VoxelShape calculateShape(BlockState state) {
        VoxelShape voxelshape = DOT_SHAPE;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.m_61143_((Property)FACING_PROPERTY_MAP.get(direction));
            if (redstoneside == RedstoneSide.SIDE) {
                voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SIDE_SHAPES.get(direction));
                continue;
            }
            if (redstoneside != RedstoneSide.UP) continue;
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)UP_SHAPES.get(direction));
        }
        return voxelshape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES_CACHE.get(state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getConnectionState((BlockGetter)context.m_43725_(), this.powerDot, context.m_8083_());
    }

    private BlockState getConnectionState(BlockGetter world, BlockState state, BlockPos pos) {
        boolean flag = BluestoneWireBlock.isDot(state);
        state = this.getMissingConnections(world, (BlockState)this.m_49966_().m_61124_((Property)POWER, (Comparable)((Integer)state.m_61143_((Property)POWER))), pos);
        if (flag && BluestoneWireBlock.isDot(state)) {
            return state;
        }
        boolean flag1 = ((RedstoneSide)state.m_61143_(NORTH)).m_61761_();
        boolean flag2 = ((RedstoneSide)state.m_61143_(SOUTH)).m_61761_();
        boolean flag3 = ((RedstoneSide)state.m_61143_(EAST)).m_61761_();
        boolean flag4 = ((RedstoneSide)state.m_61143_(WEST)).m_61761_();
        if (!flag1 && !flag2) {
            if (!flag4) {
                state = (BlockState)state.m_61124_(WEST, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag3) {
                state = (BlockState)state.m_61124_(EAST, (Comparable)RedstoneSide.SIDE);
            }
        }
        if (!flag3 && !flag4) {
            if (!flag1) {
                state = (BlockState)state.m_61124_(NORTH, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag2) {
                state = (BlockState)state.m_61124_(SOUTH, (Comparable)RedstoneSide.SIDE);
            }
        }
        return state;
    }

    private BlockState getMissingConnections(BlockGetter world, BlockState state, BlockPos pos) {
        boolean flag = !world.m_8055_(pos.m_7494_()).m_60796_(world, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            EnumProperty<RedstoneSide> prop = FACING_PROPERTY_MAP.get(direction);
            if (((RedstoneSide)state.m_61143_(prop)).m_61761_()) continue;
            state = (BlockState)state.m_61124_(prop, (Comparable)this.getConnectingSide(world, pos, direction, flag));
        }
        return state;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return !this.canSurviveOn((BlockGetter)worldIn, facingPos, facingState) ? Blocks.f_50016_.m_49966_() : stateIn;
        }
        if (facing == Direction.UP) {
            return this.getConnectionState((BlockGetter)worldIn, stateIn, currentPos);
        }
        RedstoneSide redstoneside = this.getConnectingSide((BlockGetter)worldIn, currentPos, facing);
        return redstoneside.m_61761_() == ((RedstoneSide)stateIn.m_61143_((Property)FACING_PROPERTY_MAP.get(facing))).m_61761_() && !BluestoneWireBlock.isCross(stateIn) ? (BlockState)stateIn.m_61124_((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)redstoneside) : this.getConnectionState((BlockGetter)worldIn, (BlockState)((BlockState)this.powerDot.m_61124_((Property)POWER, (Comparable)((Integer)stateIn.m_61143_((Property)POWER)))).m_61124_((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)redstoneside), currentPos);
    }

    private static boolean isCross(BlockState state) {
        return ((RedstoneSide)state.m_61143_(NORTH)).m_61761_() && ((RedstoneSide)state.m_61143_(SOUTH)).m_61761_() && ((RedstoneSide)state.m_61143_(EAST)).m_61761_() && ((RedstoneSide)state.m_61143_(WEST)).m_61761_();
    }

    private static boolean isDot(BlockState state) {
        return !((RedstoneSide)state.m_61143_(NORTH)).m_61761_() && !((RedstoneSide)state.m_61143_(SOUTH)).m_61761_() && !((RedstoneSide)state.m_61143_(EAST)).m_61761_() && !((RedstoneSide)state.m_61143_(WEST)).m_61761_();
    }

    public void m_7742_(BlockState state, LevelAccessor worldIn, BlockPos pos, int flags, int p_196248_5_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.m_61143_((Property)FACING_PROPERTY_MAP.get(direction));
            if (redstoneside == RedstoneSide.NONE || worldIn.m_8055_((BlockPos)blockpos$mutable.m_122159_((Vec3i)pos, direction)).m_60713_((Block)this)) continue;
            blockpos$mutable.m_122173_(Direction.DOWN);
            BlockState blockstate = worldIn.m_8055_((BlockPos)blockpos$mutable);
            if (!blockstate.m_60713_(Blocks.f_50455_)) {
                BlockPos blockpos = blockpos$mutable.m_121945_(direction.m_122424_());
                BlockState blockstate1 = blockstate.m_60728_(direction.m_122424_(), worldIn.m_8055_(blockpos), worldIn, (BlockPos)blockpos$mutable, blockpos);
                BluestoneWireBlock.m_49908_((BlockState)blockstate, (BlockState)blockstate1, (LevelAccessor)worldIn, (BlockPos)blockpos$mutable, (int)flags, (int)p_196248_5_);
            }
            blockpos$mutable.m_122159_((Vec3i)pos, direction).m_122173_(Direction.UP);
            BlockState blockstate3 = worldIn.m_8055_((BlockPos)blockpos$mutable);
            if (blockstate3.m_60713_(Blocks.f_50455_)) continue;
            BlockPos blockpos1 = blockpos$mutable.m_121945_(direction.m_122424_());
            BlockState blockstate2 = blockstate3.m_60728_(direction.m_122424_(), worldIn.m_8055_(blockpos1), worldIn, (BlockPos)blockpos$mutable, blockpos1);
            BluestoneWireBlock.m_49908_((BlockState)blockstate3, (BlockState)blockstate2, (LevelAccessor)worldIn, (BlockPos)blockpos$mutable, (int)flags, (int)p_196248_5_);
        }
    }

    private RedstoneSide getConnectingSide(BlockGetter worldIn, BlockPos pos, Direction face) {
        BlockPos blockpos1 = pos.m_7494_();
        return this.getConnectingSide(worldIn, pos, face, !worldIn.m_8055_(blockpos1).m_60796_(worldIn, blockpos1));
    }

    private RedstoneSide getConnectingSide(BlockGetter worldIn, BlockPos pos, Direction face, boolean checkUp) {
        BlockPos blockpos = pos.m_121945_(face);
        BlockState blockstate = worldIn.m_8055_(blockpos);
        if (checkUp) {
            boolean flag;
            boolean bl = flag = blockstate.m_60734_() instanceof TrapDoorBlock || this.canSurviveOn(worldIn, blockpos, blockstate);
            if (flag && BluestoneWireBlock.shouldConnectTo(worldIn.m_8055_(blockpos.m_7494_()), worldIn, blockpos.m_7494_(), null)) {
                if (blockstate.m_60783_(worldIn, blockpos, face.m_122424_())) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        if (BluestoneWireBlock.shouldConnectTo(blockstate, worldIn, blockpos, face)) {
            return RedstoneSide.SIDE;
        }
        if (blockstate.m_60796_(worldIn, blockpos)) {
            return RedstoneSide.NONE;
        }
        BlockPos blockPosBelow = blockpos.m_7495_();
        return BluestoneWireBlock.shouldConnectTo(worldIn.m_8055_(blockPosBelow), worldIn, blockPosBelow, null) ? RedstoneSide.SIDE : RedstoneSide.NONE;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        return this.canSurviveOn((BlockGetter)worldIn, blockpos, blockstate);
    }

    private boolean canSurviveOn(BlockGetter world, BlockPos pos, BlockState state) {
        return state.m_60783_(world, pos, Direction.UP) || state.m_60713_(Blocks.f_50332_);
    }

    private void updatePowerStrength(Level worldIn, BlockPos pos, BlockState state) {
        int i = this.calculateTargetStrength(worldIn, pos);
        if ((Integer)state.m_61143_((Property)POWER) != i) {
            if (worldIn.m_8055_(pos) == state) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(i)), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(pos);
            for (Direction direction : Direction.values()) {
                set.add(pos.m_121945_(direction));
            }
            for (BlockPos blockpos : set) {
                worldIn.m_46672_(blockpos, (Block)this);
            }
        }
    }

    private int calculateTargetStrength(Level world, BlockPos posIn) {
        this.wire.f_55508_ = false;
        int i = world.m_277086_(posIn);
        this.wire.f_55508_ = true;
        int j = 0;
        if (i < 15) {
            BlockPos blockpos1 = posIn.m_7494_();
            Boolean isUpNormal = world.m_8055_(blockpos1).m_60796_((BlockGetter)world, blockpos1);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = posIn.m_121945_(direction);
                BlockState blockstate = world.m_8055_(blockpos);
                j = Math.max(j, this.getLineSignal(blockstate));
                if (blockstate.m_60796_((BlockGetter)world, blockpos)) {
                    if (isUpNormal.booleanValue()) continue;
                    j = Math.max(j, this.getWireSignal(world.m_8055_(blockpos.m_7494_())));
                    continue;
                }
                j = Math.max(j, this.getWireSignal(world.m_8055_(blockpos.m_7495_())));
            }
        }
        return Math.max(i, j - 1);
    }

    private int getWireSignal(BlockState neighbor) {
        return neighbor.m_60713_((Block)this) ? (Integer)neighbor.m_61143_((Property)POWER) : 0;
    }

    private int getLineSignal(BlockState neighbor) {
        return neighbor.m_60713_((Block)this) || neighbor.m_60713_(ModBlocks.BLUESTONE_PIPE_BLOCK) ? (Integer)neighbor.m_61143_((Property)POWER) : 0;
    }

    private void checkCornerChangeAt(Level worldIn, BlockPos pos) {
        if (worldIn.m_8055_(pos).m_60713_((Block)this)) {
            worldIn.m_46672_(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                worldIn.m_46672_(pos.m_121945_(direction), (Block)this);
            }
        }
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_()) && !worldIn.f_46443_) {
            this.updatePowerStrength(worldIn, pos, state);
            for (Direction direction : Direction.Plane.VERTICAL) {
                worldIn.m_46672_(pos.m_121945_(direction), (Block)this);
            }
            this.updateNeighborsOfNeighboringWires(worldIn, pos);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, worldIn, pos, newState, isMoving);
            if (!worldIn.f_46443_) {
                for (Direction direction : Direction.values()) {
                    worldIn.m_46672_(pos.m_121945_(direction), (Block)this);
                }
                this.updatePowerStrength(worldIn, pos, state);
                this.updateNeighborsOfNeighboringWires(worldIn, pos);
            }
        }
    }

    private void updateNeighborsOfNeighboringWires(Level world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.checkCornerChangeAt(world, pos.m_121945_(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.m_121945_(direction1);
            if (world.m_8055_(blockpos).m_60796_((BlockGetter)world, blockpos)) {
                this.checkCornerChangeAt(world, blockpos.m_7494_());
                continue;
            }
            this.checkCornerChangeAt(world, blockpos.m_7495_());
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.f_46443_) {
            if (state.m_60710_((LevelReader)worldIn, pos)) {
                this.updatePowerStrength(worldIn, pos, state);
            } else {
                BluestoneWireBlock.m_49950_((BlockState)state, (Level)worldIn, (BlockPos)pos);
                worldIn.m_7471_(pos, false);
            }
        }
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return !this.wire.f_55508_ ? 0 : blockState.m_60746_(blockAccess, pos, side);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (!this.wire.f_55508_ || side == Direction.DOWN) {
            return 0;
        }
        int i = (Integer)blockState.m_61143_((Property)POWER);
        if (i == 0) {
            return 0;
        }
        return side == Direction.UP || ((RedstoneSide)this.getConnectionState(blockAccess, blockState, pos).m_61143_((Property)FACING_PROPERTY_MAP.get(side.m_122424_()))).m_61761_() ? i : 0;
    }

    protected static boolean shouldConnectTo(BlockState blockState, BlockGetter world, BlockPos pos, @Nullable Direction side) {
        if (blockState.m_60713_(ModBlocks.BLUESTONE_WIRE)) {
            return true;
        }
        if (blockState.m_60713_(ModBlocks.BLUESTONE_PIPE_BLOCK)) {
            return side != null;
        }
        if (blockState.m_60713_(Blocks.f_50088_) || blockState.m_60713_(ModBlocks.REDSTONE_PIPE_BLOCK)) {
            return false;
        }
        return side != null && blockState.canRedstoneConnectTo(world, pos, side);
    }

    public boolean m_7899_(BlockState state) {
        return this.wire.f_55508_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int colorMultiplier(int power) {
        Vector3f vector3f = COLORS[power];
        return Mth.m_14159_((float)vector3f.x(), (float)vector3f.y(), (float)vector3f.z());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticlesAlongLine(Level world, RandomSource rand, BlockPos pos, Vector3f vec, Direction dir1, Direction dir2, float fv1, float fv2) {
        float f = fv2 - fv1;
        if (!(rand.m_188501_() >= 0.2f * f)) {
            float f1 = 0.4375f;
            float f2 = fv1 + f * rand.m_188501_();
            double d0 = 0.5 + (double)(f1 * (float)dir1.m_122429_()) + (double)(f2 * (float)dir2.m_122429_());
            double d1 = 0.5 + (double)(f1 * (float)dir1.m_122430_()) + (double)(f2 * (float)dir2.m_122430_());
            double d2 = 0.5 + (double)(f1 * (float)dir1.m_122431_()) + (double)(f2 * (float)dir2.m_122431_());
            world.m_7106_((ParticleOptions)new DustParticleOptions(vec, 1.0f), (double)pos.m_123341_() + d0, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        int i = (Integer)stateIn.m_61143_((Property)POWER);
        if (i != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)stateIn.m_61143_((Property)FACING_PROPERTY_MAP.get(direction));
                switch (redstoneside) {
                    case UP: {
                        this.spawnParticlesAlongLine(worldIn, rand, pos, COLORS[i], direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.spawnParticlesAlongLine(worldIn, rand, pos, COLORS[i], Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.spawnParticlesAlongLine(worldIn, rand, pos, COLORS[i], Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)))).m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(NORTH)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(EAST)))).m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(NORTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(EAST)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(EAST)));
            }
        }
        return super.m_6943_(state, mirrorIn);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, POWER});
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!player.m_36326_()) {
            return InteractionResult.PASS;
        }
        boolean flag = BluestoneWireBlock.isCross(state);
        if (flag || BluestoneWireBlock.isDot(state)) {
            BlockState blockstate = flag ? this.m_49966_() : this.powerDot;
            blockstate = (BlockState)blockstate.m_61124_((Property)POWER, (Comparable)((Integer)state.m_61143_((Property)POWER)));
            if ((blockstate = this.getConnectionState((BlockGetter)worldIn, blockstate, pos)) != state) {
                worldIn.m_7731_(pos, blockstate, 3);
                this.updatesOnShapeChange(worldIn, pos, state, blockstate);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void updatesOnShapeChange(Level world, BlockPos pos, BlockState oldState, BlockState state) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.m_121945_(direction);
            EnumProperty<RedstoneSide> prop = FACING_PROPERTY_MAP.get(direction);
            if (((RedstoneSide)oldState.m_61143_(prop)).m_61761_() == ((RedstoneSide)state.m_61143_(prop)).m_61761_() || !world.m_8055_(blockpos).m_60796_((BlockGetter)world, blockpos)) continue;
            world.m_46590_(blockpos, state.m_60734_(), direction.m_122424_());
        }
    }

    static {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float f3 = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f2 = Mth.m_14036_((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float f1 = Mth.m_14036_((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            BluestoneWireBlock.COLORS[i] = new Vector3f(f1, f2, f3);
        }
    }
}

