/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.rsx.block;

import com.mojang.serialization.MapCodec;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import org.joml.Vector3f;

public class RedstoneBenderBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<RedstoneBenderBlock> CODEC = RedstoneBenderBlock.m_306223_(RedstoneBenderBlock::new);
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    protected MapCodec<? extends RedstoneBenderBlock> m_304657_() {
        return CODEC;
    }

    protected RedstoneBenderBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        return this.canSurviveOn(worldIn, blockpos, worldIn.m_8055_(blockpos));
    }

    protected boolean canSurviveOn(LevelReader world, BlockPos pos, BlockState state) {
        return state.m_60659_((BlockGetter)world, pos, Direction.UP, SupportType.RIGID);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult result) {
        if (!player.m_36326_()) {
            return InteractionResult.PASS;
        }
        HashSet<Direction> set = new HashSet<Direction>();
        if (this.getActiveSignal((BlockGetter)world, pos, state) > 0) {
            this.getSides(state, set);
        }
        Rotation rot = player.m_36341_() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
        state = this.m_6843_(state, rot);
        world.m_7731_(pos, state, 3);
        int j = this.calculateInputStrength(world, pos, state);
        state = (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(j));
        world.m_7731_(pos, state, 2);
        if (j > 1) {
            this.getSides(state, set);
        }
        this.notifyNeighbors(world, pos, state, set);
        return InteractionResult.SUCCESS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState dirState, LevelAccessor world, BlockPos pos, BlockPos dirPos) {
        if (dir == Direction.DOWN) {
            return !this.canSurviveOn((LevelReader)world, dirPos, dirState) ? Blocks.f_50016_.m_49966_() : state;
        }
        return super.m_7417_(state, dir, dirState, world, pos, dirPos);
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.m_60734_() != oldState.m_60734_()) {
            this.updateState(worldIn, pos, state);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            super.m_6810_(state, worldIn, pos, newState, isMoving);
            if (this.getActiveSignal((BlockGetter)worldIn, pos, state) > 0) {
                this.notifyNeighbors(worldIn, pos, state);
            }
        }
    }

    protected void getSides(BlockState state, Set<Direction> set) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        set.add(facing);
        set.add(facing.m_122428_());
    }

    protected void notifyNeighbors(Level worldIn, BlockPos pos, BlockState state, Set<Direction> set) {
        set.forEach(facing -> this.notifyNeighbors(worldIn, pos, state, (Direction)facing));
    }

    protected void notifyNeighbors(Level worldIn, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        this.notifyNeighbors(worldIn, pos, state, facing);
        this.notifyNeighbors(worldIn, pos, state, facing.m_122428_());
    }

    protected void notifyNeighbors(Level worldIn, BlockPos pos, BlockState state, Direction direction) {
        BlockPos blockpos = pos.m_121945_(direction);
        if (ForgeEventFactory.onNeighborNotify((Level)worldIn, (BlockPos)pos, (BlockState)worldIn.m_8055_(pos), EnumSet.of(direction), (boolean)false).isCanceled()) {
            return;
        }
        worldIn.m_46586_(blockpos, (Block)this, pos);
        worldIn.m_46590_(blockpos, (Block)this, direction.m_122424_());
    }

    protected void updateState(Level world, BlockPos pos, BlockState state) {
        int j;
        int i;
        if (!world.f_46443_ && (i = ((Integer)state.m_61143_((Property)POWER)).intValue()) != (j = this.calculateInputStrength(world, pos, state))) {
            state = (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(j));
            world.m_7731_(pos, state, 2);
            this.notifyNeighbors(world, pos, state);
        }
    }

    protected int calculateInputStrength(Level world, BlockPos pos, BlockState state) {
        BlockState blockstate;
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        BlockPos blockpos = pos.m_121945_(direction);
        int i = world.m_277185_(blockpos, direction);
        if (i >= 15) {
            return 15;
        }
        Direction direction2 = direction.m_122428_();
        BlockPos blockpos2 = pos.m_121945_(direction2);
        int i2 = world.m_277185_(blockpos2, direction2);
        if (i2 >= 15) {
            return 15;
        }
        if (i == 0 && (blockstate = world.m_8055_(blockpos)).m_60734_() == Blocks.f_50088_) {
            i = (Integer)blockstate.m_61143_((Property)RedStoneWireBlock.f_55500_);
        }
        if (i2 == 0 && (blockstate = world.m_8055_(blockpos2)).m_60734_() == Blocks.f_50088_) {
            i2 = (Integer)blockstate.m_61143_((Property)RedStoneWireBlock.f_55500_);
        }
        if (i < i2) {
            i = i2;
        }
        return i;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.m_6378_(blockState, blockAccess, pos, side);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.canConnectRedstone(blockState, blockAccess, pos, side) ? this.getActiveSignal(blockAccess, pos, blockState) : 0;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.m_60710_((LevelReader)worldIn, pos)) {
            Direction from = Direction.m_122378_((int)(pos.m_123341_() - fromPos.m_123341_()), (int)(pos.m_123342_() - fromPos.m_123342_()), (int)(pos.m_123343_() - fromPos.m_123343_()));
            if (this.canConnectRedstone(state, (BlockGetter)worldIn, pos, from)) {
                this.updateState(worldIn, pos, state);
            }
        } else {
            BlockEntity tileentity = state.m_155947_() ? worldIn.m_7702_(pos) : null;
            RedstoneBenderBlock.m_49892_((BlockState)state, (LevelAccessor)worldIn, (BlockPos)pos, (BlockEntity)tileentity);
            worldIn.m_7471_(pos, false);
        }
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    protected int getActiveSignal(BlockGetter worldIn, BlockPos pos, BlockState state) {
        int i = (Integer)state.m_61143_((Property)POWER);
        return i > 0 ? i - 1 : 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        Direction facing = ((Direction)state.m_61143_((Property)f_54117_)).m_122424_();
        return facing == side || facing.m_122428_() == side;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int colorMultiplier(int power) {
        float f = (float)power / 15.0f;
        float f1 = f * 0.6f + 0.4f;
        if (power == 0) {
            f1 = 0.3f;
        }
        float f2 = f * f * 0.7f - 0.5f;
        float f3 = f * f * 0.6f - 0.7f;
        int i = Mth.m_14045_((int)((int)(f1 * 255.0f)), (int)0, (int)255);
        int j = Mth.m_14045_((int)((int)(f2 * 255.0f)), (int)0, (int)255);
        int k = Mth.m_14045_((int)((int)(f3 * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | i << 16 | j << 8 | k;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        int i = (Integer)stateIn.m_61143_((Property)POWER);
        if (i != 0) {
            double d0 = (double)pos.m_123341_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.2;
            double d1 = (float)pos.m_123342_() + 0.1875f;
            double d2 = (double)pos.m_123343_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.2;
            float f = (float)i / 15.0f;
            float f1 = f * 0.6f + 0.4f;
            float f2 = Math.max(0.0f, f * f * 0.7f - 0.5f);
            float f3 = Math.max(0.0f, f * f * 0.6f - 0.7f);
            worldIn.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(f1, f2, f3), 1.0f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, POWER});
    }
}

