/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.rsx.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lupicus.rsx.block.ModBlocks;
import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class RedstonePipeBlock
extends TransparentBlock {
    public static final MapCodec<RedstonePipeBlock> CODEC = RedstonePipeBlock.m_306223_(RedstonePipeBlock::new);
    public static final EnumProperty<RedstoneSide> REDSTONE_UP = EnumProperty.m_61587_((String)"up", RedstoneSide.class);
    public static final EnumProperty<RedstoneSide> REDSTONE_DOWN = EnumProperty.m_61587_((String)"down", RedstoneSide.class);
    public static final EnumProperty<RedstoneSide> UP = REDSTONE_UP;
    public static final EnumProperty<RedstoneSide> DOWN = REDSTONE_DOWN;
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.f_61383_;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.f_61382_;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.f_61384_;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.f_61385_;
    public static final IntegerProperty POWER = RedStoneWireBlock.f_55500_;
    public static final Map<Direction, EnumProperty<RedstoneSide>> FACING_PROPERTY_MAP = Maps.newEnumMap((Map)ImmutableMap.builder().put((Object)Direction.NORTH, NORTH).put((Object)Direction.EAST, EAST).put((Object)Direction.SOUTH, SOUTH).put((Object)Direction.WEST, WEST).put((Object)Direction.UP, UP).put((Object)Direction.DOWN, DOWN).build());
    private static final Vector3f[] COLORS = new Vector3f[16];
    private RedStoneWireBlock wire = (RedStoneWireBlock)Blocks.f_50088_;

    public MapCodec<RedstonePipeBlock> m_304657_() {
        return CODEC;
    }

    public RedstonePipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(NORTH, (Comparable)RedstoneSide.NONE)).m_61124_(EAST, (Comparable)RedstoneSide.NONE)).m_61124_(SOUTH, (Comparable)RedstoneSide.NONE)).m_61124_(WEST, (Comparable)RedstoneSide.NONE)).m_61124_(UP, (Comparable)RedstoneSide.NONE)).m_61124_(DOWN, (Comparable)RedstoneSide.NONE)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public static boolean isNormalCube(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level iblockreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(WEST, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.WEST))).m_61124_(EAST, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.EAST))).m_61124_(NORTH, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.NORTH))).m_61124_(SOUTH, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.SOUTH))).m_61124_(UP, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.UP))).m_61124_(DOWN, (Comparable)this.getSide((BlockGetter)iblockreader, blockpos, Direction.DOWN));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)stateIn.m_61124_((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)this.getSide((BlockGetter)worldIn, currentPos, facing));
    }

    private RedstoneSide getSide(BlockGetter worldIn, BlockPos pos, Direction face) {
        BlockPos blockpos = pos.m_121945_(face);
        BlockState blockstate = worldIn.m_8055_(blockpos);
        return RedstonePipeBlock.shouldConnectTo(blockstate, worldIn, blockpos, face) ? RedstoneSide.SIDE : RedstoneSide.NONE;
    }

    private void updatePowerStrength(Level worldIn, BlockPos pos, BlockState state) {
        int i = this.calculateTargetStrength(worldIn, pos);
        if ((Integer)state.m_61143_((Property)POWER) != i) {
            if (worldIn.m_8055_(pos) == state) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWER, (Comparable)Integer.valueOf(i)), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(pos);
            for (Direction direction1 : Direction.values()) {
                set.add(pos.m_121945_(direction1));
            }
            for (BlockPos blockpos : set) {
                worldIn.m_46672_(blockpos, (Block)this);
            }
        }
    }

    private int calculateTargetStrength(Level world, BlockPos pos) {
        this.wire.f_55508_ = false;
        int i = world.m_277086_(pos);
        this.wire.f_55508_ = true;
        int j = 0;
        if (i < 15) {
            for (Direction direction : Direction.values()) {
                BlockState blockstate1 = world.m_8055_(pos.m_121945_(direction));
                j = Math.max(j, this.getWireSignal(blockstate1));
            }
        }
        return Math.max(i, j - 1);
    }

    private void updateNeighborsOfNeighboringWires(Level worldIn, BlockPos pos) {
        BlockState state = worldIn.m_8055_(pos);
        if (state.m_60713_((Block)this) || state.m_60713_(Blocks.f_50088_)) {
            worldIn.m_46672_(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                worldIn.m_46672_(pos.m_121945_(direction), (Block)this);
            }
        }
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_()) && !worldIn.f_46443_) {
            this.updatePowerStrength(worldIn, pos, state);
            for (Direction direction : Direction.values()) {
                this.updateNeighborsOfNeighboringWires(worldIn, pos.m_121945_(direction));
            }
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, worldIn, pos, newState, isMoving);
            if (!worldIn.f_46443_) {
                for (Direction direction : Direction.values()) {
                    worldIn.m_46672_(pos.m_121945_(direction), (Block)this);
                }
                this.updatePowerStrength(worldIn, pos, state);
                for (Direction direction : Direction.values()) {
                    this.updateNeighborsOfNeighboringWires(worldIn, pos.m_121945_(direction));
                }
            }
        }
    }

    private int getWireSignal(BlockState neighbor) {
        return neighbor.m_60713_((Block)this) || neighbor.m_60713_(Blocks.f_50088_) ? (Integer)neighbor.m_61143_((Property)POWER) : 0;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.f_46443_) {
            this.updatePowerStrength(worldIn, pos, state);
        }
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.wire.f_55508_ ? blockState.m_60746_(blockAccess, pos, side) : 0;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.wire.f_55508_ ? (Integer)blockState.m_61143_((Property)POWER) : 0;
    }

    protected static boolean shouldConnectTo(BlockState blockState, BlockGetter world, BlockPos pos, Direction side) {
        if (blockState.m_60713_(ModBlocks.REDSTONE_PIPE_BLOCK)) {
            return true;
        }
        return blockState.canRedstoneConnectTo(world, pos, side);
    }

    public boolean m_7899_(BlockState state) {
        return this.wire.f_55508_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int colorMultiplier(int power) {
        Vector3f vector3f = COLORS[power];
        return Mth.m_14159_((float)vector3f.x(), (float)vector3f.y(), (float)vector3f.z());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        int i = (Integer)stateIn.m_61143_((Property)POWER);
        if (i != 0) {
            double d0 = (double)pos.m_123341_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.8;
            double d1 = (double)pos.m_123342_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.8;
            double d2 = (double)pos.m_123343_() + 0.5 + ((double)rand.m_188501_() - 0.5) * 0.8;
            Vector3f vec = COLORS[i];
            worldIn.m_7106_((ParticleOptions)new DustParticleOptions(vec, 1.0f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static int getLineSignalHook(BlockState neighbor) {
        return neighbor.m_60713_(Blocks.f_50088_) || neighbor.m_60713_(ModBlocks.REDSTONE_PIPE_BLOCK) ? (Integer)neighbor.m_61143_((Property)POWER) : 0;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)))).m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(NORTH)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(EAST)))).m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(NORTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(EAST)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((RedstoneSide)state.m_61143_(SOUTH)))).m_61124_(SOUTH, (Comparable)((RedstoneSide)state.m_61143_(NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.m_61124_(EAST, (Comparable)((RedstoneSide)state.m_61143_(WEST)))).m_61124_(WEST, (Comparable)((RedstoneSide)state.m_61143_(EAST)));
            }
        }
        return super.m_6943_(state, mirrorIn);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, POWER});
    }

    static {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float f1 = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f2 = Mth.m_14036_((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float f3 = Mth.m_14036_((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            RedstonePipeBlock.COLORS[i] = new Vector3f(f1, f2, f3);
        }
    }
}

