/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.rsx.tileentity;

import com.lupicus.rsx.block.RedstoneEnergyBlock;
import com.lupicus.rsx.config.MyConfig;
import com.lupicus.rsx.tileentity.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class RedstoneEnergyTileEntity
extends BlockEntity
implements IEnergyStorage,
ICapabilityProvider {
    private int count = -1;
    private int energy = -1;
    private IEnergyStorage[] sides = new IEnergyStorage[6];
    private LazyOptional<IEnergyStorage> energyOpt = LazyOptional.of(() -> this);

    public RedstoneEnergyTileEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.REDSTONE_ENERGY_BLOCK, pos, state);
    }

    public void serverTick() {
        if (this.count != 0) {
            if (this.count < 0) {
                this.updateSides();
            }
            if (this.count > 0) {
                this.giveToNeighbors();
            }
        }
    }

    public void neighborChanged() {
        this.count = -1;
        this.energy = -1;
    }

    private void giveToNeighbors() {
        int i;
        int[] want = new int[6];
        int total = 0;
        int num = 0;
        int max = this.getEnergyStored();
        for (i = 0; i < 6; ++i) {
            if (this.sides[i] != null) {
                want[i] = this.sides[i].receiveEnergy(max, true);
                if (want[i] > 0) {
                    ++num;
                }
            } else {
                want[i] = 0;
            }
            total += want[i];
        }
        if (num == 0) {
            return;
        }
        if (num == 1) {
            for (i = 0; i < 6; ++i) {
                if (want[i] <= 0) continue;
                this.sides[i].receiveEnergy(max, false);
                break;
            }
        } else if (total <= max) {
            for (i = 0; i < 6; ++i) {
                if (want[i] <= 0) continue;
                this.sides[i].receiveEnergy(want[i], false);
            }
        } else {
            int i2;
            total = max;
            int avg = total / num;
            int[] send = new int[6];
            for (i2 = 0; i2 < 6; ++i2) {
                send[i2] = want[i2] <= avg ? want[i2] : avg;
                total -= send[i2];
            }
            if (total > 0) {
                for (i2 = 0; i2 < 6; ++i2) {
                    int more = want[i2] - send[i2];
                    if (more <= 0) continue;
                    if (more >= total) {
                        int n = i2;
                        send[n] = send[n] + total;
                        break;
                    }
                    int n = i2;
                    send[n] = send[n] + more;
                    total -= more;
                }
            }
            for (i2 = 0; i2 < 6; ++i2) {
                if (send[i2] <= 0) continue;
                this.sides[i2].receiveEnergy(send[i2], false);
            }
        }
    }

    private void updateSides() {
        this.count = 0;
        BlockPos pos = this.f_58858_;
        for (Direction dir : Direction.values()) {
            BlockEntity te;
            IEnergyStorage storage = null;
            BlockPos otherPos = pos.m_121945_(dir);
            BlockState other = this.f_58857_.m_8055_(otherPos);
            if (other.m_155947_() && (te = this.f_58857_.m_7702_(otherPos)) != null) {
                storage = te instanceof IEnergyStorage ? (IEnergyStorage)te : (IEnergyStorage)te.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_()).orElse(null);
            }
            this.sides[dir.m_122411_()] = storage;
            if (storage == null) continue;
            ++this.count;
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ENERGY) {
            return this.energyOpt.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyOpt.invalidate();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract > 0) {
            int amount = this.getEnergyStored();
            if (maxExtract < amount) {
                amount = maxExtract;
            }
            return amount;
        }
        return 0;
    }

    public int getEnergyStored() {
        if (this.energy < 0) {
            BlockState blockstate = this.m_58900_();
            this.energy = (int)((double)((Integer)blockstate.m_61143_((Property)RedstoneEnergyBlock.POWER)).intValue() * MyConfig.energyFactor);
        }
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.getEnergyStored();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }
}

