/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import me.jddev0.ep.block.entity.BatteryBoxBlockEntity;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BatteryBoxBlock
extends BaseEntityBlock {
    public static final MapCodec<BatteryBoxBlock> CODEC = BatteryBoxBlock.m_306223_(BatteryBoxBlock::new);

    public BatteryBoxBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    protected MapCodec<? extends BaseEntityBlock> m_304657_() {
        return CODEC;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state) {
        return new BatteryBoxBlockEntity(blockPos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof BatteryBoxBlockEntity)) {
            return super.m_6782_(state, level, blockPos);
        }
        BatteryBoxBlockEntity batteryBoxBlockEntity = (BatteryBoxBlockEntity)blockEntity;
        return batteryBoxBlockEntity.getRedstoneOutput();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand handItem, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof BatteryBoxBlockEntity)) {
            throw new IllegalStateException("Container is invalid");
        }
        ((ServerPlayer)player).openMenu((MenuProvider)((BatteryBoxBlockEntity)blockEntity), blockPos);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BatteryBoxBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.BATTERY_BOX_ENTITY.get()), BatteryBoxBlockEntity::tick);
    }

    public static class Item
    extends BlockItem {
        public Item(Block block, Item.Properties props) {
            super(block, props);
        }

        public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
            if (Screen.m_96638_()) {
                components.add((Component)Component.m_237110_((String)"tooltip.energizedpower.capacity.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(BatteryBoxBlockEntity.CAPACITY)}).m_130940_(ChatFormatting.GRAY));
                components.add((Component)Component.m_237110_((String)"tooltip.energizedpower.transfer_rate.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(BatteryBoxBlockEntity.MAX_TRANSFER)}).m_130940_(ChatFormatting.GRAY));
            } else {
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.shift_details.txt").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }
}

