/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.serialization.MapCodec;
import java.util.function.ToIntFunction;
import me.jddev0.ep.block.entity.EnergizerBlockEntity;
import me.jddev0.ep.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class EnergizerBlock
extends BaseEntityBlock {
    public static final MapCodec<EnergizerBlock> CODEC = EnergizerBlock.m_306223_(EnergizerBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = state -> (Boolean)state.m_61143_((Property)LIT) != false ? 8 : 0;

    protected EnergizerBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> m_304657_() {
        return CODEC;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state) {
        return new EnergizerBlockEntity(blockPos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof EnergizerBlockEntity)) {
            return super.m_6782_(state, level, blockPos);
        }
        EnergizerBlockEntity energizerBlockEntity = (EnergizerBlockEntity)blockEntity;
        return energizerBlockEntity.getRedstoneOutput();
    }

    public void m_6810_(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() == newState.m_60734_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof EnergizerBlockEntity)) {
            return;
        }
        ((EnergizerBlockEntity)blockEntity).drops(level, blockPos);
        super.m_6810_(state, level, blockPos, newState, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand handItem, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof EnergizerBlockEntity)) {
            throw new IllegalStateException("Container is invalid");
        }
        ((ServerPlayer)player).openMenu((MenuProvider)((EnergizerBlockEntity)blockEntity), blockPos);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_6861_(BlockState selfState, Level level, BlockPos selfPos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(selfState, level, selfPos, fromBlock, fromPos, isMoving);
        if (level.m_5776_()) {
            return;
        }
        boolean isPowered = level.m_276867_(selfPos);
        if (isPowered != (Boolean)selfState.m_61143_((Property)POWERED)) {
            level.m_7731_(selfPos, (BlockState)selfState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)), 3);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{POWERED, FACING, LIT});
    }

    public void m_214162_(BlockState state, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            double x = (double)blockPos.m_123341_() + 0.5;
            double y = (double)blockPos.m_123342_() + 0.4;
            double z = (double)blockPos.m_123343_() + 0.5;
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            for (Direction direction : Direction.values()) {
                if (direction.m_122434_() == Direction.Axis.Y) continue;
                for (int i = 0; i < (direction == facing ? 2 : 1); ++i) {
                    double dxz = randomSource.m_188500_() * 0.6 - 0.3;
                    double dx = direction.m_122434_() == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : dxz;
                    double dy = randomSource.m_188500_() * 6.0 / 16.0;
                    double dz = direction.m_122434_() == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : dxz;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_175830_, x + dx, y + dy, z + dz, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return EnergizerBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.ENERGIZER_ENTITY.get()), EnergizerBlockEntity::tick);
    }
}

