/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.FluidTankBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.util.FluidUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class FluidTankBlock
extends BaseEntityBlock {
    public static final MapCodec<FluidTankBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.f_263723_.xmap(Tier::valueOf, Enum::toString).fieldOf("tier").forGetter(FluidTankBlock::getTier)).apply((Applicative)instance, FluidTankBlock::new));
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final Tier tier;

    public static Block getBlockFromTier(Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case Tier.SMALL -> (FluidTankBlock)((Object)ModBlocks.FLUID_TANK_SMALL.get());
            case Tier.MEDIUM -> (FluidTankBlock)((Object)ModBlocks.FLUID_TANK_MEDIUM.get());
            case Tier.LARGE -> (FluidTankBlock)((Object)ModBlocks.FLUID_TANK_LARGE.get());
        };
    }

    public FluidTankBlock(Tier tier) {
        super(tier.getProperties());
        this.tier = tier;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public Tier getTier() {
        return this.tier;
    }

    protected MapCodec<? extends BaseEntityBlock> m_304657_() {
        return CODEC;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state) {
        return new FluidTankBlockEntity(blockPos, state, this.tier);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof FluidTankBlockEntity)) {
            return super.m_6782_(state, level, blockPos);
        }
        FluidTankBlockEntity fluidTankBlockEntity = (FluidTankBlockEntity)blockEntity;
        return fluidTankBlockEntity.getRedstoneOutput();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand handItem, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (!(blockEntity instanceof FluidTankBlockEntity) || ((FluidTankBlockEntity)blockEntity).getTier() != this.tier) {
            throw new IllegalStateException("Container is invalid");
        }
        ((ServerPlayer)player).openMenu((MenuProvider)((FluidTankBlockEntity)blockEntity), blockPos);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return FluidTankBlock.m_152132_(type, FluidTankBlockEntity.getEntityTypeFromTier(this.tier), FluidTankBlockEntity::tick);
    }

    public static enum Tier {
        SMALL("fluid_tank_small", 1000 * ModConfigs.COMMON_FLUID_TANK_SMALL_TANK_CAPACITY.getValue(), BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(4.0f, 5.0f).m_60918_(SoundType.f_56743_)),
        MEDIUM("fluid_tank_medium", 1000 * ModConfigs.COMMON_FLUID_TANK_MEDIUM_TANK_CAPACITY.getValue(), BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(4.0f, 5.0f).m_60918_(SoundType.f_56743_)),
        LARGE("fluid_tank_large", 1000 * ModConfigs.COMMON_FLUID_TANK_LARGE_TANK_CAPACITY.getValue(), BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(4.0f, 5.0f).m_60918_(SoundType.f_56743_));

        private final String resourceId;
        private final int tankCapacity;
        private final BlockBehaviour.Properties props;

        private Tier(String resourceId, int tankCapacity, BlockBehaviour.Properties props) {
            this.resourceId = resourceId;
            this.tankCapacity = tankCapacity;
            this.props = props;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public int getTankCapacity() {
            return this.tankCapacity;
        }

        public BlockBehaviour.Properties getProperties() {
            return this.props;
        }
    }

    public static class Item
    extends BlockItem {
        private final Tier tier;

        public Item(Block block, Item.Properties props, Tier tier) {
            super(block, props);
            this.tier = tier;
        }

        public Tier getTier() {
            return this.tier;
        }

        public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
            if (Screen.m_96638_()) {
                components.add((Component)Component.m_237110_((String)"tooltip.energizedpower.tank_capacity.txt", (Object[])new Object[]{FluidUtils.getFluidAmountWithPrefix(this.tier.getTankCapacity())}).m_130940_(ChatFormatting.GRAY));
            } else {
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.shift_details.txt").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }
}

