/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.jddev0.ep.block.entity.TransformerBlockEntity;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class TransformerBlock
extends BaseEntityBlock {
    public static final MapCodec<TransformerBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TransformerBlock.m_305607_(), (App)ExtraCodecs.f_263723_.xmap(Tier::valueOf, Enum::toString).fieldOf("tier").forGetter(TransformerBlock::getTier), (App)ExtraCodecs.f_263723_.xmap(Type::valueOf, Enum::toString).fieldOf("transformer_type").forGetter(TransformerBlock::getTransformerType)).apply((Applicative)instance, TransformerBlock::new));
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private final Tier tier;
    private final Type type;

    protected TransformerBlock(BlockBehaviour.Properties props, Tier tier, Type type) {
        super(props);
        this.tier = tier;
        this.type = type;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public Tier getTier() {
        return this.tier;
    }

    public Type getTransformerType() {
        return this.type;
    }

    protected MapCodec<? extends BaseEntityBlock> m_304657_() {
        return CODEC;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState state) {
        return new TransformerBlockEntity(blockPos, state, this.tier, this.type);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TransformerBlock.m_152132_(type, TransformerBlockEntity.getEntityTypeFromTierAndType(this.tier, this.type), TransformerBlockEntity::tick);
    }

    public static enum Tier {
        TIER_LV,
        TIER_MV,
        TIER_HV,
        TIER_EHV;

    }

    public static enum Type {
        TYPE_1_TO_N,
        TYPE_3_TO_3,
        TYPE_N_TO_1;

    }

    public static class Item
    extends BlockItem {
        private final Tier tier;
        private final Type type;

        public Item(Block block, Item.Properties props, Tier tier, Type type) {
            super(block, props);
            this.tier = tier;
            this.type = type;
        }

        public Tier getTier() {
            return this.tier;
        }

        public Type getTransformerType() {
            return this.type;
        }

        public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
            if (Screen.m_96638_()) {
                components.add((Component)Component.m_237110_((String)"tooltip.energizedpower.transfer_rate.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(TransformerBlockEntity.getMaxEnergyTransferFromTier(this.tier))}).m_130940_(ChatFormatting.GRAY));
                components.add((Component)Component.m_237119_());
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.transformer.txt.shift.1").m_130940_(ChatFormatting.GRAY));
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.transformer.txt.shift.2").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.transformer.txt.shift.3").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            } else {
                components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.shift_details.txt").m_130940_(ChatFormatting.YELLOW));
            }
        }
    }
}

