/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import me.jddev0.ep.block.AdvancedChargerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import me.jddev0.ep.recipe.ChargerRecipe;
import me.jddev0.ep.screen.AdvancedChargerMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedChargerBlockEntity
extends BlockEntity
implements MenuProvider,
EnergyStoragePacketUpdate,
RedstoneModeUpdate {
    public static final int MAX_RECEIVE_PER_SLOT = ModConfigs.COMMON_ADVANCED_CHARGER_TRANSFER_RATE_PER_SLOT.getValue();
    public static final float CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER = ModConfigs.COMMON_ADVANCED_CHARGER_CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER.getValue().floatValue();
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            AdvancedChargerBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot >= 0 && slot < 3) {
                if (AdvancedChargerBlockEntity.this.f_58857_ == null || RecipeUtils.isIngredientOfAny(AdvancedChargerBlockEntity.this.f_58857_, ChargerRecipe.Type.INSTANCE, stack)) {
                    return true;
                }
                LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
                if (!energyStorageLazyOptional.isPresent()) {
                    return false;
                }
                IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
                return energyStorage.canReceive();
            }
            return super.isItemValid(slot, stack);
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (slot >= 0 && slot < 3) {
                ItemStack itemStack = this.getStackInSlot(slot);
                if (!(AdvancedChargerBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_41656_((ItemStack)stack, (ItemStack)itemStack) && (ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack) || stack.getCapability(ForgeCapabilities.ENERGY).isPresent() && itemStack.getCapability(ForgeCapabilities.ENERGY).isPresent()))) {
                    AdvancedChargerBlockEntity.this.resetProgress(slot);
                }
            }
            super.setStackInSlot(slot, stack);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> {
        if (i < 0 || i > 2) {
            return false;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(i.intValue());
        if (this.f_58857_ != null && RecipeUtils.isResultOfAny(this.f_58857_, ChargerRecipe.Type.INSTANCE, stack)) {
            return true;
        }
        if (this.f_58857_ == null || RecipeUtils.isIngredientOfAny(this.f_58857_, ChargerRecipe.Type.INSTANCE, stack)) {
            return false;
        }
        LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
        if (!energyStorageLazyOptional.isPresent()) {
            return true;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
        if (!energyStorage.canReceive()) {
            return true;
        }
        return energyStorage.receiveEnergy(MAX_RECEIVE_PER_SLOT, true) == 0;
    }));
    private final ReceiveOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    protected final ContainerData data;
    private int[] energyConsumptionLeft = new int[]{-1, -1, -1};
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    public AdvancedChargerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ADVANCED_CHARGER_ENTITY.get(), blockPos, blockState);
        this.energyStorage = new ReceiveOnlyEnergyStorage(0, ModConfigs.COMMON_ADVANCED_CHARGER_CAPACITY_PER_SLOT.getValue() * 3, MAX_RECEIVE_PER_SLOT * 3){

            @Override
            protected void onChange() {
                AdvancedChargerBlockEntity.this.m_6596_();
                if (AdvancedChargerBlockEntity.this.f_58857_ != null && !AdvancedChargerBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, AdvancedChargerBlockEntity.this.m_58899_()), AdvancedChargerBlockEntity.this.m_58899_(), (ResourceKey<Level>)AdvancedChargerBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(AdvancedChargerBlockEntity.this.energyConsumptionLeft[0], index);
                    case 2, 3 -> ByteUtils.get2Bytes(AdvancedChargerBlockEntity.this.energyConsumptionLeft[1], index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(AdvancedChargerBlockEntity.this.energyConsumptionLeft[2], index - 4);
                    case 6 -> AdvancedChargerBlockEntity.this.redstoneMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 6: {
                        AdvancedChargerBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 7;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.advanced_charger");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new EnergySyncS2CPacket(this.energyStorage.getEnergy(), this.energyStorage.getCapacity(), this.m_58899_()), (ServerPlayer)player);
        return new AdvancedChargerMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        for (int i = 0; i < 3; ++i) {
            nbt.m_128365_("recipe.energy_consumption_left." + i, (Tag)IntTag.m_128679_((int)this.energyConsumptionLeft[i]));
        }
        nbt.m_128405_("configuration.redstone_mode", this.redstoneMode.ordinal());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
        for (int i = 0; i < 3; ++i) {
            this.energyConsumptionLeft[i] = nbt.m_128451_("recipe.energy_consumption_left." + i);
        }
        this.redstoneMode = RedstoneMode.fromIndex(nbt.m_128451_("configuration.redstone_mode"));
    }

    public void drops(Level level, BlockPos worldPosition) {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)level, (BlockPos)worldPosition, (Container)inventory);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AdvancedChargerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)AdvancedChargerBlock.POWERED))) {
            return;
        }
        int maxReceivePerSlot = (int)Math.min((double)MAX_RECEIVE_PER_SLOT, Math.ceil((double)blockEntity.energyStorage.getEnergy() / 3.0));
        for (int i = 0; i < 3; ++i) {
            if (blockEntity.hasRecipe(i)) {
                int energyConsumptionPerTick;
                ItemStack stack = blockEntity.itemHandler.getStackInSlot(i);
                SimpleContainer inventory = new SimpleContainer(1);
                inventory.m_6836_(0, blockEntity.itemHandler.getStackInSlot(i));
                Optional recipe = level.m_7465_().m_44015_((RecipeType)ChargerRecipe.Type.INSTANCE, (Container)inventory, level);
                if (recipe.isPresent()) {
                    if (blockEntity.energyConsumptionLeft[i] == -1) {
                        blockEntity.energyConsumptionLeft[i] = (int)((float)((ChargerRecipe)((RecipeHolder)recipe.get()).f_291008_()).getEnergyConsumption() * CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER);
                    }
                    if (blockEntity.energyStorage.getEnergy() == 0) {
                        AdvancedChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                        continue;
                    }
                    energyConsumptionPerTick = Math.min(blockEntity.energyConsumptionLeft[i], Math.min(maxReceivePerSlot, blockEntity.energyStorage.getEnergy()));
                } else {
                    IEnergyStorage energyStorage;
                    LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
                    if (!energyStorageLazyOptional.isPresent() || !(energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null)).canReceive()) continue;
                    blockEntity.energyConsumptionLeft[i] = energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored();
                    if (blockEntity.energyStorage.getEnergy() == 0) {
                        AdvancedChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                        continue;
                    }
                    energyConsumptionPerTick = energyStorage.receiveEnergy(Math.min(maxReceivePerSlot, blockEntity.energyStorage.getEnergy()), false);
                }
                if (blockEntity.energyConsumptionLeft[i] < 0 || energyConsumptionPerTick < 0) {
                    blockEntity.resetProgress(i);
                    AdvancedChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                    continue;
                }
                blockEntity.energyStorage.setEnergy(blockEntity.energyStorage.getEnergy() - energyConsumptionPerTick);
                int n = i;
                blockEntity.energyConsumptionLeft[n] = blockEntity.energyConsumptionLeft[n] - energyConsumptionPerTick;
                if (blockEntity.energyConsumptionLeft[i] <= 0) {
                    int index = i;
                    recipe.ifPresent(chargerRecipe -> blockEntity.itemHandler.setStackInSlot(index, ((ChargerRecipe)chargerRecipe.f_291008_()).m_8043_(level.m_9598_()).m_255036_(1)));
                    blockEntity.resetProgress(i);
                }
                AdvancedChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                continue;
            }
            blockEntity.resetProgress(i);
            AdvancedChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress(int index) {
        this.energyConsumptionLeft[index] = -1;
    }

    private boolean hasRecipe(int index) {
        ItemStack stack = this.itemHandler.getStackInSlot(index);
        if (stack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            return true;
        }
        SimpleContainer inventory = new SimpleContainer(1);
        inventory.m_6836_(0, this.itemHandler.getStackInSlot(index));
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ChargerRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        return recipe.isPresent();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.m_6596_();
    }
}

