/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.LinkedList;
import me.jddev0.ep.block.AdvancedUnchargerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ExtractOnlyEnergyStorage;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import me.jddev0.ep.screen.AdvancedUnchargerMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdvancedUnchargerBlockEntity
extends BlockEntity
implements MenuProvider,
EnergyStoragePacketUpdate,
RedstoneModeUpdate {
    public static final int MAX_EXTRACT_PER_SLOT = ModConfigs.COMMON_ADVANCED_UNCHARGER_TRANSFER_RATE_PER_SLOT.getValue();
    public static final int MAX_EXTRACT = MAX_EXTRACT_PER_SLOT * 3;
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            AdvancedUnchargerBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot >= 0 && slot < 3) {
                LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
                if (!energyStorageLazyOptional.isPresent()) {
                    return false;
                }
                IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
                return energyStorage.canExtract();
            }
            return super.isItemValid(slot, stack);
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (slot >= 0 && slot < 3) {
                ItemStack itemStack = this.getStackInSlot(slot);
                if (!(AdvancedUnchargerBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_41656_((ItemStack)stack, (ItemStack)itemStack) && (ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack) || stack.getCapability(ForgeCapabilities.ENERGY).isPresent() && itemStack.getCapability(ForgeCapabilities.ENERGY).isPresent()))) {
                    AdvancedUnchargerBlockEntity.this.resetProgress(slot);
                }
            }
            super.setStackInSlot(slot, stack);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> {
        if (i < 0 || i > 2) {
            return false;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(i.intValue());
        LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
        if (!energyStorageLazyOptional.isPresent()) {
            return true;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
        if (!energyStorage.canExtract()) {
            return true;
        }
        return energyStorage.extractEnergy(MAX_EXTRACT_PER_SLOT, true) == 0;
    }));
    private final ExtractOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    protected final ContainerData data;
    private int[] energyProductionLeft = new int[]{-1, -1, -1};
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    public AdvancedUnchargerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ADVANCED_UNCHARGER_ENTITY.get(), blockPos, blockState);
        this.energyStorage = new ExtractOnlyEnergyStorage(0, ModConfigs.COMMON_ADVANCED_UNCHARGER_CAPACITY_PER_SLOT.getValue() * 3, MAX_EXTRACT){

            @Override
            protected void onChange() {
                AdvancedUnchargerBlockEntity.this.m_6596_();
                if (AdvancedUnchargerBlockEntity.this.f_58857_ != null && !AdvancedUnchargerBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, AdvancedUnchargerBlockEntity.this.m_58899_()), AdvancedUnchargerBlockEntity.this.m_58899_(), (ResourceKey<Level>)AdvancedUnchargerBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(AdvancedUnchargerBlockEntity.this.energyProductionLeft[0], index);
                    case 2, 3 -> ByteUtils.get2Bytes(AdvancedUnchargerBlockEntity.this.energyProductionLeft[1], index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(AdvancedUnchargerBlockEntity.this.energyProductionLeft[2], index - 4);
                    case 6 -> AdvancedUnchargerBlockEntity.this.redstoneMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 6: {
                        AdvancedUnchargerBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 7;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.advanced_uncharger");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new EnergySyncS2CPacket(this.energyStorage.getEnergy(), this.energyStorage.getCapacity(), this.m_58899_()), (ServerPlayer)player);
        return new AdvancedUnchargerMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        for (int i = 0; i < 3; ++i) {
            nbt.m_128365_("recipe.energy_production_left." + i, (Tag)IntTag.m_128679_((int)this.energyProductionLeft[i]));
        }
        nbt.m_128405_("configuration.redstone_mode", this.redstoneMode.ordinal());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
        for (int i = 0; i < 3; ++i) {
            this.energyProductionLeft[i] = nbt.m_128451_("recipe.energy_production_left." + i);
        }
        this.redstoneMode = RedstoneMode.fromIndex(nbt.m_128451_("configuration.redstone_mode"));
    }

    public void drops(Level level, BlockPos worldPosition) {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)level, (BlockPos)worldPosition, (Container)inventory);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AdvancedUnchargerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)AdvancedUnchargerBlock.POWERED))) {
            AdvancedUnchargerBlockEntity.tickRecipe(level, blockPos, state, blockEntity);
        }
        AdvancedUnchargerBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void tickRecipe(Level level, BlockPos blockPos, BlockState state, AdvancedUnchargerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        int maxExtractPerSlot = (int)Math.min((double)MAX_EXTRACT_PER_SLOT, Math.ceil((double)(blockEntity.energyStorage.getMaxEnergyStored() - blockEntity.energyStorage.getEnergy()) / 3.0));
        for (int i = 0; i < 3; ++i) {
            if (blockEntity.hasRecipe(i)) {
                IEnergyStorage energyStorage;
                ItemStack stack = blockEntity.itemHandler.getStackInSlot(i);
                LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
                if (!energyStorageLazyOptional.isPresent() || !(energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null)).canExtract()) continue;
                blockEntity.energyProductionLeft[i] = energyStorage.getEnergyStored();
                int energyProductionPerTick = energyStorage.extractEnergy(Math.min(maxExtractPerSlot, blockEntity.energyStorage.getCapacity() - blockEntity.energyStorage.getEnergy()), false);
                if (blockEntity.energyProductionLeft[i] < 0 || energyProductionPerTick < 0) {
                    blockEntity.resetProgress(i);
                    AdvancedUnchargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                    continue;
                }
                blockEntity.energyStorage.setEnergy(blockEntity.energyStorage.getEnergy() + energyProductionPerTick);
                int n = i;
                blockEntity.energyProductionLeft[n] = blockEntity.energyProductionLeft[n] - energyProductionPerTick;
                if (blockEntity.energyProductionLeft[i] <= 0) {
                    blockEntity.resetProgress(i);
                }
                AdvancedUnchargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                continue;
            }
            blockEntity.resetProgress(i);
            AdvancedUnchargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private static void transferEnergy(Level level, BlockPos blockPos, BlockState state, AdvancedUnchargerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        LinkedList<IEnergyStorage> consumerItems = new LinkedList<IEnergyStorage>();
        LinkedList<Integer> consumerEnergyValues = new LinkedList<Integer>();
        int consumptionSum = 0;
        for (Direction direction : Direction.values()) {
            int received;
            IEnergyStorage energyStorage;
            LazyOptional energyStorageLazyOptional;
            BlockPos testPos = blockPos.m_121945_(direction);
            BlockEntity testBlockEntity = level.m_7702_(testPos);
            if (testBlockEntity == null || !(energyStorageLazyOptional = testBlockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_())).isPresent() || !(energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null)).canReceive() || (received = energyStorage.receiveEnergy(Math.min(MAX_EXTRACT, blockEntity.energyStorage.getEnergy()), true)) <= 0) continue;
            consumptionSum += received;
            consumerItems.add(energyStorage);
            consumerEnergyValues.add(received);
        }
        LinkedList<Integer> consumerEnergyDistributed = new LinkedList<Integer>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0);
        }
        int consumptionLeft = Math.min(MAX_EXTRACT, Math.min(blockEntity.energyStorage.getEnergy(), consumptionSum));
        blockEntity.energyStorage.extractEnergy(consumptionLeft, false);
        int divisor = consumerItems.size();
        block2: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block2;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
    }

    private void resetProgress(int index) {
        this.energyProductionLeft[index] = -1;
    }

    private boolean hasRecipe(int index) {
        ItemStack stack = this.itemHandler.getStackInSlot(index);
        return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.m_6596_();
    }
}

