/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.jddev0.ep.block.AutoCrafterBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import me.jddev0.ep.screen.AutoCrafterMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.ItemStackUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoCrafterBlockEntity
extends BlockEntity
implements MenuProvider,
EnergyStoragePacketUpdate,
RedstoneModeUpdate {
    private static final List<@NotNull ResourceLocation> RECIPE_BLACKLIST = ModConfigs.COMMON_AUTO_CRAFTER_RECIPE_BLACKLIST.getValue();
    private boolean secondaryExtractMode;
    private final ReceiveOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private final ItemStackHandler itemHandler = new ItemStackHandler(18){

        protected void onContentsChanged(int slot) {
            AutoCrafterBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot < 0 || slot >= 18) {
                return super.isItemValid(slot, stack);
            }
            return slot >= 3;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i >= 3, i -> this.secondaryExtractMode ? !this.isInput(this.itemHandler.getStackInSlot(i.intValue())) : this.isOutputOrCraftingRemainderOfInput(this.itemHandler.getStackInSlot(i.intValue()))));
    private final SimpleContainer patternSlots = new SimpleContainer(9){

        public int m_6893_() {
            return 1;
        }
    };
    private final SimpleContainer patternResultSlots = new SimpleContainer(1);
    private final ContainerListener updatePatternListener = container -> this.updateRecipe();
    private boolean hasRecipeLoaded = false;
    private ResourceLocation recipeIdForSetRecipe;
    private RecipeHolder<CraftingRecipe> craftingRecipe;
    private CraftingContainer oldCopyOfRecipe;
    private final AbstractContainerMenu dummyContainerMenu = new AbstractContainerMenu(null, -1){

        public ItemStack m_7648_(Player player, int index) {
            return null;
        }

        public boolean m_6875_(Player player) {
            return false;
        }

        public void m_6199_(Container container) {
        }
    };
    public static final int ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT = ModConfigs.COMMON_AUTO_CRAFTER_ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT.getValue();
    protected final ContainerData data;
    private int progress;
    private int maxProgress = ModConfigs.COMMON_AUTO_CRAFTER_RECIPE_DURATION.getValue();
    private int energyConsumptionLeft = -1;
    private boolean hasEnoughEnergy;
    private boolean ignoreNBT;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    public AutoCrafterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.AUTO_CRAFTER_ENTITY.get(), blockPos, blockState);
        this.patternSlots.m_19164_(this.updatePatternListener);
        this.energyStorage = new ReceiveOnlyEnergyStorage(0, ModConfigs.COMMON_AUTO_CRAFTER_CAPACITY.getValue(), ModConfigs.COMMON_AUTO_CRAFTER_TRANSFER_RATE.getValue()){

            @Override
            protected void onChange() {
                AutoCrafterBlockEntity.this.m_6596_();
                if (AutoCrafterBlockEntity.this.f_58857_ != null && !AutoCrafterBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, AutoCrafterBlockEntity.this.m_58899_()), AutoCrafterBlockEntity.this.m_58899_(), (ResourceKey<Level>)AutoCrafterBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(AutoCrafterBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(AutoCrafterBlockEntity.this.maxProgress, index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(AutoCrafterBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 6 -> {
                        if (AutoCrafterBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 7 -> {
                        if (AutoCrafterBlockEntity.this.ignoreNBT) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 8 -> {
                        if (AutoCrafterBlockEntity.this.secondaryExtractMode) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 9 -> AutoCrafterBlockEntity.this.redstoneMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        AutoCrafterBlockEntity.this.progress = ByteUtils.with2Bytes(AutoCrafterBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        AutoCrafterBlockEntity.this.maxProgress = ByteUtils.with2Bytes(AutoCrafterBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        AutoCrafterBlockEntity.this.ignoreNBT = value != 0;
                        break;
                    }
                    case 8: {
                        AutoCrafterBlockEntity.this.secondaryExtractMode = value != 0;
                        break;
                    }
                    case 9: {
                        AutoCrafterBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 10;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.auto_crafter");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new EnergySyncS2CPacket(this.energyStorage.getEnergy(), this.energyStorage.getCapacity(), this.m_58899_()), (ServerPlayer)player);
        return new AutoCrafterMenu(id, inventory, this, (Container)this.patternSlots, (Container)this.patternResultSlots, this.data);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128365_("pattern", this.savePatternContainer());
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        if (this.craftingRecipe != null) {
            nbt.m_128365_("recipe.id", (Tag)StringTag.m_129297_((String)this.craftingRecipe.f_291676_().toString()));
        }
        nbt.m_128365_("recipe.progress", (Tag)IntTag.m_128679_((int)this.progress));
        nbt.m_128365_("recipe.energy_consumption_left", (Tag)IntTag.m_128679_((int)this.energyConsumptionLeft));
        nbt.m_128379_("ignore_nbt", this.ignoreNBT);
        nbt.m_128379_("secondary_extract_mode", this.secondaryExtractMode);
        nbt.m_128405_("configuration.redstone_mode", this.redstoneMode.ordinal());
        super.m_183515_(nbt);
    }

    private Tag savePatternContainer() {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.patternSlots.m_6643_(); ++i) {
            if (this.patternSlots.m_8020_(i).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            this.patternSlots.m_8020_(i).m_41739_(itemTag);
            nbtTagList.add((Object)itemTag);
        }
        return nbtTagList;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.loadPatternContainer(nbt.m_128423_("pattern"));
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
        if (nbt.m_128441_("recipe.id")) {
            Tag tag = nbt.m_128423_("recipe.id");
            if (!(tag instanceof StringTag)) {
                throw new IllegalArgumentException("Tag must be of type StringTag!");
            }
            StringTag stringTag = (StringTag)tag;
            this.recipeIdForSetRecipe = ResourceLocation.m_135820_((String)stringTag.m_7916_());
        }
        this.progress = nbt.m_128451_("recipe.progress");
        this.energyConsumptionLeft = nbt.m_128451_("recipe.energy_consumption_left");
        this.ignoreNBT = nbt.m_128471_("ignore_nbt");
        this.secondaryExtractMode = nbt.m_128471_("secondary_extract_mode");
        this.redstoneMode = RedstoneMode.fromIndex(nbt.m_128451_("configuration.redstone_mode"));
    }

    private void loadPatternContainer(Tag tag) {
        if (!(tag instanceof ListTag)) {
            throw new IllegalArgumentException("Tag must be of type ListTag!");
        }
        this.patternSlots.m_19181_(this.updatePatternListener);
        ListTag tagList = (ListTag)tag;
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.patternSlots.m_6643_()) continue;
            this.patternSlots.m_6836_(slot, ItemStack.m_41712_((CompoundTag)itemTags));
        }
        this.patternSlots.m_19164_(this.updatePatternListener);
    }

    public void drops(Level level, BlockPos worldPosition) {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)level, (BlockPos)worldPosition, (Container)inventory);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, AutoCrafterBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.hasRecipeLoaded) {
            blockEntity.updateRecipe();
            if (blockEntity.craftingRecipe == null) {
                blockEntity.resetProgress();
            }
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)AutoCrafterBlock.POWERED))) {
            return;
        }
        int itemCount = 0;
        for (int i = 0; i < blockEntity.patternSlots.m_6643_(); ++i) {
            if (blockEntity.patternSlots.m_8020_(i).m_41619_()) continue;
            ++itemCount;
        }
        if (itemCount == 0) {
            return;
        }
        if (blockEntity.craftingRecipe != null && (blockEntity.progress > 0 || blockEntity.canInsertItemsIntoOutputSlots() && blockEntity.canExtractItemsFromInput())) {
            if (!blockEntity.canInsertItemsIntoOutputSlots() || !blockEntity.canExtractItemsFromInput()) {
                return;
            }
            int energyConsumptionPerTick = itemCount * ENERGY_CONSUMPTION_PER_TICK_PER_INGREDIENT;
            if (blockEntity.progress == 0) {
                if (!blockEntity.canExtractItemsFromInput()) {
                    return;
                }
                blockEntity.energyConsumptionLeft = energyConsumptionPerTick * blockEntity.maxProgress;
            }
            if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0 || energyConsumptionPerTick < 0) {
                blockEntity.resetProgress();
                AutoCrafterBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                return;
            }
            if (energyConsumptionPerTick <= blockEntity.energyStorage.getEnergy()) {
                blockEntity.energyStorage.setEnergy(blockEntity.energyStorage.getEnergy() - energyConsumptionPerTick);
                blockEntity.energyConsumptionLeft -= energyConsumptionPerTick;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    SimpleContainer patternSlotsForRecipe = blockEntity.ignoreNBT ? blockEntity.replaceCraftingPatternWithCurrentNBTItems(blockEntity.patternSlots) : blockEntity.patternSlots;
                    TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(blockEntity.dummyContainerMenu, 3, 3);
                    for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
                        copyOfPatternSlots.m_6836_(i, patternSlotsForRecipe.m_8020_(i));
                    }
                    blockEntity.extractItems();
                    blockEntity.craftItem((CraftingContainer)copyOfPatternSlots);
                }
                AutoCrafterBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                AutoCrafterBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        } else {
            blockEntity.resetProgress();
            AutoCrafterBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.energyConsumptionLeft = -1;
        this.hasEnoughEnergy = true;
    }

    public void resetProgressAndMarkAsChanged() {
        this.resetProgress();
        AutoCrafterBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    public void cycleRecipe() {
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
            copyOfPatternSlots.m_6836_(i, patternSlotsForRecipe.m_8020_(i));
        }
        List<RecipeHolder<CraftingRecipe>> recipes = this.getRecipesFor((CraftingContainer)copyOfPatternSlots, this.f_58857_);
        if (recipes.isEmpty()) {
            this.updateRecipe();
            return;
        }
        if (this.recipeIdForSetRecipe == null) {
            this.recipeIdForSetRecipe = this.craftingRecipe == null || this.craftingRecipe.f_291676_() == null ? recipes.get(0).f_291676_() : this.craftingRecipe.f_291676_();
        }
        for (int i = 0; i < recipes.size(); ++i) {
            if (!Objects.equals(recipes.get(i).f_291676_(), this.recipeIdForSetRecipe)) continue;
            this.recipeIdForSetRecipe = recipes.get((i + 1) % recipes.size()).f_291676_();
            break;
        }
        this.updateRecipe();
    }

    public void setRecipeIdForSetRecipe(ResourceLocation recipeIdForSetRecipe) {
        this.recipeIdForSetRecipe = recipeIdForSetRecipe;
        this.updateRecipe();
    }

    private void updateRecipe() {
        if (this.f_58857_ == null) {
            return;
        }
        RecipeHolder<CraftingRecipe> oldRecipe = null;
        ItemStack oldResult = null;
        if (this.hasRecipeLoaded && this.craftingRecipe != null && this.oldCopyOfRecipe != null) {
            oldRecipe = this.craftingRecipe;
            oldResult = this.craftingRecipe.f_291008_() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe.f_291008_()).m_5874_((Container)this.oldCopyOfRecipe, this.f_58857_.m_9598_()) : ((CraftingRecipe)this.craftingRecipe.f_291008_()).m_8043_(this.f_58857_.m_9598_());
        }
        this.hasRecipeLoaded = true;
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
            copyOfPatternSlots.m_6836_(i, patternSlotsForRecipe.m_8020_(i));
        }
        Optional<Pair<ResourceLocation, RecipeHolder<CraftingRecipe>>> recipe = this.getRecipeFor((CraftingContainer)copyOfPatternSlots, this.f_58857_, this.recipeIdForSetRecipe);
        if (recipe.isPresent()) {
            this.craftingRecipe = (RecipeHolder)recipe.get().getSecond();
            if (this.recipeIdForSetRecipe != null && !Objects.equals(this.craftingRecipe.f_291676_(), this.recipeIdForSetRecipe)) {
                this.recipeIdForSetRecipe = this.craftingRecipe.f_291676_();
                this.resetProgress();
            }
            ItemStack resultItemStack = this.craftingRecipe.f_291008_() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe.f_291008_()).m_5874_((Container)copyOfPatternSlots, this.f_58857_.m_9598_()) : ((CraftingRecipe)this.craftingRecipe.f_291008_()).m_8043_(this.f_58857_.m_9598_());
            this.patternResultSlots.m_6836_(0, resultItemStack);
            if (!(oldRecipe == null || oldResult == null || this.oldCopyOfRecipe == null || this.craftingRecipe == oldRecipe && ItemStack.m_150942_((ItemStack)resultItemStack, (ItemStack)oldResult))) {
                this.resetProgress();
            }
            this.oldCopyOfRecipe = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
            for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
                this.oldCopyOfRecipe.m_6836_(i, copyOfPatternSlots.m_8020_(i).m_41777_());
            }
        } else {
            this.recipeIdForSetRecipe = null;
            this.craftingRecipe = null;
            this.patternResultSlots.m_6836_(0, ItemStack.f_41583_);
            this.oldCopyOfRecipe = null;
            this.resetProgress();
        }
    }

    private void extractItems() {
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        ArrayList<ItemStack> patternItemStacks = new ArrayList<ItemStack>(9);
        for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
            if (patternSlotsForRecipe.m_8020_(i).m_41619_()) continue;
            patternItemStacks.add(patternSlotsForRecipe.m_8020_(i));
        }
        List<ItemStack> itemStacksExtract = ItemStackUtils.combineItemStacks(patternItemStacks);
        block1: for (ItemStack itemStack : itemStacksExtract) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack ret;
                ItemStack testItemStack = this.itemHandler.getStackInSlot(i);
                if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)testItemStack) || (ret = this.itemHandler.extractItem(i, itemStack.m_41613_(), false)).m_41619_()) continue;
                int amount = ret.m_41613_();
                if (amount == itemStack.m_41613_()) continue block1;
                itemStack.m_41774_(amount);
            }
        }
    }

    private void craftItem(CraftingContainer copyOfPatternSlots) {
        if (this.craftingRecipe == null) {
            this.resetProgress();
            return;
        }
        ArrayList<ItemStack> outputItemStacks = new ArrayList<ItemStack>(10);
        ItemStack resultItemStack = this.craftingRecipe.f_291008_() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe.f_291008_()).m_5874_((Container)copyOfPatternSlots, this.f_58857_.m_9598_()) : ((CraftingRecipe)this.craftingRecipe.f_291008_()).m_8043_(this.f_58857_.m_9598_());
        outputItemStacks.add(resultItemStack);
        for (ItemStack remainingItem : ((CraftingRecipe)this.craftingRecipe.f_291008_()).m_7457_((Container)copyOfPatternSlots)) {
            if (remainingItem.m_41619_()) continue;
            outputItemStacks.add(remainingItem);
        }
        List<ItemStack> itemStacksInsert = ItemStackUtils.combineItemStacks(outputItemStacks);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(18);
        block1: for (ItemStack itemStack : itemStacksInsert) {
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                int amount;
                ItemStack testItemStack = this.itemHandler.getStackInSlot(i);
                if (emptyIndices.contains(i)) continue;
                if (testItemStack.m_41619_()) {
                    emptyIndices.add(i);
                    continue;
                }
                if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)testItemStack) || (amount = Math.min(itemStack.m_41613_(), testItemStack.m_41741_() - testItemStack.m_41613_())) <= 0) continue;
                this.itemHandler.setStackInSlot(i, this.itemHandler.getStackInSlot(i).m_255036_(testItemStack.m_41613_() + amount));
                itemStack.m_41764_(itemStack.m_41613_() - amount);
                if (itemStack.m_41619_()) continue block1;
            }
            if (emptyIndices.isEmpty()) continue;
            this.itemHandler.setStackInSlot(((Integer)emptyIndices.remove(0)).intValue(), itemStack);
        }
        if (this.ignoreNBT) {
            this.updateRecipe();
        }
        this.resetProgress();
    }

    private boolean canExtractItemsFromInput() {
        if (this.craftingRecipe == null) {
            return false;
        }
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        ArrayList<ItemStack> patternItemStacks = new ArrayList<ItemStack>(9);
        for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
            if (patternSlotsForRecipe.m_8020_(i).m_41619_()) continue;
            patternItemStacks.add(patternSlotsForRecipe.m_8020_(i));
        }
        List<ItemStack> itemStacks = ItemStackUtils.combineItemStacks(patternItemStacks);
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(18);
        for (int i = itemStacks.size() - 1; i >= 0; --i) {
            block6: {
                ItemStack itemStack = itemStacks.get(i);
                for (int j = 0; j < this.itemHandler.getSlots(); ++j) {
                    if (checkedIndices.contains(j)) continue;
                    ItemStack testItemStack = this.itemHandler.getStackInSlot(j);
                    if (testItemStack.m_41619_()) {
                        checkedIndices.add(j);
                        continue;
                    }
                    if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                    int amount = Math.min(itemStack.m_41613_(), testItemStack.m_41613_());
                    checkedIndices.add(j);
                    if (amount != itemStack.m_41613_()) {
                        itemStack.m_41774_(amount);
                        continue;
                    }
                    break block6;
                }
                return false;
            }
            itemStacks.remove(i);
        }
        return itemStacks.isEmpty();
    }

    private boolean canInsertItemsIntoOutputSlots() {
        ItemStack resultItemStack;
        if (this.craftingRecipe == null) {
            return false;
        }
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
            copyOfPatternSlots.m_6836_(i, patternSlotsForRecipe.m_8020_(i));
        }
        ArrayList<ItemStack> outputItemStacks = new ArrayList<ItemStack>(10);
        ItemStack itemStack = resultItemStack = this.craftingRecipe.f_291008_() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe.f_291008_()).m_5874_((Container)copyOfPatternSlots, this.f_58857_.m_9598_()) : ((CraftingRecipe)this.craftingRecipe.f_291008_()).m_8043_(this.f_58857_.m_9598_());
        if (!resultItemStack.m_41619_()) {
            outputItemStacks.add(resultItemStack);
        }
        for (ItemStack remainingItem : ((CraftingRecipe)this.craftingRecipe.f_291008_()).m_7457_((Container)copyOfPatternSlots)) {
            if (remainingItem.m_41619_()) continue;
            outputItemStacks.add(remainingItem);
        }
        List<ItemStack> itemStacks = ItemStackUtils.combineItemStacks(outputItemStacks);
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(18);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(18);
        block2: for (int i = itemStacks.size() - 1; i >= 0; --i) {
            ItemStack itemStack2 = itemStacks.get(i);
            for (int j = 0; j < this.itemHandler.getSlots(); ++j) {
                if (checkedIndices.contains(j) || emptyIndices.contains(j)) continue;
                ItemStack testItemStack = this.itemHandler.getStackInSlot(j);
                if (testItemStack.m_41619_()) {
                    emptyIndices.add(j);
                    continue;
                }
                if (!ItemStack.m_150942_((ItemStack)itemStack2, (ItemStack)testItemStack)) continue;
                int amount = Math.min(itemStack2.m_41613_(), testItemStack.m_41741_() - testItemStack.m_41613_());
                if (amount + testItemStack.m_41613_() == testItemStack.m_41741_()) {
                    checkedIndices.add(j);
                }
                if (amount == itemStack2.m_41613_()) {
                    itemStacks.remove(i);
                    continue block2;
                }
                itemStack2.m_41774_(amount);
            }
            if (emptyIndices.isEmpty()) {
                return false;
            }
            int index = (Integer)emptyIndices.remove(0);
            if (itemStack2.m_41613_() == itemStack2.m_41741_()) {
                checkedIndices.add(index);
            }
            itemStacks.remove(i);
        }
        return itemStacks.isEmpty();
    }

    private boolean isOutputOrCraftingRemainderOfInput(ItemStack itemStack) {
        ItemStack resultItemStack;
        if (this.craftingRecipe == null) {
            return false;
        }
        SimpleContainer patternSlotsForRecipe = this.ignoreNBT ? this.replaceCraftingPatternWithCurrentNBTItems(this.patternSlots) : this.patternSlots;
        TransientCraftingContainer copyOfPatternSlots = new TransientCraftingContainer(this.dummyContainerMenu, 3, 3);
        for (int i = 0; i < patternSlotsForRecipe.m_6643_(); ++i) {
            copyOfPatternSlots.m_6836_(i, patternSlotsForRecipe.m_8020_(i));
        }
        ItemStack itemStack2 = resultItemStack = this.craftingRecipe.f_291008_() instanceof CustomRecipe ? ((CraftingRecipe)this.craftingRecipe.f_291008_()).m_5874_((Container)copyOfPatternSlots, this.f_58857_.m_9598_()) : ((CraftingRecipe)this.craftingRecipe.f_291008_()).m_8043_(this.f_58857_.m_9598_());
        if (ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)resultItemStack)) {
            return true;
        }
        for (ItemStack remainingItem : ((CraftingRecipe)this.craftingRecipe.f_291008_()).m_7457_((Container)copyOfPatternSlots)) {
            if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)remainingItem)) continue;
            return true;
        }
        return false;
    }

    private boolean isInput(ItemStack itemStack) {
        if (this.craftingRecipe == null) {
            return false;
        }
        for (int i = 0; i < this.patternSlots.m_6643_(); ++i) {
            if (!(this.ignoreNBT ? ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)this.patternSlots.m_8020_(i)) : ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)this.patternSlots.m_8020_(i)))) continue;
            return true;
        }
        return false;
    }

    private SimpleContainer replaceCraftingPatternWithCurrentNBTItems(SimpleContainer container) {
        SimpleContainer copyOfContainer = new SimpleContainer(container.m_6643_());
        for (int i = 0; i < container.m_6643_(); ++i) {
            copyOfContainer.m_6836_(i, container.m_8020_(i).m_41777_());
        }
        HashMap<Integer, Integer> usedItemCounts = new HashMap<Integer, Integer>();
        block1: for (int i = 0; i < copyOfContainer.m_6643_(); ++i) {
            int usedCount;
            ItemStack testItemStack;
            int j;
            ItemStack itemStack = copyOfContainer.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            for (j = 0; j < this.itemHandler.getSlots(); ++j) {
                testItemStack = this.itemHandler.getStackInSlot(j).m_41777_();
                usedCount = usedItemCounts.getOrDefault(j, 0);
                testItemStack.m_41764_(testItemStack.m_41613_() - usedCount);
                if (testItemStack.m_41613_() <= 0 || !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                usedItemCounts.put(j, usedCount + 1);
                continue block1;
            }
            for (j = 0; j < this.itemHandler.getSlots(); ++j) {
                testItemStack = this.itemHandler.getStackInSlot(j).m_41777_();
                usedCount = usedItemCounts.getOrDefault(j, 0);
                testItemStack.m_41764_(testItemStack.m_41613_() - usedCount);
                if (testItemStack.m_41613_() <= 0 || !ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                usedItemCounts.put(j, usedCount + 1);
                copyOfContainer.m_6836_(i, testItemStack.m_255036_(1));
                continue block1;
            }
            return copyOfContainer;
        }
        return copyOfContainer;
    }

    private List<RecipeHolder<CraftingRecipe>> getRecipesFor(CraftingContainer patternSlots, Level level) {
        return level.m_7465_().m_44013_(RecipeType.f_44107_).stream().filter(recipe -> !RECIPE_BLACKLIST.contains(recipe.f_291676_())).filter(recipe -> ((CraftingRecipe)recipe.f_291008_()).m_5818_((Container)patternSlots, level)).sorted(Comparator.comparing(recipe -> ((CraftingRecipe)recipe.f_291008_()).m_8043_(level.m_9598_()).m_41778_())).toList();
    }

    private Optional<Pair<ResourceLocation, RecipeHolder<CraftingRecipe>>> getRecipeFor(CraftingContainer patternSlots, Level level, ResourceLocation recipeId) {
        List<RecipeHolder<CraftingRecipe>> recipes = this.getRecipesFor(patternSlots, level);
        Optional<RecipeHolder> recipe = recipes.stream().filter(r -> r.f_291676_().equals((Object)recipeId)).findFirst();
        return recipe.or(() -> recipes.stream().findFirst()).map(r -> Pair.of((Object)r.f_291676_(), (Object)r));
    }

    public void setIgnoreNBT(boolean ignoreNBT) {
        this.ignoreNBT = ignoreNBT;
        this.updateRecipe();
        AutoCrafterBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    public void setSecondaryExtractMode(boolean secondaryExtractMode) {
        this.secondaryExtractMode = secondaryExtractMode;
        AutoCrafterBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.m_6596_();
    }
}

