/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import me.jddev0.ep.block.BlockPlacerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import me.jddev0.ep.screen.BlockPlacerMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockPlacerBlockEntity
extends BlockEntity
implements MenuProvider,
EnergyStoragePacketUpdate,
RedstoneModeUpdate {
    private static final List<@NotNull ResourceLocation> PLACEMENT_BLACKLIST = ModConfigs.COMMON_BLOCK_PLACER_PLACEMENT_BLACKLIST.getValue();
    private static final int ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_BLOCK_PLACER_ENERGY_CONSUMPTION_PER_TICK.getValue();
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            BlockPlacerBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return stack.m_41720_() instanceof BlockItem;
            }
            return super.isItemValid(slot, stack);
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                ItemStack itemStack = this.getStackInSlot(slot);
                if (!(BlockPlacerBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                    BlockPlacerBlockEntity.this.resetProgress(BlockPlacerBlockEntity.this.f_58858_, BlockPlacerBlockEntity.this.f_58857_.m_8055_(BlockPlacerBlockEntity.this.f_58858_));
                }
            }
            super.setStackInSlot(slot, stack);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> false));
    private final ReceiveOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    protected final ContainerData data;
    private int progress;
    private int maxProgress = ModConfigs.COMMON_BLOCK_PLACER_PLACEMENT_DURATION.getValue();
    private int energyConsumptionLeft = -1;
    private boolean hasEnoughEnergy;
    private boolean inverseRotation;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    public BlockPlacerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.BLOCK_PLACER_ENTITY.get(), blockPos, blockState);
        this.energyStorage = new ReceiveOnlyEnergyStorage(0, ModConfigs.COMMON_BLOCK_PLACER_CAPACITY.getValue(), ModConfigs.COMMON_BLOCK_PLACER_TRANSFER_RATE.getValue()){

            @Override
            protected void onChange() {
                BlockPlacerBlockEntity.this.m_6596_();
                if (BlockPlacerBlockEntity.this.f_58857_ != null && !BlockPlacerBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, BlockPlacerBlockEntity.this.m_58899_()), BlockPlacerBlockEntity.this.m_58899_(), (ResourceKey<Level>)BlockPlacerBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(BlockPlacerBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(BlockPlacerBlockEntity.this.maxProgress, index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(BlockPlacerBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 6 -> {
                        if (BlockPlacerBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 7 -> {
                        if (BlockPlacerBlockEntity.this.inverseRotation) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 8 -> BlockPlacerBlockEntity.this.redstoneMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        BlockPlacerBlockEntity.this.progress = ByteUtils.with2Bytes(BlockPlacerBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        BlockPlacerBlockEntity.this.maxProgress = ByteUtils.with2Bytes(BlockPlacerBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        BlockPlacerBlockEntity.this.inverseRotation = value != 0;
                        break;
                    }
                    case 8: {
                        BlockPlacerBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 9;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.block_placer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new EnergySyncS2CPacket(this.energyStorage.getEnergy(), this.energyStorage.getCapacity(), this.m_58899_()), (ServerPlayer)player);
        return new BlockPlacerMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        nbt.m_128365_("recipe.progress", (Tag)IntTag.m_128679_((int)this.progress));
        nbt.m_128365_("recipe.energy_consumption_left", (Tag)IntTag.m_128679_((int)this.energyConsumptionLeft));
        nbt.m_128379_("inverse_rotation", this.inverseRotation);
        nbt.m_128405_("configuration.redstone_mode", this.redstoneMode.ordinal());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
        this.progress = nbt.m_128451_("recipe.progress");
        this.energyConsumptionLeft = nbt.m_128451_("recipe.energy_consumption_left");
        this.inverseRotation = nbt.m_128471_("inverse_rotation");
        this.redstoneMode = RedstoneMode.fromIndex(nbt.m_128451_("configuration.redstone_mode"));
    }

    public void drops(Level level, BlockPos worldPosition) {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)level, (BlockPos)worldPosition, (Container)inventory);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, BlockPlacerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)BlockPlacerBlock.POWERED))) {
            return;
        }
        if (BlockPlacerBlockEntity.hasRecipe(blockEntity)) {
            if (blockEntity.energyConsumptionLeft < 0) {
                blockEntity.energyConsumptionLeft = ENERGY_USAGE_PER_TICK * blockEntity.maxProgress;
            }
            if (ENERGY_USAGE_PER_TICK <= blockEntity.energyStorage.getEnergy()) {
                blockEntity.hasEnoughEnergy = true;
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0) {
                    blockEntity.resetProgress(blockPos, state);
                    BlockPlacerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
                blockEntity.energyStorage.setEnergy(blockEntity.energyStorage.getEnergy() - ENERGY_USAGE_PER_TICK);
                blockEntity.energyConsumptionLeft -= ENERGY_USAGE_PER_TICK;
                if (blockEntity.progress < blockEntity.maxProgress) {
                    ++blockEntity.progress;
                }
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    Direction direction;
                    ItemStack itemStack = blockEntity.itemHandler.getStackInSlot(0);
                    if (itemStack.m_41619_()) {
                        blockEntity.energyConsumptionLeft = ENERGY_USAGE_PER_TICK;
                        BlockPlacerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                        return;
                    }
                    BlockPos blockPosPlacement = blockEntity.m_58899_().m_121945_((Direction)blockEntity.m_58900_().m_61143_((Property)BlockPlacerBlock.FACING));
                    BlockItem blockItem = (BlockItem)itemStack.m_41720_();
                    if (blockEntity.inverseRotation) {
                        direction = switch ((Direction)state.m_61143_((Property)BlockPlacerBlock.FACING)) {
                            default -> throw new IncompatibleClassChangeError();
                            case Direction.DOWN -> Direction.UP;
                            case Direction.UP -> Direction.DOWN;
                            case Direction.NORTH -> Direction.SOUTH;
                            case Direction.SOUTH -> Direction.NORTH;
                            case Direction.WEST -> Direction.EAST;
                            case Direction.EAST -> Direction.WEST;
                        };
                    } else {
                        direction = (Direction)state.m_61143_((Property)BlockPlacerBlock.FACING);
                    }
                    InteractionResult result = blockItem.m_40576_((BlockPlaceContext)new DirectionalPlaceContext(level, blockPosPlacement, direction, itemStack, direction){

                        @NotNull
                        public Direction m_7820_() {
                            return direction;
                        }

                        @NotNull
                        public @NotNull Direction @NotNull [] m_6232_() {
                            Direction[] directionArray;
                            switch (direction) {
                                default: {
                                    throw new IncompatibleClassChangeError();
                                }
                                case DOWN: {
                                    Direction[] directionArray2 = new Direction[6];
                                    directionArray2[0] = Direction.DOWN;
                                    directionArray2[1] = Direction.NORTH;
                                    directionArray2[2] = Direction.EAST;
                                    directionArray2[3] = Direction.SOUTH;
                                    directionArray2[4] = Direction.WEST;
                                    directionArray = directionArray2;
                                    directionArray2[5] = Direction.UP;
                                    break;
                                }
                                case UP: {
                                    Direction[] directionArray3 = new Direction[6];
                                    directionArray3[0] = Direction.UP;
                                    directionArray3[1] = Direction.DOWN;
                                    directionArray3[2] = Direction.NORTH;
                                    directionArray3[3] = Direction.EAST;
                                    directionArray3[4] = Direction.SOUTH;
                                    directionArray = directionArray3;
                                    directionArray3[5] = Direction.WEST;
                                    break;
                                }
                                case NORTH: {
                                    Direction[] directionArray4 = new Direction[6];
                                    directionArray4[0] = Direction.NORTH;
                                    directionArray4[1] = Direction.EAST;
                                    directionArray4[2] = Direction.WEST;
                                    directionArray4[3] = Direction.UP;
                                    directionArray4[4] = Direction.DOWN;
                                    directionArray = directionArray4;
                                    directionArray4[5] = Direction.SOUTH;
                                    break;
                                }
                                case SOUTH: {
                                    Direction[] directionArray5 = new Direction[6];
                                    directionArray5[0] = Direction.SOUTH;
                                    directionArray5[1] = Direction.EAST;
                                    directionArray5[2] = Direction.WEST;
                                    directionArray5[3] = Direction.UP;
                                    directionArray5[4] = Direction.DOWN;
                                    directionArray = directionArray5;
                                    directionArray5[5] = Direction.NORTH;
                                    break;
                                }
                                case WEST: {
                                    Direction[] directionArray6 = new Direction[6];
                                    directionArray6[0] = Direction.WEST;
                                    directionArray6[1] = Direction.SOUTH;
                                    directionArray6[2] = Direction.UP;
                                    directionArray6[3] = Direction.DOWN;
                                    directionArray6[4] = Direction.NORTH;
                                    directionArray = directionArray6;
                                    directionArray6[5] = Direction.EAST;
                                    break;
                                }
                                case EAST: {
                                    Direction[] directionArray7 = new Direction[6];
                                    directionArray7[0] = Direction.EAST;
                                    directionArray7[1] = Direction.SOUTH;
                                    directionArray7[2] = Direction.UP;
                                    directionArray7[3] = Direction.DOWN;
                                    directionArray7[4] = Direction.NORTH;
                                    directionArray = directionArray7;
                                    directionArray7[5] = Direction.WEST;
                                }
                            }
                            return directionArray;
                        }

                        public boolean m_7058_() {
                            return false;
                        }
                    });
                    if (result == InteractionResult.FAIL) {
                        blockEntity.energyConsumptionLeft = ENERGY_USAGE_PER_TICK;
                        BlockPlacerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                        return;
                    }
                    blockEntity.itemHandler.setStackInSlot(0, itemStack);
                    blockEntity.resetProgress(blockPos, state);
                }
                BlockPlacerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                BlockPlacerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            BlockPlacerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress(BlockPos blockPos, BlockState state) {
        this.progress = 0;
        this.energyConsumptionLeft = -1;
        this.hasEnoughEnergy = true;
    }

    private static boolean hasRecipe(BlockPlacerBlockEntity blockEntity) {
        ItemStack itemStack = blockEntity.itemHandler.getStackInSlot(0);
        if (itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItemStack = (BlockItem)item;
        return !PLACEMENT_BLACKLIST.contains(ForgeRegistries.BLOCKS.getKey((Object)blockItemStack.m_40614_()));
    }

    public void setInverseRotation(boolean inverseRotation) {
        this.inverseRotation = inverseRotation;
        BlockPlacerBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.m_6596_();
    }
}

