/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.jddev0.ep.block.CableBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CableBlockEntity
extends BlockEntity {
    private static final CableBlock.EnergyExtractionMode ENERGY_EXTRACTION_MODE = ModConfigs.COMMON_CABLES_ENERGY_EXTRACTION_MODE.getValue();
    private final CableBlock.Tier tier;
    private final ReceiveOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private boolean loaded;
    private final Map<Pair<BlockPos, Direction>, IEnergyStorage> producers = new HashMap<Pair<BlockPos, Direction>, IEnergyStorage>();
    private final Map<Pair<BlockPos, Direction>, IEnergyStorage> consumers = new HashMap<Pair<BlockPos, Direction>, IEnergyStorage>();
    private final List<BlockPos> cableBlocks = new LinkedList<BlockPos>();

    public static BlockEntityType<CableBlockEntity> getEntityTypeFromTier(CableBlock.Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case CableBlock.Tier.TIER_COPPER -> (BlockEntityType)ModBlockEntities.COPPER_CABLE_ENTITY.get();
            case CableBlock.Tier.TIER_GOLD -> (BlockEntityType)ModBlockEntities.GOLD_CABLE_ENTITY.get();
            case CableBlock.Tier.TIER_ENERGIZED_COPPER -> (BlockEntityType)ModBlockEntities.ENERGIZED_COPPER_CABLE_ENTITY.get();
            case CableBlock.Tier.TIER_ENERGIZED_GOLD -> (BlockEntityType)ModBlockEntities.ENERGIZED_GOLD_CABLE_ENTITY.get();
            case CableBlock.Tier.TIER_ENERGIZED_CRYSTAL_MATRIX -> (BlockEntityType)ModBlockEntities.ENERGIZED_CRYSTAL_MATRIX_CABLE_ENTITY.get();
        };
    }

    public CableBlockEntity(BlockPos blockPos, BlockState blockState, CableBlock.Tier tier) {
        super(CableBlockEntity.getEntityTypeFromTier(tier), blockPos, blockState);
        this.tier = tier;
        this.energyStorage = ENERGY_EXTRACTION_MODE.isPush() ? new ReceiveOnlyEnergyStorage(0, tier.getMaxTransfer(), tier.getMaxTransfer()){

            @Override
            protected void onChange() {
                CableBlockEntity.this.m_6596_();
            }
        } : new ReceiveOnlyEnergyStorage(){

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                return 0;
            }

            @Override
            public boolean canReceive() {
                return false;
            }
        };
    }

    public CableBlock.Tier getTier() {
        return this.tier;
    }

    public Map<Pair<BlockPos, Direction>, IEnergyStorage> getProducers() {
        return this.producers;
    }

    public Map<Pair<BlockPos, Direction>, IEnergyStorage> getConsumers() {
        return this.consumers;
    }

    public List<BlockPos> getCableBlocks() {
        return this.cableBlocks;
    }

    public static void updateConnections(Level level, BlockPos blockPos, BlockState state, CableBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        blockEntity.producers.clear();
        blockEntity.consumers.clear();
        blockEntity.cableBlocks.clear();
        for (Direction direction : Direction.values()) {
            BlockPos testPos = blockPos.m_121945_(direction);
            BlockEntity testBlockEntity = level.m_7702_(testPos);
            if (testBlockEntity == null) continue;
            if (testBlockEntity instanceof CableBlockEntity) {
                CableBlockEntity cableBlockEntity = (CableBlockEntity)testBlockEntity;
                if (cableBlockEntity.getTier() != blockEntity.getTier()) continue;
                blockEntity.cableBlocks.add(testPos);
                continue;
            }
            LazyOptional energyStorageLazyOptional = testBlockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_());
            if (!energyStorageLazyOptional.isPresent()) continue;
            IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
            if (ENERGY_EXTRACTION_MODE.isPull() && energyStorage.canExtract()) {
                blockEntity.producers.put((Pair<BlockPos, Direction>)Pair.of((Object)testPos, (Object)direction.m_122424_()), energyStorage);
            }
            if (!energyStorage.canReceive()) continue;
            blockEntity.consumers.put((Pair<BlockPos, Direction>)Pair.of((Object)testPos, (Object)direction.m_122424_()), energyStorage);
        }
    }

    public static List<IEnergyStorage> getConnectedConsumers(Level level, BlockPos blockPos, List<BlockPos> checkedCables) {
        LinkedList<IEnergyStorage> consumers = new LinkedList<IEnergyStorage>();
        LinkedList<BlockPos> cableBlocksLeft = new LinkedList<BlockPos>();
        cableBlocksLeft.add(blockPos);
        checkedCables.add(blockPos);
        while (cableBlocksLeft.size() > 0) {
            BlockPos checkPos = (BlockPos)cableBlocksLeft.pop();
            BlockEntity blockEntity = level.m_7702_(checkPos);
            if (!(blockEntity instanceof CableBlockEntity)) continue;
            CableBlockEntity cableBlockEntity = (CableBlockEntity)blockEntity;
            cableBlockEntity.getCableBlocks().forEach(pos -> {
                if (!checkedCables.contains(pos)) {
                    checkedCables.add((BlockPos)pos);
                    cableBlocksLeft.add((BlockPos)pos);
                }
            });
            consumers.addAll(cableBlockEntity.getConsumers().values());
        }
        return consumers;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, CableBlockEntity blockEntity) {
        int i;
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.loaded) {
            CableBlockEntity.updateConnections(level, blockPos, state, blockEntity);
            blockEntity.loaded = true;
        }
        int MAX_TRANSFER = blockEntity.tier.getMaxTransfer();
        LinkedList<IEnergyStorage> energyProduction = new LinkedList<IEnergyStorage>();
        LinkedList<Integer> energyProductionValues = new LinkedList<Integer>();
        int productionSum = blockEntity.energyStorage.getEnergy();
        for (IEnergyStorage energyStorage : blockEntity.producers.values()) {
            int extracted = energyStorage.extractEnergy(MAX_TRANSFER, true);
            if (extracted <= 0) continue;
            energyProduction.add(energyStorage);
            energyProductionValues.add(extracted);
            productionSum += extracted;
        }
        if (productionSum <= 0) {
            return;
        }
        LinkedList<IEnergyStorage> energyConsumption = new LinkedList<IEnergyStorage>();
        LinkedList<Integer> energyConsumptionValues = new LinkedList<Integer>();
        List<IEnergyStorage> consumers = CableBlockEntity.getConnectedConsumers(level, blockPos, new LinkedList<BlockPos>());
        int consumptionSum = 0;
        for (IEnergyStorage energyStorage : consumers) {
            int received = energyStorage.receiveEnergy(MAX_TRANSFER, true);
            if (received <= 0) continue;
            energyConsumption.add(energyStorage);
            energyConsumptionValues.add(received);
            consumptionSum += received;
        }
        if (consumptionSum <= 0) {
            return;
        }
        int transferLeft = Math.min(Math.min(MAX_TRANSFER, productionSum), consumptionSum);
        int extractInternally = 0;
        if (ENERGY_EXTRACTION_MODE.isPush()) {
            extractInternally = Math.min(blockEntity.energyStorage.getEnergy(), transferLeft);
            blockEntity.energyStorage.setEnergy(blockEntity.energyStorage.getEnergy() - extractInternally);
        }
        LinkedList<Integer> energyProductionDistributed = new LinkedList<Integer>();
        for (int i2 = 0; i2 < energyProduction.size(); ++i2) {
            energyProductionDistributed.add(0);
        }
        int productionLeft = ENERGY_EXTRACTION_MODE.isPull() ? transferLeft - extractInternally : 0;
        int divisor = energyProduction.size();
        block3: while (productionLeft > 0) {
            int productionPerProducer = productionLeft / divisor;
            if (productionPerProducer == 0) {
                divisor = Math.max(1, divisor - 1);
                productionPerProducer = productionLeft / divisor;
            }
            for (i = 0; i < energyProductionValues.size(); ++i) {
                int productionDistributed = (Integer)energyProductionDistributed.get(i);
                int productionOfProducerLeft = (Integer)energyProductionValues.get(i) - productionDistributed;
                int productionDistributedNew = Math.min(productionPerProducer, Math.min(productionOfProducerLeft, productionLeft));
                energyProductionDistributed.set(i, productionDistributed + productionDistributedNew);
                if ((productionLeft -= productionDistributedNew) == 0) break block3;
            }
        }
        for (int i3 = 0; i3 < energyProduction.size(); ++i3) {
            int energy = (Integer)energyProductionDistributed.get(i3);
            if (energy <= 0) continue;
            ((IEnergyStorage)energyProduction.get(i3)).extractEnergy(energy, false);
        }
        LinkedList<Integer> energyConsumptionDistributed = new LinkedList<Integer>();
        for (i = 0; i < energyConsumption.size(); ++i) {
            energyConsumptionDistributed.add(0);
        }
        int consumptionLeft = transferLeft;
        divisor = energyConsumption.size();
        block7: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i4 = 0; i4 < energyConsumptionValues.size(); ++i4) {
                int consumptionDistributed = (Integer)energyConsumptionDistributed.get(i4);
                int consumptionOfConsumerLeft = (Integer)energyConsumptionValues.get(i4) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                energyConsumptionDistributed.set(i4, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block7;
            }
        }
        for (int i5 = 0; i5 < energyConsumption.size(); ++i5) {
            int energy = (Integer)energyConsumptionDistributed.get(i5);
            if (energy <= 0) continue;
            ((IEnergyStorage)energyConsumption.get(i5)).receiveEnergy(energy, false);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        if (ENERGY_EXTRACTION_MODE.isPush()) {
            nbt.m_128365_("energy", this.energyStorage.saveNBT());
        }
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        if (ENERGY_EXTRACTION_MODE.isPush()) {
            this.energyStorage.loadNBT(nbt.m_128423_("energy"));
        }
    }
}

