/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import me.jddev0.ep.block.ChargerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import me.jddev0.ep.recipe.ChargerRecipe;
import me.jddev0.ep.screen.ChargerMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChargerBlockEntity
extends BlockEntity
implements MenuProvider,
EnergyStoragePacketUpdate,
RedstoneModeUpdate {
    public static final float CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER = ModConfigs.COMMON_CHARGER_CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER.getValue().floatValue();
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            ChargerBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                if (ChargerBlockEntity.this.f_58857_ == null || RecipeUtils.isIngredientOfAny(ChargerBlockEntity.this.f_58857_, ChargerRecipe.Type.INSTANCE, stack)) {
                    return true;
                }
                LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
                if (!energyStorageLazyOptional.isPresent()) {
                    return false;
                }
                IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
                return energyStorage.canReceive();
            }
            return super.isItemValid(slot, stack);
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                ItemStack itemStack = this.getStackInSlot(slot);
                if (!(ChargerBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_41656_((ItemStack)stack, (ItemStack)itemStack) && (ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack) || stack.getCapability(ForgeCapabilities.ENERGY).isPresent() && itemStack.getCapability(ForgeCapabilities.ENERGY).isPresent()))) {
                    ChargerBlockEntity.this.resetProgress();
                }
            }
            super.setStackInSlot(slot, stack);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> {
        if (i != 0) {
            return false;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(i.intValue());
        if (this.f_58857_ != null && RecipeUtils.isResultOfAny(this.f_58857_, ChargerRecipe.Type.INSTANCE, stack)) {
            return true;
        }
        if (this.f_58857_ == null || RecipeUtils.isIngredientOfAny(this.f_58857_, ChargerRecipe.Type.INSTANCE, stack)) {
            return false;
        }
        LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
        if (!energyStorageLazyOptional.isPresent()) {
            return true;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
        if (!energyStorage.canReceive()) {
            return true;
        }
        return energyStorage.receiveEnergy(this.energyStorage.getMaxReceive(), true) == 0;
    }));
    private final ReceiveOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    protected final ContainerData data;
    private int energyConsumptionLeft = -1;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    public ChargerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CHARGER_ENTITY.get(), blockPos, blockState);
        this.energyStorage = new ReceiveOnlyEnergyStorage(0, ModConfigs.COMMON_CHARGER_CAPACITY.getValue(), ModConfigs.COMMON_CHARGER_TRANSFER_RATE.getValue()){

            @Override
            protected void onChange() {
                ChargerBlockEntity.this.m_6596_();
                if (ChargerBlockEntity.this.f_58857_ != null && !ChargerBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, ChargerBlockEntity.this.m_58899_()), ChargerBlockEntity.this.m_58899_(), (ResourceKey<Level>)ChargerBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(ChargerBlockEntity.this.energyConsumptionLeft, index);
                    case 2 -> ChargerBlockEntity.this.redstoneMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        ChargerBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 3;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.charger");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new EnergySyncS2CPacket(this.energyStorage.getEnergy(), this.energyStorage.getCapacity(), this.m_58899_()), (ServerPlayer)player);
        return new ChargerMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        nbt.m_128365_("recipe.energy_consumption_left", (Tag)IntTag.m_128679_((int)this.energyConsumptionLeft));
        nbt.m_128405_("configuration.redstone_mode", this.redstoneMode.ordinal());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
        this.energyConsumptionLeft = nbt.m_128451_("recipe.energy_consumption_left");
        this.redstoneMode = RedstoneMode.fromIndex(nbt.m_128451_("configuration.redstone_mode"));
    }

    public void drops(Level level, BlockPos worldPosition) {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)level, (BlockPos)worldPosition, (Container)inventory);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ChargerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)ChargerBlock.POWERED))) {
            return;
        }
        if (blockEntity.hasRecipe()) {
            int energyConsumptionPerTick;
            ItemStack stack = blockEntity.itemHandler.getStackInSlot(0);
            SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
            for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
                inventory.m_6836_(i, blockEntity.itemHandler.getStackInSlot(i));
            }
            Optional recipe = level.m_7465_().m_44015_((RecipeType)ChargerRecipe.Type.INSTANCE, (Container)inventory, level);
            if (recipe.isPresent()) {
                if (blockEntity.energyConsumptionLeft == -1) {
                    blockEntity.energyConsumptionLeft = (int)((float)((ChargerRecipe)((RecipeHolder)recipe.get()).f_291008_()).getEnergyConsumption() * CHARGER_RECIPE_ENERGY_CONSUMPTION_MULTIPLIER);
                }
                if (blockEntity.energyStorage.getEnergy() == 0) {
                    ChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
                energyConsumptionPerTick = Math.min(blockEntity.energyConsumptionLeft, Math.min(blockEntity.energyStorage.getMaxReceive(), blockEntity.energyStorage.getEnergy()));
            } else {
                LazyOptional energyStorageLazyOptional = stack.getCapability(ForgeCapabilities.ENERGY);
                if (!energyStorageLazyOptional.isPresent()) {
                    return;
                }
                IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
                if (!energyStorage.canReceive()) {
                    return;
                }
                blockEntity.energyConsumptionLeft = energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored();
                if (blockEntity.energyStorage.getEnergy() == 0) {
                    ChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
                energyConsumptionPerTick = energyStorage.receiveEnergy(Math.min(blockEntity.energyStorage.getMaxReceive(), blockEntity.energyStorage.getEnergy()), false);
            }
            if (blockEntity.energyConsumptionLeft < 0 || energyConsumptionPerTick < 0) {
                blockEntity.resetProgress();
                ChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                return;
            }
            blockEntity.energyStorage.setEnergy(blockEntity.energyStorage.getEnergy() - energyConsumptionPerTick);
            blockEntity.energyConsumptionLeft -= energyConsumptionPerTick;
            if (blockEntity.energyConsumptionLeft <= 0) {
                recipe.ifPresent(chargerRecipe -> blockEntity.itemHandler.setStackInSlot(0, ((ChargerRecipe)chargerRecipe.f_291008_()).m_8043_(level.m_9598_()).m_255036_(1)));
                blockEntity.resetProgress();
            }
            ChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        } else {
            blockEntity.resetProgress();
            ChargerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.energyConsumptionLeft = -1;
    }

    private boolean hasRecipe() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            return true;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)ChargerRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        return recipe.isPresent();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.m_6596_();
    }
}

