/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import me.jddev0.ep.block.ChargingStationBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.integration.curios.CuriosCompatUtils;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import me.jddev0.ep.screen.ChargingStationMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChargingStationBlockEntity
extends BlockEntity
implements MenuProvider,
EnergyStoragePacketUpdate {
    public static final int MAX_CHARGING_DISTANCE = ModConfigs.COMMON_CHARGING_STATION_MAX_CHARGING_DISTANCE.getValue();
    private final ReceiveOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();

    public ChargingStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CHARGING_STATION_ENTITY.get(), blockPos, blockState);
        this.energyStorage = new ReceiveOnlyEnergyStorage(0, ModConfigs.COMMON_CHARGING_STATION_CAPACITY.getValue(), ModConfigs.COMMON_CHARGING_STATION_TRANSFER_RATE.getValue()){

            @Override
            protected void onChange() {
                ChargingStationBlockEntity.this.m_6596_();
                if (ChargingStationBlockEntity.this.f_58857_ != null && !ChargingStationBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, ChargingStationBlockEntity.this.m_58899_()), ChargingStationBlockEntity.this.m_58899_(), (ResourceKey<Level>)ChargingStationBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.charging_station");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new EnergySyncS2CPacket(this.energyStorage.getEnergy(), this.energyStorage.getCapacity(), this.m_58899_()), (ServerPlayer)player);
        return new ChargingStationMenu(id, inventory, this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ChargingStationBlockEntity blockEntity) {
        int energyPerTick;
        if (level.f_46443_) {
            return;
        }
        List players = level.m_142425_(EntityTypeTest.m_156916_(Player.class), AABB.m_82321_((BoundingBox)BoundingBox.m_162375_((Vec3i)new Vec3i(blockPos.m_123341_() - MAX_CHARGING_DISTANCE, blockPos.m_123342_() - MAX_CHARGING_DISTANCE, blockPos.m_123343_() - MAX_CHARGING_DISTANCE), (Vec3i)new Vec3i(blockPos.m_123341_() + MAX_CHARGING_DISTANCE, blockPos.m_123342_() + MAX_CHARGING_DISTANCE, blockPos.m_123343_() + MAX_CHARGING_DISTANCE))), EntitySelector.f_20408_.and(entity -> entity.m_20238_(blockPos.m_252807_()) <= (double)(MAX_CHARGING_DISTANCE * MAX_CHARGING_DISTANCE)));
        int energyPerTickLeft = energyPerTick = Math.min(blockEntity.energyStorage.getMaxReceive(), blockEntity.energyStorage.getEnergy());
        block0: for (Player player : players) {
            if (player.m_21224_()) continue;
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                IEnergyStorage energyStorage;
                ItemStack itemStack = inventory.m_8020_(i);
                LazyOptional energyStorageLazyOptional = itemStack.getCapability(ForgeCapabilities.ENERGY);
                if (energyStorageLazyOptional.isPresent() && (energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null)).canReceive() && (energyPerTickLeft -= energyStorage.receiveEnergy(energyPerTickLeft, false)) == 0) break block0;
            }
            List<ItemStack> curiosItemStacks = CuriosCompatUtils.getCuriosItemStacks(inventory);
            for (ItemStack itemStack : curiosItemStacks) {
                IEnergyStorage energyStorage;
                LazyOptional energyStorageLazyOptional = itemStack.getCapability(ForgeCapabilities.ENERGY);
                if (!energyStorageLazyOptional.isPresent() || !(energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null)).canReceive() || (energyPerTickLeft -= energyStorage.receiveEnergy(energyPerTickLeft, false)) != 0) continue;
                break block0;
            }
        }
        if (energyPerTickLeft == energyPerTick) {
            if (!level.m_8055_(blockPos).m_61138_((Property)ChargingStationBlock.CHARGING) || ((Boolean)level.m_8055_(blockPos).m_61143_((Property)ChargingStationBlock.CHARGING)).booleanValue()) {
                level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)ChargingStationBlock.CHARGING, (Comparable)Boolean.valueOf(false)), 3);
            }
        } else {
            if (!level.m_8055_(blockPos).m_61138_((Property)ChargingStationBlock.CHARGING) || !((Boolean)level.m_8055_(blockPos).m_61143_((Property)ChargingStationBlock.CHARGING)).booleanValue()) {
                level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)ChargingStationBlock.CHARGING, (Comparable)Boolean.TRUE), 3);
            }
            blockEntity.energyStorage.setEnergy(blockEntity.energyStorage.getEnergy() - energyPerTick + energyPerTickLeft);
        }
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }
}

