/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Optional;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import me.jddev0.ep.recipe.CompressorRecipe;
import me.jddev0.ep.screen.CompressorMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompressorBlockEntity
extends BlockEntity
implements MenuProvider,
EnergyStoragePacketUpdate,
RedstoneModeUpdate {
    private static final int ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_COMPRESSOR_ENERGY_CONSUMPTION_PER_TICK.getValue();
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            CompressorBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (CompressorBlockEntity.this.f_58857_ == null || RecipeUtils.isIngredientOfAny(CompressorBlockEntity.this.f_58857_, CompressorRecipe.Type.INSTANCE, stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                ItemStack itemStack = this.getStackInSlot(slot);
                if (!(CompressorBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                    CompressorBlockEntity.this.resetProgress(CompressorBlockEntity.this.f_58858_, CompressorBlockEntity.this.f_58857_.m_8055_(CompressorBlockEntity.this.f_58858_));
                }
            }
            super.setStackInSlot(slot, stack);
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1));
    private final ReceiveOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    protected final ContainerData data;
    private int progress;
    private int maxProgress = ModConfigs.COMMON_COMPRESSOR_RECIPE_DURATION.getValue();
    private int energyConsumptionLeft = -1;
    private boolean hasEnoughEnergy;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    public CompressorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.COMPRESSOR_ENTITY.get(), blockPos, blockState);
        this.energyStorage = new ReceiveOnlyEnergyStorage(0, ModConfigs.COMMON_COMPRESSOR_CAPACITY.getValue(), ModConfigs.COMMON_COMPRESSOR_TRANSFER_RATE.getValue()){

            @Override
            protected void onChange() {
                CompressorBlockEntity.this.m_6596_();
                if (CompressorBlockEntity.this.f_58857_ != null && !CompressorBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, CompressorBlockEntity.this.m_58899_()), CompressorBlockEntity.this.m_58899_(), (ResourceKey<Level>)CompressorBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(CompressorBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(CompressorBlockEntity.this.maxProgress, index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(CompressorBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 6 -> {
                        if (CompressorBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 7 -> CompressorBlockEntity.this.redstoneMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        CompressorBlockEntity.this.progress = ByteUtils.with2Bytes(CompressorBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        CompressorBlockEntity.this.maxProgress = ByteUtils.with2Bytes(CompressorBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        CompressorBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 8;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.compressor");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new EnergySyncS2CPacket(this.energyStorage.getEnergy(), this.energyStorage.getCapacity(), this.m_58899_()), (ServerPlayer)player);
        return new CompressorMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        nbt.m_128365_("recipe.progress", (Tag)IntTag.m_128679_((int)this.progress));
        nbt.m_128365_("recipe.energy_consumption_left", (Tag)IntTag.m_128679_((int)this.energyConsumptionLeft));
        nbt.m_128405_("configuration.redstone_mode", this.redstoneMode.ordinal());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
        this.progress = nbt.m_128451_("recipe.progress");
        this.energyConsumptionLeft = nbt.m_128451_("recipe.energy_consumption_left");
        this.redstoneMode = RedstoneMode.fromIndex(nbt.m_128451_("configuration.redstone_mode"));
    }

    public void drops(Level level, BlockPos worldPosition) {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)level, (BlockPos)worldPosition, (Container)inventory);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, CompressorBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)ComparatorBlock.f_52496_))) {
            return;
        }
        if (CompressorBlockEntity.hasRecipe(blockEntity)) {
            SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
            for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
                inventory.m_6836_(i, blockEntity.itemHandler.getStackInSlot(i));
            }
            Optional recipe = level.m_7465_().m_44015_((RecipeType)CompressorRecipe.Type.INSTANCE, (Container)inventory, level);
            if (recipe.isEmpty()) {
                return;
            }
            if (blockEntity.energyConsumptionLeft < 0) {
                blockEntity.energyConsumptionLeft = ENERGY_USAGE_PER_TICK * blockEntity.maxProgress;
            }
            if (ENERGY_USAGE_PER_TICK <= blockEntity.energyStorage.getEnergy()) {
                blockEntity.hasEnoughEnergy = true;
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0) {
                    blockEntity.resetProgress(blockPos, state);
                    CompressorBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
                blockEntity.energyStorage.setEnergy(blockEntity.energyStorage.getEnergy() - ENERGY_USAGE_PER_TICK);
                blockEntity.energyConsumptionLeft -= ENERGY_USAGE_PER_TICK;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    CompressorBlockEntity.craftItem(blockPos, state, blockEntity);
                }
                CompressorBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                CompressorBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            CompressorBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress(BlockPos blockPos, BlockState state) {
        this.progress = 0;
        this.energyConsumptionLeft = -1;
        this.hasEnoughEnergy = true;
    }

    private static void craftItem(BlockPos blockPos, BlockState state, CompressorBlockEntity blockEntity) {
        Level level = blockEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = level.m_7465_().m_44015_((RecipeType)CompressorRecipe.Type.INSTANCE, (Container)inventory, level);
        if (!CompressorBlockEntity.hasRecipe(blockEntity) || recipe.isEmpty()) {
            return;
        }
        blockEntity.itemHandler.extractItem(0, 1, false);
        blockEntity.itemHandler.setStackInSlot(1, ((CompressorRecipe)((RecipeHolder)recipe.get()).f_291008_()).m_8043_(level.m_9598_()).m_255036_(blockEntity.itemHandler.getStackInSlot(1).m_41613_() + ((CompressorRecipe)((RecipeHolder)recipe.get()).f_291008_()).m_8043_(level.m_9598_()).m_41613_()));
        blockEntity.resetProgress(blockPos, state);
    }

    private static boolean hasRecipe(CompressorBlockEntity blockEntity) {
        Level level = blockEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = level.m_7465_().m_44015_((RecipeType)CompressorRecipe.Type.INSTANCE, (Container)inventory, level);
        return recipe.isPresent() && CompressorBlockEntity.canInsertItemIntoOutputSlot(inventory, ((CompressorRecipe)((RecipeHolder)recipe.get()).f_291008_()).m_8043_(level.m_9598_()));
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack itemStack) {
        ItemStack inventoryItemStack = inventory.m_8020_(1);
        return (inventoryItemStack.m_41619_() || ItemStack.m_150942_((ItemStack)inventoryItemStack, (ItemStack)itemStack)) && inventoryItemStack.m_41741_() >= inventoryItemStack.m_41613_() + itemStack.m_41613_();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.m_6596_();
    }
}

