/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.fluid.FluidStoragePacketUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.FluidSyncS2CPacket;
import me.jddev0.ep.screen.DrainMenu;
import me.jddev0.ep.util.ByteUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrainBlockEntity
extends BlockEntity
implements MenuProvider,
FluidStoragePacketUpdate {
    private final FluidTank fluidStorage;
    private LazyOptional<IFluidHandler> lazyFluidStorage = LazyOptional.empty();
    protected final ContainerData data;
    private int progress;
    private int maxProgress = ModConfigs.COMMON_DRAIN_DRAIN_DURATION.getValue();

    public DrainBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.DRAIN_ENTITY.get(), blockPos, blockState);
        this.fluidStorage = new FluidTank(ModConfigs.COMMON_DRAIN_FLUID_TANK_CAPACITY.getValue() * 1000){

            protected void onContentsChanged() {
                DrainBlockEntity.this.m_6596_();
                if (DrainBlockEntity.this.f_58857_ != null && !DrainBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new FluidSyncS2CPacket(0, this.fluid, this.capacity, DrainBlockEntity.this.m_58899_()), DrainBlockEntity.this.m_58899_(), (ResourceKey<Level>)DrainBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(DrainBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(DrainBlockEntity.this.maxProgress, index - 2);
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        DrainBlockEntity.this.progress = ByteUtils.with2Bytes(DrainBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        DrainBlockEntity.this.maxProgress = ByteUtils.with2Bytes(DrainBlockEntity.this.maxProgress, (short)value, index - 2);
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.drain");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new FluidSyncS2CPacket(0, this.fluidStorage.getFluid(), this.fluidStorage.getCapacity(), this.f_58858_), (ServerPlayer)player);
        return new DrainMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        float fullnessPercent = 0.0f;
        boolean isEmptyFlag = true;
        FluidStack fluid = this.fluidStorage.getFluid();
        if (!fluid.isEmpty()) {
            fullnessPercent = (float)fluid.getAmount() / (float)this.fluidStorage.getCapacity();
            isEmptyFlag = false;
        }
        return Math.min(Mth.m_14143_((float)(fullnessPercent * 14.0f)) + (isEmptyFlag ? 0 : 1), 15);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyFluidStorage = LazyOptional.of(() -> this.fluidStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyFluidStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("fluid", (Tag)this.fluidStorage.writeToNBT(new CompoundTag()));
        nbt.m_128365_("drain.progress", (Tag)IntTag.m_128679_((int)this.progress));
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fluidStorage.readFromNBT(nbt.m_128469_("fluid"));
        this.progress = nbt.m_128451_("drain.progress");
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, DrainBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (DrainBlockEntity.hasRecipe(blockEntity)) {
            if (blockEntity.progress < 0 || blockEntity.maxProgress < 0) {
                blockEntity.resetProgress(blockPos, state);
                DrainBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                return;
            }
            if (blockEntity.progress < blockEntity.maxProgress) {
                ++blockEntity.progress;
            }
            if (blockEntity.progress >= blockEntity.maxProgress) {
                BucketPickup aboveBlock;
                ItemStack bucketItemStack;
                BlockPos aboveBlockPos = blockPos.m_7494_();
                BlockState aboveBlockState = level.m_8055_(aboveBlockPos);
                Block block = aboveBlockState.m_60734_();
                if (block instanceof BucketPickup && !(bucketItemStack = (aboveBlock = (BucketPickup)block).m_142598_(null, (LevelAccessor)level, aboveBlockPos, aboveBlockState)).m_41619_()) {
                    FluidStack fluidStack;
                    IFluidHandlerItem fluidStorage;
                    level.m_142346_(null, GameEvent.f_157816_, aboveBlockPos);
                    LazyOptional fluidStorageLazyOptional = bucketItemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
                    if (fluidStorageLazyOptional.isPresent() && (fluidStorage = (IFluidHandlerItem)fluidStorageLazyOptional.orElse(null)).getTanks() == 1 && !(fluidStack = fluidStorage.getFluidInTank(0)).isEmpty()) {
                        blockEntity.fluidStorage.fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                blockEntity.resetProgress(blockPos, state);
            }
            DrainBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        } else {
            blockEntity.resetProgress(blockPos, state);
            DrainBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress(BlockPos blockPos, BlockState state) {
        this.progress = 0;
    }

    private static boolean hasRecipe(DrainBlockEntity blockEntity) {
        BlockPos blockPos;
        BlockPos aboveBlockPos;
        Level level = blockEntity.m_58904_();
        BlockState aboveBlockState = level.m_8055_(aboveBlockPos = (blockPos = blockEntity.m_58899_()).m_7494_());
        if (!(aboveBlockState.m_60734_() instanceof BucketPickup)) {
            return false;
        }
        FluidState fluidState = level.m_6425_(aboveBlockPos);
        if (fluidState.m_76178_()) {
            return false;
        }
        return blockEntity.fluidStorage.fill(new FluidStack(fluidState.m_76152_(), 1000), IFluidHandler.FluidAction.SIMULATE) == 1000;
    }

    public FluidStack getFluid(int tank) {
        return this.fluidStorage.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.fluidStorage.getCapacity();
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        this.fluidStorage.setFluid(fluidStack);
    }

    @Override
    public void setTankCapacity(int tank, int capacity) {
        this.fluidStorage.setCapacity(capacity);
    }
}

