/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.FluidDrainerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.fluid.FluidStoragePacketUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import me.jddev0.ep.networking.packet.FluidSyncS2CPacket;
import me.jddev0.ep.screen.FluidDrainerMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidDrainerBlockEntity
extends BlockEntity
implements MenuProvider,
EnergyStoragePacketUpdate,
FluidStoragePacketUpdate,
RedstoneModeUpdate {
    public static final int MAX_FLUID_DRAINING_PER_TICK = ModConfigs.COMMON_FLUID_DRAINER_FLUID_ITEM_TRANSFER_RATE.getValue();
    public static final int ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_FLUID_DRAINER_ENERGY_CONSUMPTION_PER_TICK.getValue();
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            FluidDrainerBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
            }
            return super.isItemValid(slot, stack);
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                ItemStack itemStack = this.getStackInSlot(slot);
                if (!(FluidDrainerBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_41656_((ItemStack)stack, (ItemStack)itemStack) && (ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack) || stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() && itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()))) {
                    FluidDrainerBlockEntity.this.resetProgress();
                }
            }
            super.setStackInSlot(slot, stack);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> {
        if (i != 0) {
            return false;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(i.intValue());
        LazyOptional fluidStorageLazyOptional = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (!fluidStorageLazyOptional.isPresent()) {
            return true;
        }
        IFluidHandlerItem fluidStorage = (IFluidHandlerItem)fluidStorageLazyOptional.orElse(null);
        for (int j = 0; j < fluidStorage.getTanks(); ++j) {
            FluidStack fluidStack = fluidStorage.getFluidInTank(j);
            if (fluidStack.isEmpty() || (!this.fluidStorage.isEmpty() || !this.fluidStorage.isFluidValid(fluidStack)) && !fluidStack.isFluidEqual(this.fluidStorage.getFluid())) continue;
            return false;
        }
        return true;
    }));
    private final ReceiveOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private final FluidTank fluidStorage;
    private LazyOptional<IFluidHandler> lazyFluidStorage = LazyOptional.empty();
    protected final ContainerData data;
    private int fluidDrainingLeft = -1;
    private int fluidDrainingSumPending = 0;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    public FluidDrainerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.FLUID_DRAINER_ENTITY.get(), blockPos, blockState);
        this.energyStorage = new ReceiveOnlyEnergyStorage(0, ModConfigs.COMMON_FLUID_DRAINER_CAPACITY.getValue(), ModConfigs.COMMON_FLUID_DRAINER_TRANSFER_RATE.getValue()){

            @Override
            protected void onChange() {
                FluidDrainerBlockEntity.this.m_6596_();
                if (FluidDrainerBlockEntity.this.f_58857_ != null && !FluidDrainerBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, FluidDrainerBlockEntity.this.m_58899_()), FluidDrainerBlockEntity.this.m_58899_(), (ResourceKey<Level>)FluidDrainerBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
        this.fluidStorage = new FluidTank(ModConfigs.COMMON_FLUID_DRAINER_FLUID_TANK_CAPACITY.getValue() * 1000){

            protected void onContentsChanged() {
                FluidDrainerBlockEntity.this.m_6596_();
                if (FluidDrainerBlockEntity.this.f_58857_ != null && !FluidDrainerBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new FluidSyncS2CPacket(0, this.fluid, this.capacity, FluidDrainerBlockEntity.this.m_58899_()), FluidDrainerBlockEntity.this.m_58899_(), (ResourceKey<Level>)FluidDrainerBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(FluidDrainerBlockEntity.this.fluidDrainingLeft, index);
                    case 2, 3 -> ByteUtils.get2Bytes(FluidDrainerBlockEntity.this.fluidDrainingSumPending, index - 2);
                    case 4 -> FluidDrainerBlockEntity.this.redstoneMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        FluidDrainerBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 5;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.fluid_drainer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new EnergySyncS2CPacket(this.energyStorage.getEnergy(), this.energyStorage.getCapacity(), this.m_58899_()), (ServerPlayer)player);
        ModMessages.sendToPlayer(new FluidSyncS2CPacket(0, this.fluidStorage.getFluid(), this.fluidStorage.getCapacity(), this.f_58858_), (ServerPlayer)player);
        return new FluidDrainerMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
        this.lazyFluidStorage = LazyOptional.of(() -> this.fluidStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
        this.lazyFluidStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        nbt.m_128365_("fluid", (Tag)this.fluidStorage.writeToNBT(new CompoundTag()));
        nbt.m_128365_("recipe.fluid_draining_left", (Tag)IntTag.m_128679_((int)this.fluidDrainingLeft));
        nbt.m_128365_("recipe.fluid_draining_sum_pending", (Tag)IntTag.m_128679_((int)this.fluidDrainingSumPending));
        nbt.m_128405_("configuration.redstone_mode", this.redstoneMode.ordinal());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
        this.fluidStorage.readFromNBT(nbt.m_128469_("fluid"));
        this.fluidDrainingLeft = nbt.m_128451_("recipe.fluid_draining_left");
        this.fluidDrainingSumPending = nbt.m_128451_("recipe.fluid_draining_sum_pending");
        this.redstoneMode = RedstoneMode.fromIndex(nbt.m_128451_("configuration.redstone_mode"));
    }

    public void drops(Level level, BlockPos worldPosition) {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)level, (BlockPos)worldPosition, (Container)inventory);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, FluidDrainerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)FluidDrainerBlock.POWERED))) {
            return;
        }
        if (blockEntity.hasRecipe()) {
            ItemStack stack = blockEntity.itemHandler.getStackInSlot(0);
            int fluidDrainingSum = 0;
            int fluidDrainingLeftSum = 0;
            if (blockEntity.fluidStorage.getCapacity() - blockEntity.fluidStorage.getFluidAmount() - blockEntity.fluidDrainingSumPending <= 0) {
                return;
            }
            if (blockEntity.energyStorage.getEnergy() < ENERGY_USAGE_PER_TICK) {
                return;
            }
            LazyOptional fluidStorageLazyOptional = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (!fluidStorageLazyOptional.isPresent()) {
                return;
            }
            IFluidHandlerItem fluidStorage = (IFluidHandlerItem)fluidStorageLazyOptional.orElse(null);
            FluidStack firstNonEmptyFluidStack = FluidStack.EMPTY;
            for (int i = 0; i < fluidStorage.getTanks(); ++i) {
                FluidStack fluidStack = fluidStorage.getFluidInTank(i);
                if (!fluidStack.isEmpty() && firstNonEmptyFluidStack.isEmpty()) {
                    firstNonEmptyFluidStack = fluidStack;
                }
                if (fluidStack.isEmpty() || (!blockEntity.fluidStorage.isEmpty() || !blockEntity.fluidStorage.isFluidValid(fluidStack) || !fluidStack.isFluidEqual(firstNonEmptyFluidStack)) && !fluidStack.isFluidEqual(blockEntity.fluidStorage.getFluid())) continue;
                fluidDrainingSum += Math.min(blockEntity.fluidStorage.getCapacity() - blockEntity.fluidStorage.getFluidAmount() - blockEntity.fluidDrainingSumPending - fluidDrainingSum, Math.min(fluidStack.getAmount(), MAX_FLUID_DRAINING_PER_TICK - fluidDrainingSum));
                fluidDrainingLeftSum += fluidStack.getAmount();
            }
            if (firstNonEmptyFluidStack.isEmpty() || fluidDrainingSum == 0) {
                return;
            }
            blockEntity.fluidDrainingLeft = fluidDrainingLeftSum;
            blockEntity.fluidDrainingSumPending += fluidDrainingSum;
            blockEntity.energyStorage.setEnergy(blockEntity.energyStorage.getEnergy() - ENERGY_USAGE_PER_TICK);
            int fluidSumDrainable = Math.min(blockEntity.fluidStorage.getCapacity() - blockEntity.fluidStorage.getFluidAmount(), blockEntity.fluidDrainingSumPending);
            FluidStack fluidStackToDrain = blockEntity.fluidStorage.isEmpty() ? firstNonEmptyFluidStack : blockEntity.getFluid(0);
            FluidStack fluidSumDrained = fluidStorage.drain(new FluidStack(fluidStackToDrain.getFluid(), fluidSumDrainable, fluidStackToDrain.getTag()), IFluidHandler.FluidAction.EXECUTE);
            if (fluidSumDrained.isEmpty()) {
                FluidDrainerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                return;
            }
            blockEntity.itemHandler.setStackInSlot(0, fluidStorage.getContainer());
            blockEntity.fluidStorage.fill(fluidSumDrained, IFluidHandler.FluidAction.EXECUTE);
            blockEntity.fluidDrainingSumPending -= fluidSumDrained.getAmount();
            blockEntity.fluidDrainingLeft = fluidDrainingLeftSum - fluidSumDrained.getAmount();
            if (blockEntity.fluidDrainingLeft <= 0) {
                blockEntity.resetProgress();
            }
            FluidDrainerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        } else {
            blockEntity.resetProgress();
            FluidDrainerBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress() {
        this.fluidDrainingLeft = -1;
        this.fluidDrainingSumPending = 0;
    }

    private boolean hasRecipe() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            LazyOptional fluidStorageLazyOptional = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
            if (!fluidStorageLazyOptional.isPresent()) {
                return false;
            }
            IFluidHandlerItem fluidStorage = (IFluidHandlerItem)fluidStorageLazyOptional.orElse(null);
            for (int i = 0; i < fluidStorage.getTanks(); ++i) {
                FluidStack fluidStack = fluidStorage.getFluidInTank(i);
                if (fluidStack.isEmpty() || (!this.fluidStorage.isEmpty() || !this.fluidStorage.isFluidValid(fluidStack)) && !fluidStack.isFluidEqual(this.fluidStorage.getFluid())) continue;
                return true;
            }
        }
        return false;
    }

    public FluidStack getFluid(int tank) {
        return this.fluidStorage.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.fluidStorage.getCapacity();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        this.fluidStorage.setFluid(fluidStack);
    }

    @Override
    public void setTankCapacity(int tank, int capacity) {
        this.fluidStorage.setCapacity(capacity);
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.m_6596_();
    }
}

