/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.FluidTankBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.fluid.FluidStoragePacketUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.FluidSyncS2CPacket;
import me.jddev0.ep.screen.FluidTankMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidTankBlockEntity
extends BlockEntity
implements MenuProvider,
FluidStoragePacketUpdate {
    private final FluidTankBlock.Tier tier;
    private final FluidTank fluidStorage;
    private LazyOptional<IFluidHandler> lazyFluidStorage = LazyOptional.empty();

    public static BlockEntityType<FluidTankBlockEntity> getEntityTypeFromTier(FluidTankBlock.Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case FluidTankBlock.Tier.SMALL -> (BlockEntityType)ModBlockEntities.FLUID_TANK_SMALL_ENTITY.get();
            case FluidTankBlock.Tier.MEDIUM -> (BlockEntityType)ModBlockEntities.FLUID_TANK_MEDIUM_ENTITY.get();
            case FluidTankBlock.Tier.LARGE -> (BlockEntityType)ModBlockEntities.FLUID_TANK_LARGE_ENTITY.get();
        };
    }

    public FluidTankBlockEntity(BlockPos blockPos, BlockState blockState, FluidTankBlock.Tier tier) {
        super(FluidTankBlockEntity.getEntityTypeFromTier(tier), blockPos, blockState);
        this.tier = tier;
        this.fluidStorage = new FluidTank(tier.getTankCapacity()){

            protected void onContentsChanged() {
                FluidTankBlockEntity.this.m_6596_();
                if (FluidTankBlockEntity.this.f_58857_ != null && !FluidTankBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new FluidSyncS2CPacket(0, this.fluid, this.capacity, FluidTankBlockEntity.this.m_58899_()), FluidTankBlockEntity.this.m_58899_(), (ResourceKey<Level>)FluidTankBlockEntity.this.f_58857_.m_46472_(), 64);
                }
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)("container.energizedpower." + this.tier.getResourceId()));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new FluidSyncS2CPacket(0, this.fluidStorage.getFluid(), this.fluidStorage.getCapacity(), this.f_58858_), (ServerPlayer)player);
        return new FluidTankMenu(id, inventory, this);
    }

    public FluidTankBlock.Tier getTier() {
        return this.tier;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, FluidTankBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (level.m_46467_() % 100L == 0L) {
            ModMessages.sendToPlayersWithinXBlocks(new FluidSyncS2CPacket(0, blockEntity.getFluid(0), blockEntity.getTankCapacity(0), blockPos), blockPos, (ResourceKey<Level>)level.m_46472_(), 64);
        }
    }

    public int getRedstoneOutput() {
        float fullnessPercent = 0.0f;
        boolean isEmptyFlag = true;
        FluidStack fluid = this.fluidStorage.getFluid();
        if (!fluid.isEmpty()) {
            fullnessPercent = (float)fluid.getAmount() / (float)this.fluidStorage.getCapacity();
            isEmptyFlag = false;
        }
        return Math.min(Mth.m_14143_((float)(fullnessPercent * 14.0f)) + (isEmptyFlag ? 0 : 1), 15);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyFluidStorage = LazyOptional.of(() -> this.fluidStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyFluidStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("fluid", (Tag)this.fluidStorage.writeToNBT(new CompoundTag()));
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fluidStorage.readFromNBT(nbt.m_128469_("fluid"));
    }

    public FluidStack getFluid(int tank) {
        return this.fluidStorage.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.fluidStorage.getCapacity();
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        this.fluidStorage.setFluid(fluidStack);
    }

    @Override
    public void setTankCapacity(int tank, int capacity) {
        this.fluidStorage.setCapacity(capacity);
    }
}

