/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.PlantGrowthChamberBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import me.jddev0.ep.recipe.PlantGrowthChamberFertilizerRecipe;
import me.jddev0.ep.recipe.PlantGrowthChamberRecipe;
import me.jddev0.ep.screen.PlantGrowthChamberMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import me.jddev0.ep.util.RecipeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlantGrowthChamberBlockEntity
extends BlockEntity
implements MenuProvider,
EnergyStoragePacketUpdate,
RedstoneModeUpdate {
    private static final int ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_ENERGY_CONSUMPTION_PER_TICK.getValue();
    public static final float RECIPE_DURATION_MULTIPLIER = ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_RECIPE_DURATION_MULTIPLIER.getValue().floatValue();
    private final ItemStackHandler itemHandler = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            PlantGrowthChamberBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (PlantGrowthChamberBlockEntity.this.f_58857_ == null || RecipeUtils.isIngredientOfAny(PlantGrowthChamberBlockEntity.this.f_58857_, PlantGrowthChamberRecipe.Type.INSTANCE, stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (PlantGrowthChamberBlockEntity.this.f_58857_ == null || RecipeUtils.isIngredientOfAny(PlantGrowthChamberBlockEntity.this.f_58857_, PlantGrowthChamberFertilizerRecipe.Type.INSTANCE, stack)) {
                        yield true;
                    }
                    yield false;
                }
                case 2, 3, 4, 5 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                ItemStack itemStack = this.getStackInSlot(slot);
                if (!(PlantGrowthChamberBlockEntity.this.f_58857_ == null || stack.m_41619_() || itemStack.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack))) {
                    PlantGrowthChamberBlockEntity.this.resetProgress(PlantGrowthChamberBlockEntity.this.f_58858_, PlantGrowthChamberBlockEntity.this.f_58857_.m_8055_(PlantGrowthChamberBlockEntity.this.f_58858_));
                }
            }
            super.setStackInSlot(slot, stack);
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final LazyOptional<IItemHandler> lazyItemHandlerSidesSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i > 1 && i < 6));
    private final LazyOptional<IItemHandler> lazyItemHandlerTopBottomSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 1, i -> i > 1 && i < 6));
    private final ReceiveOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    protected final ContainerData data;
    private int progress;
    private int maxProgress;
    private int energyConsumptionLeft = -1;
    private boolean hasEnoughEnergy;
    private double speedMultiplier = 1.0;
    private double energyConsumptionMultiplier = 1.0;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    public PlantGrowthChamberBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.PLANT_GROWTH_CHAMBER_ENTITY.get(), blockPos, blockState);
        this.energyStorage = new ReceiveOnlyEnergyStorage(0, ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_CAPACITY.getValue(), ModConfigs.COMMON_PLANT_GROWTH_CHAMBER_TRANSFER_RATE.getValue()){

            @Override
            protected void onChange() {
                PlantGrowthChamberBlockEntity.this.m_6596_();
                if (PlantGrowthChamberBlockEntity.this.f_58857_ != null && !PlantGrowthChamberBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, PlantGrowthChamberBlockEntity.this.m_58899_()), PlantGrowthChamberBlockEntity.this.m_58899_(), (ResourceKey<Level>)PlantGrowthChamberBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(PlantGrowthChamberBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(PlantGrowthChamberBlockEntity.this.maxProgress, index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(PlantGrowthChamberBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 6 -> {
                        if (PlantGrowthChamberBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 7 -> PlantGrowthChamberBlockEntity.this.redstoneMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        PlantGrowthChamberBlockEntity.this.progress = ByteUtils.with2Bytes(PlantGrowthChamberBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        PlantGrowthChamberBlockEntity.this.maxProgress = ByteUtils.with2Bytes(PlantGrowthChamberBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        PlantGrowthChamberBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 8;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.plant_growth_chamber");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new EnergySyncS2CPacket(this.energyStorage.getEnergy(), this.energyStorage.getCapacity(), this.m_58899_()), (ServerPlayer)player);
        return new PlantGrowthChamberMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            if (side == Direction.UP || side == Direction.DOWN) {
                return this.lazyItemHandlerTopBottomSided.cast();
            }
            return this.lazyItemHandlerSidesSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        nbt.m_128365_("recipe.progress", (Tag)IntTag.m_128679_((int)this.progress));
        nbt.m_128365_("recipe.max_progress", (Tag)IntTag.m_128679_((int)this.maxProgress));
        nbt.m_128365_("recipe.energy_consumption_left", (Tag)IntTag.m_128679_((int)this.energyConsumptionLeft));
        nbt.m_128365_("recipe.speed_multiplier", (Tag)DoubleTag.m_128500_((double)this.speedMultiplier));
        nbt.m_128365_("recipe.energy_consumption_multiplier", (Tag)DoubleTag.m_128500_((double)this.energyConsumptionMultiplier));
        nbt.m_128405_("configuration.redstone_mode", this.redstoneMode.ordinal());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
        this.progress = nbt.m_128451_("recipe.progress");
        this.maxProgress = nbt.m_128451_("recipe.max_progress");
        this.energyConsumptionLeft = nbt.m_128451_("recipe.energy_consumption_left");
        this.speedMultiplier = nbt.m_128459_("recipe.speed_multiplier");
        this.energyConsumptionMultiplier = nbt.m_128459_("recipe.energy_consumption_multiplier");
        this.redstoneMode = RedstoneMode.fromIndex(nbt.m_128451_("configuration.redstone_mode"));
    }

    public void drops(Level level, BlockPos worldPosition) {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)level, (BlockPos)worldPosition, (Container)inventory);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, PlantGrowthChamberBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)PlantGrowthChamberBlock.POWERED))) {
            return;
        }
        if (PlantGrowthChamberBlockEntity.hasRecipe(blockEntity)) {
            SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
            for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
                inventory.m_6836_(i, blockEntity.itemHandler.getStackInSlot(i));
            }
            Optional recipe = level.m_7465_().m_44015_((RecipeType)PlantGrowthChamberRecipe.Type.INSTANCE, (Container)inventory, level);
            if (recipe.isEmpty()) {
                return;
            }
            Optional fertilizerRecipe = level.m_7465_().m_44015_((RecipeType)PlantGrowthChamberFertilizerRecipe.Type.INSTANCE, (Container)inventory, level);
            if (blockEntity.maxProgress == 0) {
                if (fertilizerRecipe.isPresent()) {
                    blockEntity.speedMultiplier = ((PlantGrowthChamberFertilizerRecipe)((RecipeHolder)fertilizerRecipe.get()).f_291008_()).getSpeedMultiplier();
                    blockEntity.energyConsumptionMultiplier = ((PlantGrowthChamberFertilizerRecipe)((RecipeHolder)fertilizerRecipe.get()).f_291008_()).getEnergyConsumptionMultiplier();
                    blockEntity.itemHandler.extractItem(1, 1, false);
                }
                blockEntity.maxProgress = (int)((double)((float)((PlantGrowthChamberRecipe)((RecipeHolder)recipe.get()).f_291008_()).getTicks() * RECIPE_DURATION_MULTIPLIER) / blockEntity.speedMultiplier);
            }
            int fertilizedEnergyUsagePerTick = (int)((double)ENERGY_USAGE_PER_TICK * blockEntity.energyConsumptionMultiplier);
            if (blockEntity.energyConsumptionLeft < 0) {
                blockEntity.energyConsumptionLeft = fertilizedEnergyUsagePerTick * blockEntity.maxProgress;
            }
            if (fertilizedEnergyUsagePerTick <= blockEntity.energyStorage.getEnergy()) {
                blockEntity.hasEnoughEnergy = true;
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0 || fertilizedEnergyUsagePerTick < 0) {
                    blockEntity.resetProgress(blockPos, state);
                    PlantGrowthChamberBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
                blockEntity.energyStorage.setEnergy(blockEntity.energyStorage.getEnergy() - fertilizedEnergyUsagePerTick);
                blockEntity.energyConsumptionLeft -= fertilizedEnergyUsagePerTick;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    PlantGrowthChamberBlockEntity.craftItem(blockPos, state, blockEntity);
                }
                PlantGrowthChamberBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                PlantGrowthChamberBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            PlantGrowthChamberBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress(BlockPos blockPos, BlockState state) {
        this.progress = 0;
        this.maxProgress = 0;
        this.energyConsumptionLeft = -1;
        this.hasEnoughEnergy = true;
        this.speedMultiplier = 1.0;
        this.energyConsumptionMultiplier = 1.0;
    }

    private static void craftItem(BlockPos blockPos, BlockState state, PlantGrowthChamberBlockEntity blockEntity) {
        Level level = blockEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = level.m_7465_().m_44015_((RecipeType)PlantGrowthChamberRecipe.Type.INSTANCE, (Container)inventory, level);
        if (!PlantGrowthChamberBlockEntity.hasRecipe(blockEntity) || recipe.isEmpty()) {
            return;
        }
        blockEntity.itemHandler.extractItem(0, 1, false);
        ArrayList<ItemStack> itemStacksInsert = new ArrayList<ItemStack>(Arrays.asList(((PlantGrowthChamberRecipe)((RecipeHolder)recipe.get()).f_291008_()).generateOutputs(level.f_46441_)));
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(4);
        block1: for (ItemStack itemStack : itemStacksInsert) {
            if (itemStack.m_41619_()) continue;
            for (int i = 2; i < blockEntity.itemHandler.getSlots(); ++i) {
                int amount;
                ItemStack testItemStack = blockEntity.itemHandler.getStackInSlot(i);
                if (emptyIndices.contains(i)) continue;
                if (testItemStack.m_41619_()) {
                    emptyIndices.add(i);
                    continue;
                }
                if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)testItemStack) || (amount = Math.min(itemStack.m_41613_(), testItemStack.m_41741_() - testItemStack.m_41613_())) <= 0) continue;
                blockEntity.itemHandler.setStackInSlot(i, blockEntity.itemHandler.getStackInSlot(i).m_255036_(testItemStack.m_41613_() + amount));
                itemStack.m_41764_(itemStack.m_41613_() - amount);
                if (itemStack.m_41619_()) continue block1;
            }
            if (emptyIndices.isEmpty()) continue;
            blockEntity.itemHandler.setStackInSlot(((Integer)emptyIndices.remove(0)).intValue(), itemStack);
        }
        blockEntity.resetProgress(blockPos, state);
    }

    private static boolean hasRecipe(PlantGrowthChamberBlockEntity blockEntity) {
        Level level = blockEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        Optional recipe = level.m_7465_().m_44015_((RecipeType)PlantGrowthChamberRecipe.Type.INSTANCE, (Container)inventory, level);
        return recipe.isPresent() && PlantGrowthChamberBlockEntity.canInsertItemsIntoOutputSlots(inventory, new ArrayList<ItemStack>(Arrays.asList(((PlantGrowthChamberRecipe)((RecipeHolder)recipe.get()).f_291008_()).getMaxOutputCounts())));
    }

    private static boolean canInsertItemsIntoOutputSlots(SimpleContainer inventory, List<ItemStack> itemsStacks) {
        ArrayList<Integer> checkedIndices = new ArrayList<Integer>(4);
        ArrayList<Integer> emptyIndices = new ArrayList<Integer>(4);
        block0: for (int i = Math.min(4, itemsStacks.size()) - 1; i >= 0; --i) {
            ItemStack itemStack = itemsStacks.get(i);
            for (int j = 2; j < inventory.m_6643_(); ++j) {
                if (checkedIndices.contains(j) || emptyIndices.contains(j)) continue;
                ItemStack testItemStack = inventory.m_8020_(j);
                if (testItemStack.m_41619_()) {
                    emptyIndices.add(j);
                    continue;
                }
                if (!ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)testItemStack)) continue;
                int amount = Math.min(itemStack.m_41613_(), testItemStack.m_41741_() - testItemStack.m_41613_());
                if (amount + testItemStack.m_41613_() == testItemStack.m_41741_()) {
                    checkedIndices.add(j);
                }
                if (amount == itemStack.m_41613_()) {
                    itemsStacks.remove(i);
                    continue block0;
                }
                itemStack.m_41774_(amount);
            }
            if (emptyIndices.isEmpty()) {
                return false;
            }
            int index = (Integer)emptyIndices.remove(0);
            if (itemStack.m_41613_() == itemStack.m_41741_()) {
                checkedIndices.add(index);
            }
            itemsStacks.remove(i);
        }
        return itemsStacks.isEmpty();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.m_6596_();
    }
}

