/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.PoweredLampBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PoweredLampBlockEntity
extends BlockEntity
implements EnergyStoragePacketUpdate {
    public static final int MAX_RECEIVE = ModConfigs.COMMON_POWERED_LAMP_TRANSFER_RATE.getValue();
    private final ReceiveOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();

    public PoweredLampBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.POWERED_LAMP_ENTITY.get(), blockPos, blockState);
        this.energyStorage = new ReceiveOnlyEnergyStorage(0, MAX_RECEIVE, MAX_RECEIVE){

            @Override
            protected void onChange() {
                PoweredLampBlockEntity.this.m_6596_();
                if (PoweredLampBlockEntity.this.f_58857_ != null && !PoweredLampBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, PoweredLampBlockEntity.this.m_58899_()), PoweredLampBlockEntity.this.m_58899_(), (ResourceKey<Level>)PoweredLampBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, PoweredLampBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        boolean isEmptyFlag = blockEntity.energyStorage.getEnergy() == 0;
        int levelValue = Math.min(Mth.m_14143_((float)((float)blockEntity.energyStorage.getEnergy() / (float)blockEntity.energyStorage.getCapacity() * 14.0f)) + (isEmptyFlag ? 0 : 1), 15);
        if ((Integer)state.m_61143_((Property)PoweredLampBlock.LEVEL) != levelValue) {
            level.m_7731_(blockPos, (BlockState)state.m_61124_((Property)PoweredLampBlock.LEVEL, (Comparable)Integer.valueOf(levelValue)), 3);
        }
        blockEntity.energyStorage.setEnergy(0);
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }
}

