/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncPressMoldMakerRecipeListS2CPacket;
import me.jddev0.ep.recipe.PressMoldMakerRecipe;
import me.jddev0.ep.screen.PressMoldMakerMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PressMoldMakerBlockEntity
extends BlockEntity
implements MenuProvider {
    private List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> recipeList = new ArrayList<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>>();
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            PressMoldMakerBlockEntity.this.m_6596_();
            if (slot == 0 && PressMoldMakerBlockEntity.this.f_58857_ != null && !PressMoldMakerBlockEntity.this.f_58857_.m_5776_()) {
                List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> recipeList = PressMoldMakerBlockEntity.this.createRecipeList();
                ModMessages.sendToPlayersWithinXBlocks(new SyncPressMoldMakerRecipeListS2CPacket(PressMoldMakerBlockEntity.this.m_58899_(), recipeList), PressMoldMakerBlockEntity.this.m_58899_(), (ResourceKey<Level>)PressMoldMakerBlockEntity.this.f_58857_.m_46472_(), 32);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (PressMoldMakerBlockEntity.this.f_58857_ == null || stack.m_150930_(Items.f_42461_)) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1));

    public PressMoldMakerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.PRESS_MOLD_MAKER_ENTITY.get(), blockPos, blockState);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.press_mold_maker");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> recipeList = this.createRecipeList();
        ModMessages.sendToPlayer(new SyncPressMoldMakerRecipeListS2CPacket(this.m_58899_(), recipeList), (ServerPlayer)player);
        return new PressMoldMakerMenu(id, inventory, this);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
    }

    public void drops(Level level, BlockPos worldPosition) {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)level, (BlockPos)worldPosition, (Container)inventory);
    }

    public void craftItem(ResourceLocation recipeId) {
        Recipe recipe;
        Optional<RecipeHolder> recipe2 = this.f_58857_.m_7465_().m_44051_().stream().filter(recipeHolder -> recipeHolder.f_291676_().equals((Object)recipeId)).findFirst();
        if (recipe2.isEmpty() || !((recipe = recipe2.get().f_291008_()) instanceof PressMoldMakerRecipe)) {
            return;
        }
        PressMoldMakerRecipe pressMoldMakerRecipe = (PressMoldMakerRecipe)recipe;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        if (!pressMoldMakerRecipe.matches(inventory, this.f_58857_) || !PressMoldMakerBlockEntity.canInsertItemIntoOutputSlot(inventory, pressMoldMakerRecipe.m_8043_(this.f_58857_.m_9598_()))) {
            return;
        }
        this.itemHandler.extractItem(0, pressMoldMakerRecipe.getClayCount(), false);
        this.itemHandler.setStackInSlot(1, pressMoldMakerRecipe.m_8043_(this.f_58857_.m_9598_()).m_255036_(this.itemHandler.getStackInSlot(1).m_41613_() + pressMoldMakerRecipe.m_8043_(this.f_58857_.m_9598_()).m_41613_()));
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack itemStack) {
        ItemStack inventoryItemStack = inventory.m_8020_(1);
        return (inventoryItemStack.m_41619_() || ItemStack.m_150942_((ItemStack)inventoryItemStack, (ItemStack)itemStack)) && inventoryItemStack.m_41741_() >= inventoryItemStack.m_41613_() + itemStack.m_41613_();
    }

    private List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> createRecipeList() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        List recipes = this.f_58857_.m_7465_().m_44013_((RecipeType)PressMoldMakerRecipe.Type.INSTANCE);
        return recipes.stream().sorted(Comparator.comparing(recipe -> ((PressMoldMakerRecipe)recipe.f_291008_()).m_8043_(this.f_58857_.m_9598_()).m_41778_())).map(recipe -> Pair.of((Object)recipe, (Object)((PressMoldMakerRecipe)recipe.f_291008_()).matches(inventory, this.f_58857_))).collect(Collectors.toList());
    }

    public List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> getRecipeList() {
        return this.recipeList;
    }

    public void setRecipeList(List<Pair<RecipeHolder<PressMoldMakerRecipe>, Boolean>> recipeList) {
        this.recipeList = recipeList;
    }
}

