/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.SolarPanelBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ExtractOnlyEnergyStorage;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import me.jddev0.ep.screen.SolarPanelMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolarPanelBlockEntity
extends BlockEntity
implements MenuProvider,
EnergyStoragePacketUpdate {
    private final SolarPanelBlock.Tier tier;
    private final int maxTransfer;
    private final ExtractOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();

    public static BlockEntityType<SolarPanelBlockEntity> getEntityTypeFromTier(SolarPanelBlock.Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case SolarPanelBlock.Tier.TIER_1 -> (BlockEntityType)ModBlockEntities.SOLAR_PANEL_ENTITY_1.get();
            case SolarPanelBlock.Tier.TIER_2 -> (BlockEntityType)ModBlockEntities.SOLAR_PANEL_ENTITY_2.get();
            case SolarPanelBlock.Tier.TIER_3 -> (BlockEntityType)ModBlockEntities.SOLAR_PANEL_ENTITY_3.get();
            case SolarPanelBlock.Tier.TIER_4 -> (BlockEntityType)ModBlockEntities.SOLAR_PANEL_ENTITY_4.get();
            case SolarPanelBlock.Tier.TIER_5 -> (BlockEntityType)ModBlockEntities.SOLAR_PANEL_ENTITY_5.get();
            case SolarPanelBlock.Tier.TIER_6 -> (BlockEntityType)ModBlockEntities.SOLAR_PANEL_ENTITY_6.get();
        };
    }

    public SolarPanelBlockEntity(BlockPos blockPos, BlockState blockState, SolarPanelBlock.Tier tier) {
        super(SolarPanelBlockEntity.getEntityTypeFromTier(tier), blockPos, blockState);
        this.tier = tier;
        this.maxTransfer = tier.getMaxTransfer();
        int capacity = tier.getCapacity();
        this.energyStorage = new ExtractOnlyEnergyStorage(0, capacity, this.maxTransfer){

            @Override
            protected void onChange() {
                SolarPanelBlockEntity.this.m_6596_();
                if (SolarPanelBlockEntity.this.f_58857_ != null && !SolarPanelBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, SolarPanelBlockEntity.this.m_58899_()), SolarPanelBlockEntity.this.m_58899_(), (ResourceKey<Level>)SolarPanelBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)("container.energizedpower." + this.tier.getResourceId()));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new EnergySyncS2CPacket(this.energyStorage.getEnergy(), this.energyStorage.getCapacity(), this.m_58899_()), (ServerPlayer)player);
        return new SolarPanelMenu(id, inventory, this);
    }

    public SolarPanelBlock.Tier getTier() {
        return this.tier;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, SolarPanelBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        int i = 4 * (level.m_45517_(LightLayer.SKY, blockPos) - level.m_7445_());
        float f = level.m_46490_(1.0f);
        if (i > 0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            i = Math.round((float)i * Mth.m_14089_((float)f));
        }
        i = Mth.m_14045_((int)i, (int)0, (int)60);
        blockEntity.energyStorage.setEnergy(Math.min(blockEntity.energyStorage.getCapacity(), blockEntity.energyStorage.getEnergy() + (int)((float)i / 60.0f * (float)blockEntity.getTier().getPeakFePerTick())));
        SolarPanelBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void transferEnergy(Level level, BlockPos blockPos, BlockState state, SolarPanelBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        BlockPos testPos = blockPos.m_121945_(Direction.DOWN);
        BlockEntity testBlockEntity = level.m_7702_(testPos);
        if (testBlockEntity == null) {
            return;
        }
        LazyOptional energyStorageLazyOptional = testBlockEntity.getCapability(ForgeCapabilities.ENERGY, Direction.DOWN.m_122424_());
        if (!energyStorageLazyOptional.isPresent()) {
            return;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
        if (!energyStorage.canReceive()) {
            return;
        }
        int amount = energyStorage.receiveEnergy(Math.min(blockEntity.energyStorage.getEnergy(), blockEntity.maxTransfer), false);
        if (amount > 0) {
            blockEntity.energyStorage.extractEnergy(amount, false);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY && (side == null || side == Direction.DOWN)) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }
}

