/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import me.jddev0.ep.block.StoneSolidifierBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.fluid.EnergizedPowerFluidStorage;
import me.jddev0.ep.fluid.FluidStoragePacketUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import me.jddev0.ep.networking.packet.FluidSyncS2CPacket;
import me.jddev0.ep.networking.packet.SyncStoneSolidifierCurrentRecipeS2CPacket;
import me.jddev0.ep.recipe.StoneSolidifierRecipe;
import me.jddev0.ep.screen.StoneSolidifierMenu;
import me.jddev0.ep.util.ByteUtils;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneSolidifierBlockEntity
extends BlockEntity
implements MenuProvider,
EnergyStoragePacketUpdate,
FluidStoragePacketUpdate,
RedstoneModeUpdate {
    public static final int ENERGY_USAGE_PER_TICK = ModConfigs.COMMON_STONE_SOLIDIFIER_CONSUMPTION_PER_TICK.getValue();
    public static final int TANK_CAPACITY = 1000 * ModConfigs.COMMON_STONE_SOLIDIFIER_TANK_CAPACITY.getValue();
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            StoneSolidifierBlockEntity.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> false, i -> i == 0));
    private final ReceiveOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private final EnergizedPowerFluidStorage fluidStorage;
    private LazyOptional<IFluidHandler> lazyFluidStorage = LazyOptional.empty();
    protected final ContainerData data;
    private ResourceLocation currentRecipeIdForLoad = null;
    private RecipeHolder<StoneSolidifierRecipe> currentRecipe = null;
    private int progress;
    private int maxProgress = ModConfigs.COMMON_CSTONE_SOLIDIFIER_RECIPE_DURATION.getValue();
    private int energyConsumptionLeft = -1;
    private boolean hasEnoughEnergy;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    public StoneSolidifierBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.STONE_SOLIDIFIER_ENTITY.get(), blockPos, blockState);
        this.energyStorage = new ReceiveOnlyEnergyStorage(0, ModConfigs.COMMON_STONE_SOLIDIFIER_CAPACITY.getValue(), ModConfigs.COMMON_STONE_SOLIDIFIER_TRANSFER_RATE.getValue()){

            @Override
            protected void onChange() {
                StoneSolidifierBlockEntity.this.m_6596_();
                if (StoneSolidifierBlockEntity.this.f_58857_ != null && !StoneSolidifierBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, StoneSolidifierBlockEntity.this.m_58899_()), StoneSolidifierBlockEntity.this.m_58899_(), (ResourceKey<Level>)StoneSolidifierBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
        this.fluidStorage = new EnergizedPowerFluidStorage(new int[]{TANK_CAPACITY, TANK_CAPACITY}){

            @Override
            protected void onContentsChanged() {
                StoneSolidifierBlockEntity.this.m_6596_();
                if (StoneSolidifierBlockEntity.this.f_58857_ != null && !StoneSolidifierBlockEntity.this.f_58857_.m_5776_()) {
                    for (int i = 0; i < this.getTanks(); ++i) {
                        ModMessages.sendToPlayersWithinXBlocks(new FluidSyncS2CPacket(i, this.getFluidInTank(i), this.getTankCapacity(i), StoneSolidifierBlockEntity.this.m_58899_()), StoneSolidifierBlockEntity.this.m_58899_(), (ResourceKey<Level>)StoneSolidifierBlockEntity.this.f_58857_.m_46472_(), 32);
                    }
                }
            }

            @Override
            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                if (!super.isFluidValid(tank, stack)) {
                    return false;
                }
                return switch (tank) {
                    case 0 -> stack.isFluidEqual(new FluidStack((Fluid)Fluids.f_76193_, 1));
                    case 1 -> stack.isFluidEqual(new FluidStack((Fluid)Fluids.f_76195_, 1));
                    default -> false;
                };
            }
        };
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(StoneSolidifierBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(StoneSolidifierBlockEntity.this.maxProgress, index - 2);
                    case 4, 5 -> ByteUtils.get2Bytes(StoneSolidifierBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 6 -> {
                        if (StoneSolidifierBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 7 -> StoneSolidifierBlockEntity.this.redstoneMode.ordinal();
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        StoneSolidifierBlockEntity.this.progress = ByteUtils.with2Bytes(StoneSolidifierBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        StoneSolidifierBlockEntity.this.maxProgress = ByteUtils.with2Bytes(StoneSolidifierBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: {
                        StoneSolidifierBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 8;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.stone_solidifier");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new EnergySyncS2CPacket(this.energyStorage.getEnergy(), this.energyStorage.getCapacity(), this.m_58899_()), (ServerPlayer)player);
        for (int i = 0; i < 2; ++i) {
            ModMessages.sendToPlayer(new FluidSyncS2CPacket(i, this.fluidStorage.getFluidInTank(i), this.fluidStorage.getTankCapacity(i), this.f_58858_), (ServerPlayer)player);
        }
        ModMessages.sendToPlayer(new SyncStoneSolidifierCurrentRecipeS2CPacket(this.m_58899_(), this.currentRecipe), (ServerPlayer)player);
        return new StoneSolidifierMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
        this.lazyFluidStorage = LazyOptional.of(() -> this.fluidStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
        this.lazyFluidStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        for (int i = 0; i < this.fluidStorage.getTanks(); ++i) {
            nbt.m_128365_("fluid." + i, (Tag)this.fluidStorage.getFluid(i).writeToNBT(new CompoundTag()));
        }
        if (this.currentRecipe != null) {
            nbt.m_128365_("recipe.id", (Tag)StringTag.m_129297_((String)this.currentRecipe.f_291676_().toString()));
        }
        nbt.m_128365_("recipe.progress", (Tag)IntTag.m_128679_((int)this.progress));
        nbt.m_128365_("recipe.energy_consumption_left", (Tag)IntTag.m_128679_((int)this.energyConsumptionLeft));
        nbt.m_128405_("configuration.redstone_mode", this.redstoneMode.ordinal());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
        for (int i = 0; i < this.fluidStorage.getTanks(); ++i) {
            this.fluidStorage.setFluid(i, FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("fluid." + i)));
        }
        if (nbt.m_128441_("recipe.id")) {
            Tag tag = nbt.m_128423_("recipe.id");
            if (!(tag instanceof StringTag)) {
                throw new IllegalArgumentException("Tag must be of type StringTag!");
            }
            StringTag stringTag = (StringTag)tag;
            this.currentRecipeIdForLoad = ResourceLocation.m_135820_((String)stringTag.m_7916_());
        }
        this.progress = nbt.m_128451_("recipe.progress");
        this.energyConsumptionLeft = nbt.m_128451_("recipe.energy_consumption_left");
        this.redstoneMode = RedstoneMode.fromIndex(nbt.m_128451_("configuration.redstone_mode"));
    }

    public void drops(Level level, BlockPos worldPosition) {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)level, (BlockPos)worldPosition, (Container)inventory);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, StoneSolidifierBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (blockEntity.currentRecipeIdForLoad != null) {
            List recipes = level.m_7465_().m_44013_((RecipeType)StoneSolidifierRecipe.Type.INSTANCE);
            blockEntity.currentRecipe = recipes.stream().filter(recipe -> recipe.f_291676_().equals((Object)blockEntity.currentRecipeIdForLoad)).findFirst().orElse(null);
            blockEntity.currentRecipeIdForLoad = null;
        }
        if (!blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)StoneSolidifierBlock.POWERED))) {
            return;
        }
        if (StoneSolidifierBlockEntity.hasRecipe(blockEntity)) {
            if (blockEntity.currentRecipe == null) {
                return;
            }
            if (blockEntity.energyConsumptionLeft < 0) {
                blockEntity.energyConsumptionLeft = ENERGY_USAGE_PER_TICK * blockEntity.maxProgress;
            }
            if (ENERGY_USAGE_PER_TICK <= blockEntity.energyStorage.getEnergy()) {
                blockEntity.hasEnoughEnergy = true;
                if (blockEntity.progress < 0 || blockEntity.maxProgress < 0 || blockEntity.energyConsumptionLeft < 0) {
                    blockEntity.resetProgress(blockPos, state);
                    StoneSolidifierBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
                    return;
                }
                blockEntity.energyStorage.setEnergy(blockEntity.energyStorage.getEnergy() - ENERGY_USAGE_PER_TICK);
                blockEntity.energyConsumptionLeft -= ENERGY_USAGE_PER_TICK;
                ++blockEntity.progress;
                if (blockEntity.progress >= blockEntity.maxProgress) {
                    blockEntity.craftItem();
                }
                StoneSolidifierBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            } else {
                blockEntity.hasEnoughEnergy = false;
                StoneSolidifierBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
            }
        } else {
            blockEntity.resetProgress(blockPos, state);
            StoneSolidifierBlockEntity.m_155232_((Level)level, (BlockPos)blockPos, (BlockState)state);
        }
    }

    private void resetProgress(BlockPos blockPos, BlockState state) {
        this.progress = 0;
        this.energyConsumptionLeft = -1;
        this.hasEnoughEnergy = true;
    }

    public void craftItem() {
        if (this.currentRecipe == null || !StoneSolidifierBlockEntity.hasRecipe(this)) {
            return;
        }
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        StoneSolidifierRecipe recipe = (StoneSolidifierRecipe)this.currentRecipe.f_291008_();
        this.fluidStorage.drain(new FluidStack((Fluid)Fluids.f_76193_, recipe.getWaterAmount()), IFluidHandler.FluidAction.EXECUTE);
        this.fluidStorage.drain(new FluidStack((Fluid)Fluids.f_76195_, recipe.getLavaAmount()), IFluidHandler.FluidAction.EXECUTE);
        this.itemHandler.setStackInSlot(0, recipe.m_8043_(this.f_58857_.m_9598_()).m_255036_(this.itemHandler.getStackInSlot(0).m_41613_() + recipe.m_8043_(this.f_58857_.m_9598_()).m_41613_()));
        this.resetProgress(this.m_58899_(), this.m_58900_());
    }

    private static boolean hasRecipe(StoneSolidifierBlockEntity blockEntity) {
        if (blockEntity.currentRecipe == null) {
            return false;
        }
        Level level = blockEntity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        StoneSolidifierRecipe recipe = (StoneSolidifierRecipe)blockEntity.currentRecipe.f_291008_();
        return blockEntity.fluidStorage.getFluid(0).getAmount() >= recipe.getWaterAmount() && blockEntity.fluidStorage.getFluid(1).getAmount() >= recipe.getLavaAmount() && StoneSolidifierBlockEntity.canInsertItemIntoOutputSlot(inventory, recipe.m_8043_(level.m_9598_()));
    }

    private static boolean canInsertItemIntoOutputSlot(SimpleContainer inventory, ItemStack itemStack) {
        ItemStack inventoryItemStack = inventory.m_8020_(0);
        return (inventoryItemStack.m_41619_() || ItemStack.m_150942_((ItemStack)inventoryItemStack, (ItemStack)itemStack)) && inventoryItemStack.m_41741_() >= inventoryItemStack.m_41613_() + itemStack.m_41613_();
    }

    public void changeRecipeIndex(boolean downUp) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        List recipes = this.f_58857_.m_7465_().m_44013_((RecipeType)StoneSolidifierRecipe.Type.INSTANCE);
        recipes = recipes.stream().sorted(Comparator.comparing(recipe -> ((StoneSolidifierRecipe)recipe.f_291008_()).m_8043_(this.f_58857_.m_9598_()).m_41778_())).collect(Collectors.toList());
        int currentIndex = -1;
        if (this.currentRecipe != null) {
            for (int i = 0; i < recipes.size(); ++i) {
                if (!this.currentRecipe.f_291676_().equals((Object)((RecipeHolder)recipes.get(i)).f_291676_())) continue;
                currentIndex = i;
                break;
            }
        }
        if ((currentIndex += downUp ? 1 : -1) < -1) {
            currentIndex = recipes.size() - 1;
        } else if (currentIndex >= recipes.size()) {
            currentIndex = -1;
        }
        this.currentRecipe = currentIndex == -1 ? null : (RecipeHolder)recipes.get(currentIndex);
        this.resetProgress(this.m_58899_(), this.m_58900_());
        StoneSolidifierBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
        ModMessages.sendToPlayersWithinXBlocks(new SyncStoneSolidifierCurrentRecipeS2CPacket(this.m_58899_(), this.currentRecipe), this.m_58899_(), (ResourceKey<Level>)this.f_58857_.m_46472_(), 32);
    }

    public void setCurrentRecipe(@Nullable RecipeHolder<StoneSolidifierRecipe> currentRecipe) {
        this.currentRecipe = currentRecipe;
    }

    @Nullable
    public RecipeHolder<StoneSolidifierRecipe> getCurrentRecipe() {
        return this.currentRecipe;
    }

    public FluidStack getFluid(int tank) {
        return this.fluidStorage.getFluid(tank);
    }

    public int getTankCapacity(int tank) {
        return this.fluidStorage.getCapacity(tank);
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        this.fluidStorage.setFluid(tank, fluidStack);
    }

    @Override
    public void setTankCapacity(int tank, int capacity) {
        this.fluidStorage.setCapacity(tank, capacity);
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.m_6596_();
    }
}

