/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.TeleporterBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.handler.InputOutputItemHandler;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.item.ModItems;
import me.jddev0.ep.item.TeleporterMatrixItem;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import me.jddev0.ep.screen.TeleporterMenu;
import me.jddev0.ep.util.InventoryUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeleporterBlockEntity
extends BlockEntity
implements MenuProvider,
EnergyStoragePacketUpdate {
    public static final boolean INTRA_DIMENSIONAL_ENABLED = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_ENABLED.getValue();
    public static final boolean INTER_DIMENSIONAL_ENABLED = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_ENABLED.getValue();
    public static final List<@NotNull ResourceLocation> DIMENSION_BLACKLIST = ModConfigs.COMMON_TELEPORTER_DIMENSION_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTRA_DIMENSIONAL_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTER_DIMENSIONAL_FROM_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_FROM_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTER_DIMENSIONAL_TO_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_TO_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> DIMENSION_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_DIMENSION_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTRA_DIMENSIONAL_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTRA_DIMENSIONAL_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST.getValue();
    public static final List<@NotNull ResourceLocation> INTER_DIMENSIONAL_TO_TYPE_BLACKLIST = ModConfigs.COMMON_TELEPORTER_INTER_DIMENSIONAL_TO_TYPE_BLACKLIST.getValue();
    public static final int CAPACITY = ModConfigs.COMMON_TELEPORTER_CAPACITY.getValue();
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TeleporterBlockEntity.this.setChangedAndUpdateReadyState();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return stack.m_150930_((Item)ModItems.TELEPORTER_MATRIX.get());
            }
            return super.isItemValid(slot, stack);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final LazyOptional<IItemHandler> lazyItemHandlerSided = LazyOptional.of(() -> new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> true, i -> true));
    private final ReceiveOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();

    public TeleporterBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.TELEPORTER_ENTITY.get(), blockPos, blockState);
        this.energyStorage = new ReceiveOnlyEnergyStorage(0, CAPACITY, ModConfigs.COMMON_TELEPORTER_TRANSFER_RATE.getValue()){

            @Override
            protected void onChange() {
                TeleporterBlockEntity.this.setChangedAndUpdateReadyState();
                if (TeleporterBlockEntity.this.f_58857_ != null && !TeleporterBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, TeleporterBlockEntity.this.m_58899_()), TeleporterBlockEntity.this.m_58899_(), (ResourceKey<Level>)TeleporterBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.teleporter");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new EnergySyncS2CPacket(this.energyStorage.getEnergy(), this.energyStorage.getCapacity(), this.m_58899_()), (ServerPlayer)player);
        return new TeleporterMenu(id, inventory, this);
    }

    public int getRedstoneOutput() {
        return InventoryUtils.getRedstoneSignalFromItemStackHandler(this.itemHandler);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.lazyItemHandler.cast();
            }
            return this.lazyItemHandlerSided.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
    }

    public void drops(Level level, BlockPos worldPosition) {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)level, (BlockPos)worldPosition, (Container)inventory);
    }

    public void setChangedAndUpdateReadyState() {
        boolean powered;
        boolean oldPowered = this.f_58857_.m_8055_(this.f_58858_).m_61138_((Property)TeleporterBlock.POWERED) && (Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)TeleporterBlock.POWERED) != false;
        ItemStack teleporterMatrixItemStack = this.itemHandler.getStackInSlot(0);
        boolean bl = powered = this.energyStorage.getEnergy() == this.energyStorage.getCapacity() && teleporterMatrixItemStack.m_150930_((Item)ModItems.TELEPORTER_MATRIX.get()) && TeleporterMatrixItem.isLinked(teleporterMatrixItemStack);
        if (oldPowered ^ powered) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)TeleporterBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
        this.m_6596_();
    }

    public void onRedstoneTriggered() {
        Optional<Player> player = this.f_58857_.m_142425_(EntityTypeTest.m_156916_(Player.class), AABB.m_82321_((BoundingBox)BoundingBox.m_162375_((Vec3i)new Vec3i(this.f_58858_.m_123341_() - 2, this.f_58858_.m_123342_() - 2, this.f_58858_.m_123343_() - 2), (Vec3i)new Vec3i(this.f_58858_.m_123341_() + 2, this.f_58858_.m_123342_() + 2, this.f_58858_.m_123343_() + 2))), EntitySelector.f_20408_.and(entity -> entity.m_20238_(this.f_58858_.m_252807_()) <= 4.0)).stream().min(Comparator.comparing(entity -> entity.m_20238_(this.f_58858_.m_252807_())));
        if (player.isEmpty()) {
            return;
        }
        Player player2 = player.get();
        if (!(player2 instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player2;
        this.teleportPlayer(serverPlayer);
    }

    public void teleportPlayer(ServerPlayer player) {
        ResourceLocation toDimensionId;
        LazyOptional energyStorageLazyOptional = this.getCapability(ForgeCapabilities.ENERGY, null);
        if (!energyStorageLazyOptional.isPresent()) {
            return;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
        if (energyStorage.getEnergyStored() < CAPACITY) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter.use.not_enough_energy").m_130940_(ChatFormatting.RED)));
            return;
        }
        ItemStack teleporterMatrixItemStack = this.getStack(0);
        if (!teleporterMatrixItemStack.m_150930_((Item)ModItems.TELEPORTER_MATRIX.get())) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter.use.no_teleporter_matrix").m_130940_(ChatFormatting.RED)));
            return;
        }
        if (!TeleporterMatrixItem.isLinked(teleporterMatrixItemStack)) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_not_bound").m_130940_(ChatFormatting.RED)));
            return;
        }
        BlockPos toPos = TeleporterMatrixItem.getBlockPos(this.f_58857_, teleporterMatrixItemStack);
        if (toPos == null) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_invalid_position").m_130940_(ChatFormatting.RED)));
            return;
        }
        Level toDimension = TeleporterMatrixItem.getDimension(this.f_58857_, teleporterMatrixItemStack);
        if (!(toDimension instanceof ServerLevel)) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_invalid_dimension").m_130940_(ChatFormatting.RED)));
            return;
        }
        if (this.f_58858_.equals((Object)toPos) && this.f_58857_.m_46472_().equals((Object)toDimension.m_46472_())) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter.use.teleporter_self_position").m_130940_(ChatFormatting.RED)));
            return;
        }
        ResourceLocation fromDimensionId = this.f_58857_.m_46472_().m_135782_();
        boolean intraDimensional = fromDimensionId.equals((Object)(toDimensionId = toDimension.m_46472_().m_135782_()));
        if (intraDimensional && !INTRA_DIMENSIONAL_ENABLED) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.intra_dimensional_disabled", (Object[])new Object[]{fromDimensionId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && !INTER_DIMENSIONAL_ENABLED) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.inter_dimensional_disabled", (Object[])new Object[]{fromDimensionId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (DIMENSION_BLACKLIST.contains(fromDimensionId)) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension", (Object[])new Object[]{fromDimensionId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (DIMENSION_BLACKLIST.contains(toDimensionId)) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension", (Object[])new Object[]{toDimensionId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (intraDimensional && INTRA_DIMENSIONAL_BLACKLIST.contains(fromDimensionId)) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.intra_dimensional", (Object[])new Object[]{fromDimensionId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_FROM_BLACKLIST.contains(fromDimensionId)) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_from", (Object[])new Object[]{fromDimensionId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_TO_BLACKLIST.contains(toDimensionId)) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_to", (Object[])new Object[]{toDimensionId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        ResourceLocation fromDimensionTypeId = this.f_58857_.m_220362_().m_135782_();
        ResourceLocation toDimensionTypeId = toDimension.m_220362_().m_135782_();
        if (DIMENSION_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (DIMENSION_TYPE_BLACKLIST.contains(toDimensionTypeId)) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.dimension_type", (Object[])new Object[]{toDimensionTypeId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (intraDimensional && INTRA_DIMENSIONAL_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.intra_dimensional_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_FROM_TYPE_BLACKLIST.contains(fromDimensionTypeId)) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_from_type", (Object[])new Object[]{fromDimensionTypeId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        if (!intraDimensional && INTER_DIMENSIONAL_TO_TYPE_BLACKLIST.contains(toDimensionTypeId)) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.teleporter.use.blacklist.inter_dimensional_to_type", (Object[])new Object[]{toDimensionTypeId.toString()}).m_130940_(ChatFormatting.RED)));
            return;
        }
        BlockEntity toBlockEntity = toDimension.m_7702_(toPos);
        if (!(toBlockEntity instanceof TeleporterBlockEntity)) {
            player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.teleporter.use.teleporter_matrix_no_teleporter").m_130940_(ChatFormatting.RED)));
            return;
        }
        this.clearEnergy();
        Vec3 toPosCenter = toPos.m_252807_();
        player.m_264318_((ServerLevel)toDimension, toPosCenter.m_7096_(), (double)(toPos.m_123342_() + 1), toPosCenter.m_7094_(), new HashSet(), 0.0f, 0.0f);
        player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)SoundEvents.f_11852_), SoundSource.BLOCKS, toPosCenter.m_7096_(), (double)toPos.m_123342_(), toPosCenter.m_7094_(), 1.0f, 1.0f, toDimension.m_213780_().m_188505_()));
    }

    public int getSlotCount() {
        return this.itemHandler.getSlots();
    }

    public ItemStack getStack(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    public void clearEnergy() {
        this.energyStorage.setEnergy(0);
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }
}

