/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import me.jddev0.ep.block.ThermalGeneratorBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ExtractOnlyEnergyStorage;
import me.jddev0.ep.fluid.FluidStoragePacketUpdate;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.configuration.RedstoneModeUpdate;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import me.jddev0.ep.networking.packet.FluidSyncS2CPacket;
import me.jddev0.ep.recipe.ThermalGeneratorRecipe;
import me.jddev0.ep.screen.ThermalGeneratorMenu;
import me.jddev0.ep.util.ByteUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThermalGeneratorBlockEntity
extends BlockEntity
implements MenuProvider,
EnergyStoragePacketUpdate,
FluidStoragePacketUpdate,
RedstoneModeUpdate {
    private static final int MAX_EXTRACT = ModConfigs.COMMON_THERMAL_GENERATOR_TRANSFER_RATE.getValue();
    public static final float ENERGY_PRODUCTION_MULTIPLIER = ModConfigs.COMMON_THERMAL_GENERATOR_ENERGY_PRODUCTION_MULTIPLIER.getValue().floatValue();
    private final ExtractOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private final FluidTank fluidStorage;
    private LazyOptional<IFluidHandler> lazyFluidStorage = LazyOptional.empty();
    protected final ContainerData data;
    @NotNull
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;

    public ThermalGeneratorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.THERMAL_GENERATOR_ENTITY.get(), blockPos, blockState);
        this.energyStorage = new ExtractOnlyEnergyStorage(0, ModConfigs.COMMON_THERMAL_GENERATOR_CAPACITY.getValue(), MAX_EXTRACT){

            @Override
            protected void onChange() {
                ThermalGeneratorBlockEntity.this.m_6596_();
                if (ThermalGeneratorBlockEntity.this.f_58857_ != null && !ThermalGeneratorBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, ThermalGeneratorBlockEntity.this.m_58899_()), ThermalGeneratorBlockEntity.this.m_58899_(), (ResourceKey<Level>)ThermalGeneratorBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
        this.fluidStorage = new FluidTank(ModConfigs.COMMON_THERMAL_GENERATOR_FLUID_TANK_CAPACITY.getValue() * 1000){

            protected void onContentsChanged() {
                ThermalGeneratorBlockEntity.this.m_6596_();
                if (ThermalGeneratorBlockEntity.this.f_58857_ != null && !ThermalGeneratorBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new FluidSyncS2CPacket(0, this.fluid, this.capacity, ThermalGeneratorBlockEntity.this.m_58899_()), ThermalGeneratorBlockEntity.this.m_58899_(), (ResourceKey<Level>)ThermalGeneratorBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }

            public boolean isFluidValid(FluidStack stack) {
                if (!super.isFluidValid(stack) || ThermalGeneratorBlockEntity.this.f_58857_ == null) {
                    return false;
                }
                List recipes = ThermalGeneratorBlockEntity.this.f_58857_.m_7465_().m_44013_((RecipeType)ThermalGeneratorRecipe.Type.INSTANCE);
                return recipes.stream().map(RecipeHolder::f_291008_).map(ThermalGeneratorRecipe::getInput).anyMatch(inputs -> Arrays.stream(inputs).anyMatch(input -> stack.getFluid() == input));
            }
        };
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                if (index == 2) {
                    return ThermalGeneratorBlockEntity.this.redstoneMode.ordinal();
                }
                if (ThermalGeneratorBlockEntity.this.f_58857_ == null || index > 1) {
                    return 0;
                }
                List recipes = ThermalGeneratorBlockEntity.this.f_58857_.m_7465_().m_44013_((RecipeType)ThermalGeneratorRecipe.Type.INSTANCE);
                int rawProduction = 0;
                block3: for (RecipeHolder recipe : recipes) {
                    for (Fluid fluid : ((ThermalGeneratorRecipe)recipe.f_291008_()).getInput()) {
                        if (ThermalGeneratorBlockEntity.this.fluidStorage.getFluid().getFluid() != fluid) continue;
                        rawProduction = ((ThermalGeneratorRecipe)recipe.f_291008_()).getEnergyProduction();
                        rawProduction = (int)((float)rawProduction * ENERGY_PRODUCTION_MULTIPLIER);
                        break block3;
                    }
                }
                int productionLeft = (int)((float)(rawProduction * ThermalGeneratorBlockEntity.this.fluidStorage.getFluidAmount()) / 1000.0f);
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(productionLeft, index);
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        ThermalGeneratorBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                    }
                }
            }

            public int m_6499_() {
                return 3;
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.thermal_generator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new EnergySyncS2CPacket(this.energyStorage.getEnergy(), this.energyStorage.getCapacity(), this.m_58899_()), (ServerPlayer)player);
        ModMessages.sendToPlayer(new FluidSyncS2CPacket(0, this.fluidStorage.getFluid(), this.fluidStorage.getCapacity(), this.f_58858_), (ServerPlayer)player);
        return new ThermalGeneratorMenu(id, inventory, this, this.data);
    }

    public int getRedstoneOutput() {
        float fullnessPercent = 0.0f;
        boolean isEmptyFlag = true;
        FluidStack fluid = this.fluidStorage.getFluid();
        if (!fluid.isEmpty()) {
            fullnessPercent = (float)fluid.getAmount() / (float)this.fluidStorage.getCapacity();
            isEmptyFlag = false;
        }
        return Math.min(Mth.m_14143_((float)(fullnessPercent * 14.0f)) + (isEmptyFlag ? 0 : 1), 15);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.lazyFluidStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
        this.lazyFluidStorage = LazyOptional.of(() -> this.fluidStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyStorage.invalidate();
        this.lazyFluidStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        nbt.m_128365_("fluid", (Tag)this.fluidStorage.writeToNBT(new CompoundTag()));
        nbt.m_128405_("configuration.redstone_mode", this.redstoneMode.ordinal());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
        this.fluidStorage.readFromNBT(nbt.m_128469_("fluid"));
        this.redstoneMode = RedstoneMode.fromIndex(nbt.m_128451_("configuration.redstone_mode"));
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        if (blockEntity.redstoneMode.isActive((Boolean)state.m_61143_((Property)ThermalGeneratorBlock.POWERED))) {
            ThermalGeneratorBlockEntity.tickRecipe(level, blockPos, state, blockEntity);
        }
        ThermalGeneratorBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    private static void tickRecipe(Level level, BlockPos blockPos, BlockState state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        List recipes = level.m_7465_().m_44013_((RecipeType)ThermalGeneratorRecipe.Type.INSTANCE);
        int rawProduction = 0;
        block0: for (RecipeHolder recipe : recipes) {
            for (Fluid fluid : ((ThermalGeneratorRecipe)recipe.f_291008_()).getInput()) {
                if (blockEntity.fluidStorage.getFluid().getFluid() != fluid) continue;
                rawProduction = ((ThermalGeneratorRecipe)recipe.f_291008_()).getEnergyProduction();
                rawProduction = (int)((float)rawProduction * ENERGY_PRODUCTION_MULTIPLIER);
                break block0;
            }
        }
        if (rawProduction > 0 && blockEntity.energyStorage.getEnergy() < blockEntity.energyStorage.getCapacity()) {
            int production = (int)((float)rawProduction * ((float)Math.min(blockEntity.fluidStorage.getFluidAmount(), 50) / 1000.0f));
            production = Math.min(production, blockEntity.energyStorage.getCapacity() - blockEntity.energyStorage.getEnergy());
            int fluidAmount = (int)((float)production / (float)rawProduction * 1000.0f);
            production = (int)((float)(rawProduction * fluidAmount) / 1000.0f);
            blockEntity.fluidStorage.drain(fluidAmount, IFluidHandler.FluidAction.EXECUTE);
            blockEntity.energyStorage.setEnergy(Math.min(blockEntity.energyStorage.getCapacity(), blockEntity.energyStorage.getEnergy() + production));
        }
    }

    private static void transferEnergy(Level level, BlockPos blockPos, BlockState state, ThermalGeneratorBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        LinkedList<IEnergyStorage> consumerItems = new LinkedList<IEnergyStorage>();
        LinkedList<Integer> consumerEnergyValues = new LinkedList<Integer>();
        int consumptionSum = 0;
        for (Direction direction : Direction.values()) {
            int received;
            IEnergyStorage energyStorage;
            LazyOptional energyStorageLazyOptional;
            BlockPos testPos = blockPos.m_121945_(direction);
            BlockEntity testBlockEntity = level.m_7702_(testPos);
            if (testBlockEntity == null || !(energyStorageLazyOptional = testBlockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_())).isPresent() || !(energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null)).canReceive() || (received = energyStorage.receiveEnergy(Math.min(MAX_EXTRACT, blockEntity.energyStorage.getEnergy()), true)) <= 0) continue;
            consumptionSum += received;
            consumerItems.add(energyStorage);
            consumerEnergyValues.add(received);
        }
        LinkedList<Integer> consumerEnergyDistributed = new LinkedList<Integer>();
        for (int i = 0; i < consumerItems.size(); ++i) {
            consumerEnergyDistributed.add(0);
        }
        int consumptionLeft = Math.min(MAX_EXTRACT, Math.min(blockEntity.energyStorage.getEnergy(), consumptionSum));
        blockEntity.energyStorage.extractEnergy(consumptionLeft, false);
        int divisor = consumerItems.size();
        block2: while (consumptionLeft > 0) {
            int consumptionPerConsumer = consumptionLeft / divisor;
            if (consumptionPerConsumer == 0) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0) break block2;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
    }

    public FluidStack getFluid(int tank) {
        return this.fluidStorage.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.fluidStorage.getCapacity();
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }

    @Override
    public void setFluid(int tank, FluidStack fluidStack) {
        this.fluidStorage.setFluid(fluidStack);
    }

    @Override
    public void setTankCapacity(int tank, int capacity) {
        this.fluidStorage.setCapacity(capacity);
    }

    @Override
    public void setNextRedstoneMode() {
        this.redstoneMode = RedstoneMode.fromIndex(this.redstoneMode.ordinal() + 1);
        this.m_6596_();
    }
}

