/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.LinkedList;
import me.jddev0.ep.block.TransformerBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ReceiveAndExtractEnergyStorage;
import me.jddev0.ep.energy.ReceiveExtractEnergyHandler;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransformerBlockEntity
extends BlockEntity
implements EnergyStoragePacketUpdate {
    private final int maxTransferRate;
    private final TransformerBlock.Tier tier;
    private final TransformerBlock.Type type;
    private final ReceiveAndExtractEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private final LazyOptional<IEnergyStorage> lazyEnergyStorageSidedReceive;
    private final LazyOptional<IEnergyStorage> lazyEnergyStorageSidedExtract;

    public static BlockEntityType<TransformerBlockEntity> getEntityTypeFromTierAndType(TransformerBlock.Tier tier, TransformerBlock.Type type) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case TransformerBlock.Tier.TIER_LV -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case TYPE_1_TO_N: {
                        yield (BlockEntityType)ModBlockEntities.LV_TRANSFORMER_1_TO_N_ENTITY.get();
                    }
                    case TYPE_3_TO_3: {
                        yield (BlockEntityType)ModBlockEntities.LV_TRANSFORMER_3_TO_3_ENTITY.get();
                    }
                    case TYPE_N_TO_1: 
                }
                yield (BlockEntityType)ModBlockEntities.LV_TRANSFORMER_N_TO_1_ENTITY.get();
            }
            case TransformerBlock.Tier.TIER_MV -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case TYPE_1_TO_N: {
                        yield (BlockEntityType)ModBlockEntities.MV_TRANSFORMER_1_TO_N_ENTITY.get();
                    }
                    case TYPE_3_TO_3: {
                        yield (BlockEntityType)ModBlockEntities.MV_TRANSFORMER_3_TO_3_ENTITY.get();
                    }
                    case TYPE_N_TO_1: 
                }
                yield (BlockEntityType)ModBlockEntities.MV_TRANSFORMER_N_TO_1_ENTITY.get();
            }
            case TransformerBlock.Tier.TIER_HV -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case TYPE_1_TO_N: {
                        yield (BlockEntityType)ModBlockEntities.HV_TRANSFORMER_1_TO_N_ENTITY.get();
                    }
                    case TYPE_3_TO_3: {
                        yield (BlockEntityType)ModBlockEntities.HV_TRANSFORMER_3_TO_3_ENTITY.get();
                    }
                    case TYPE_N_TO_1: 
                }
                yield (BlockEntityType)ModBlockEntities.HV_TRANSFORMER_N_TO_1_ENTITY.get();
            }
            case TransformerBlock.Tier.TIER_EHV -> {
                switch (type) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case TYPE_1_TO_N: {
                        yield (BlockEntityType)ModBlockEntities.EHV_TRANSFORMER_1_TO_N_ENTITY.get();
                    }
                    case TYPE_3_TO_3: {
                        yield (BlockEntityType)ModBlockEntities.EHV_TRANSFORMER_3_TO_3_ENTITY.get();
                    }
                    case TYPE_N_TO_1: 
                }
                yield (BlockEntityType)ModBlockEntities.EHV_TRANSFORMER_N_TO_1_ENTITY.get();
            }
        };
    }

    public static int getMaxEnergyTransferFromTier(TransformerBlock.Tier tier) {
        return switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case TransformerBlock.Tier.TIER_LV -> ModConfigs.COMMON_LV_TRANSFORMERS_TRANSFER_RATE.getValue();
            case TransformerBlock.Tier.TIER_MV -> ModConfigs.COMMON_MV_TRANSFORMERS_TRANSFER_RATE.getValue();
            case TransformerBlock.Tier.TIER_HV -> ModConfigs.COMMON_HV_TRANSFORMERS_TRANSFER_RATE.getValue();
            case TransformerBlock.Tier.TIER_EHV -> ModConfigs.COMMON_EHV_TRANSFORMERS_TRANSFER_RATE.getValue();
        };
    }

    public TransformerBlockEntity(BlockPos blockPos, BlockState blockState, TransformerBlock.Tier tier, TransformerBlock.Type type) {
        super(TransformerBlockEntity.getEntityTypeFromTierAndType(tier, type), blockPos, blockState);
        this.tier = tier;
        this.type = type;
        this.maxTransferRate = TransformerBlockEntity.getMaxEnergyTransferFromTier(this.tier);
        this.energyStorage = new ReceiveAndExtractEnergyStorage(0, this.maxTransferRate, this.maxTransferRate){

            @Override
            protected void onChange() {
                TransformerBlockEntity.this.m_6596_();
                if (TransformerBlockEntity.this.f_58857_ != null && !TransformerBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, TransformerBlockEntity.this.m_58899_()), TransformerBlockEntity.this.m_58899_(), (ResourceKey<Level>)TransformerBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
        this.lazyEnergyStorageSidedReceive = LazyOptional.of(() -> new ReceiveExtractEnergyHandler(this.energyStorage, (maxReceive, simulate) -> true, (maxExtract, simulate) -> false));
        this.lazyEnergyStorageSidedExtract = LazyOptional.of(() -> new ReceiveExtractEnergyHandler(this.energyStorage, (maxReceive, simulate) -> false, (maxExtract, simulate) -> true));
    }

    public TransformerBlock.Type getTransformerType() {
        return this.type;
    }

    public TransformerBlock.Tier getTier() {
        return this.tier;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            if (side == null) {
                return this.lazyEnergyStorage.cast();
            }
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)TransformerBlock.FACING);
            switch (this.type) {
                case TYPE_1_TO_N: 
                case TYPE_N_TO_1: {
                    LazyOptional<IEnergyStorage> multipleSide;
                    LazyOptional<IEnergyStorage> singleSide = this.type == TransformerBlock.Type.TYPE_1_TO_N ? this.lazyEnergyStorageSidedReceive : this.lazyEnergyStorageSidedExtract;
                    LazyOptional<IEnergyStorage> lazyOptional = multipleSide = this.type == TransformerBlock.Type.TYPE_1_TO_N ? this.lazyEnergyStorageSidedExtract : this.lazyEnergyStorageSidedReceive;
                    if (facing == side) {
                        return singleSide.cast();
                    }
                    return multipleSide.cast();
                }
                case TYPE_3_TO_3: {
                    if (facing.m_175364_(Direction.Axis.X) == side || facing.m_175364_(Direction.Axis.Y) == side || facing.m_175364_(Direction.Axis.Z) == side) {
                        return this.lazyEnergyStorageSidedReceive.cast();
                    }
                    return this.lazyEnergyStorageSidedExtract.cast();
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, TransformerBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        TransformerBlockEntity.transferEnergy(level, blockPos, state, blockEntity);
    }

    /*
     * WARNING - void declaration
     */
    private static void transferEnergy(Level level, BlockPos blockPos, BlockState state, TransformerBlockEntity blockEntity) {
        void var10_16;
        void var10_14;
        if (level.f_46443_) {
            return;
        }
        LinkedList<Object> outputDirections = new LinkedList<Object>();
        Direction facing = (Direction)state.m_61143_((Property)TransformerBlock.FACING);
        block4: for (Direction side : Direction.values()) {
            switch (blockEntity.getTransformerType()) {
                case TYPE_1_TO_N: 
                case TYPE_N_TO_1: {
                    boolean isOutputMultipleSide;
                    boolean bl = blockEntity.getTransformerType() != TransformerBlock.Type.TYPE_1_TO_N;
                    boolean bl2 = isOutputMultipleSide = blockEntity.getTransformerType() == TransformerBlock.Type.TYPE_1_TO_N;
                    if (facing == side) {
                        if (!bl) continue block4;
                        outputDirections.add(side);
                        continue block4;
                    }
                    if (!isOutputMultipleSide) continue block4;
                    outputDirections.add(side);
                    continue block4;
                }
                case TYPE_3_TO_3: {
                    if (facing.m_175364_(Direction.Axis.X) == side || facing.m_175364_(Direction.Axis.Y) == side || facing.m_175364_(Direction.Axis.Z) == side) continue block4;
                    outputDirections.add(side);
                }
            }
        }
        LinkedList<IEnergyStorage> consumerItems = new LinkedList<IEnergyStorage>();
        LinkedList<Integer> consumerEnergyValues = new LinkedList<Integer>();
        int consumptionSum = 0;
        for (Direction direction : outputDirections) {
            int received;
            IEnergyStorage energyStorage;
            LazyOptional energyStorageLazyOptional;
            BlockPos testPos = blockPos.m_121945_(direction);
            BlockEntity testBlockEntity = level.m_7702_(testPos);
            if (testBlockEntity == null || !(energyStorageLazyOptional = testBlockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_())).isPresent() || !(energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null)).canReceive() || (received = energyStorage.receiveEnergy(Math.min(blockEntity.maxTransferRate, blockEntity.energyStorage.getEnergy()), true)) <= 0) continue;
            consumptionSum += received;
            consumerItems.add(energyStorage);
            consumerEnergyValues.add(received);
        }
        LinkedList<Integer> consumerEnergyDistributed = new LinkedList<Integer>();
        boolean bl = false;
        while (var10_14 < consumerItems.size()) {
            consumerEnergyDistributed.add(0);
            ++var10_14;
        }
        int n = Math.min(blockEntity.maxTransferRate, Math.min(blockEntity.energyStorage.getEnergy(), consumptionSum));
        blockEntity.energyStorage.extractEnergy(n, false);
        int divisor = consumerItems.size();
        block7: while (var10_16 > 0) {
            void consumptionPerConsumer = var10_16 / divisor;
            if (consumptionPerConsumer == false) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = var10_16 / divisor;
            }
            for (int i = 0; i < consumerEnergyValues.size(); ++i) {
                int consumptionDistributed = (Integer)consumerEnergyDistributed.get(i);
                int consumptionOfConsumerLeft = (Integer)consumerEnergyValues.get(i) - consumptionDistributed;
                int consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min((int)consumptionPerConsumer, (int)var10_16));
                consumerEnergyDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((var10_16 -= consumptionDistributedNew) == false) break block7;
            }
        }
        for (int i = 0; i < consumerItems.size(); ++i) {
            int energy = (Integer)consumerEnergyDistributed.get(i);
            if (energy <= 0) continue;
            ((IEnergyStorage)consumerItems.get(i)).receiveEnergy(energy, false);
        }
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }
}

