/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergyStoragePacketUpdate;
import me.jddev0.ep.energy.ReceiveOnlyEnergyStorage;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import me.jddev0.ep.screen.WeatherControllerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeatherControllerBlockEntity
extends BlockEntity
implements MenuProvider,
EnergyStoragePacketUpdate {
    public static final int CAPACITY = ModConfigs.COMMON_WEATHER_CONTROLLER_CAPACITY.getValue();
    private final ReceiveOnlyEnergyStorage energyStorage;
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();

    public WeatherControllerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.WEATHER_CONTROLLER_ENTITY.get(), blockPos, blockState);
        this.energyStorage = new ReceiveOnlyEnergyStorage(0, CAPACITY, ModConfigs.COMMON_WEATHER_CONTROLLER_TRANSFER_RATE.getValue()){

            @Override
            protected void onChange() {
                WeatherControllerBlockEntity.this.m_6596_();
                if (WeatherControllerBlockEntity.this.f_58857_ != null && !WeatherControllerBlockEntity.this.f_58857_.m_5776_()) {
                    ModMessages.sendToPlayersWithinXBlocks(new EnergySyncS2CPacket(this.energy, this.capacity, WeatherControllerBlockEntity.this.m_58899_()), WeatherControllerBlockEntity.this.m_58899_(), (ResourceKey<Level>)WeatherControllerBlockEntity.this.f_58857_.m_46472_(), 32);
                }
            }
        };
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.energizedpower.weather_controller");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        ModMessages.sendToPlayer(new EnergySyncS2CPacket(this.energyStorage.getEnergy(), this.energyStorage.getCapacity(), this.m_58899_()), (ServerPlayer)player);
        return new WeatherControllerMenu(id, inventory, this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void clearEnergy() {
        this.energyStorage.setEnergy(0);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyStorage.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("energy", this.energyStorage.saveNBT());
        super.m_183515_(nbt);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.energyStorage.loadNBT(nbt.m_128423_("energy"));
    }

    public int getEnergy() {
        return this.energyStorage.getEnergy();
    }

    public int getCapacity() {
        return this.energyStorage.getCapacity();
    }

    @Override
    public void setEnergy(int energy) {
        this.energyStorage.setEnergyWithoutUpdate(energy);
    }

    @Override
    public void setCapacity(int capacity) {
        this.energyStorage.setCapacityWithoutUpdate(capacity);
    }
}

