/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.jddev0.ep.block.FluidTankBlock;
import me.jddev0.ep.block.entity.FluidTankBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class FluidTankBlockEntityRenderer
implements BlockEntityRenderer<FluidTankBlockEntity> {
    private final BlockEntityRendererProvider.Context context;

    public FluidTankBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(FluidTankBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int capacity = blockEntity.getTankCapacity(0);
        FluidStack fluidStack = blockEntity.getFluid(0);
        if (fluidStack.isEmpty()) {
            return;
        }
        float height = fluidStack.getAmount() <= 0 || capacity == 0 ? 0.0f : (float)Math.min(fluidStack.getAmount(), capacity - 1) * 14.0f / (float)capacity;
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)FluidTankBlock.FACING);
        poseStack.m_85836_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(Sheets.m_110792_());
        poseStack.m_252781_(facing.m_253075_());
        poseStack.m_252781_(new Quaternionf().rotationX(1.5707964f));
        switch (facing) {
            case NORTH: {
                poseStack.m_252880_(-1.0f, -1.0f + (16.0f - height - 1.0f) / 16.0f, 0.0625f);
                break;
            }
            case SOUTH: {
                poseStack.m_252880_(0.0f, -1.0f + (16.0f - height - 1.0f) / 16.0f, -0.9375f);
                break;
            }
            case EAST: {
                poseStack.m_252880_(-1.0f, -1.0f + (16.0f - height - 1.0f) / 16.0f, -0.9375f);
                break;
            }
            case WEST: {
                poseStack.m_252880_(0.0f, -1.0f + (16.0f - height - 1.0f) / 16.0f, 0.0625f);
                break;
            }
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation stillFluidImageId = fluidTypeExtensions.getStillTexture(fluidStack);
        TextureAtlasSprite stillFluidSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(stillFluidImageId);
        int fluidColorTint = fluidTypeExtensions.getTintColor(fluidStack);
        Matrix4f mat = poseStack.m_85850_().m_252922_();
        float u0 = stillFluidSprite.m_118409_();
        float u1 = stillFluidSprite.m_118410_();
        float v0 = stillFluidSprite.m_118411_();
        float v1 = stillFluidSprite.m_118412_();
        float du = u1 - u0;
        float dv = v1 - v0;
        float v1Orig = v1 -= 0.0625f * dv;
        vertexConsumer.m_252986_(mat, 0.0625f, height * 0.0625f, 0.0f).m_193479_(fluidColorTint).m_7421_(u0 += 0.0625f * du, v1 -= (14.0f - height) / 16.0f * dv).m_86008_(packedOverlay).m_85969_(0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(mat, 0.9375f, height * 0.0625f, 0.0f).m_193479_(fluidColorTint).m_7421_(u1 -= 0.0625f * du, v1).m_86008_(packedOverlay).m_85969_(0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(mat, 0.9375f, 0.0f, 0.0f).m_193479_(fluidColorTint).m_7421_(u1, v0 += 0.0625f * dv).m_86008_(packedOverlay).m_85969_(0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(mat, 0.0625f, 0.0f, 0.0f).m_193479_(fluidColorTint).m_7421_(u0, v0).m_86008_(packedOverlay).m_85969_(0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
        TextureAtlasSprite indicatorBarSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("energizedpower", "block/fluid_tank_indicator_bar"));
        float translateForMinMaxIndicatorBarHeight = height < 2.0f ? (height - 2.0f) / 16.0f : (height > 12.0f ? (height - 12.0f) / 16.0f : 0.0f);
        poseStack.m_252880_(0.0f, translateForMinMaxIndicatorBarHeight, 0.0f);
        float ibu0 = indicatorBarSprite.m_118409_();
        float ibu1 = indicatorBarSprite.m_118410_();
        float ibv0 = indicatorBarSprite.m_118411_();
        float ibv1 = indicatorBarSprite.m_118412_();
        ibu1 = ibu0 + 0.0625f * (ibu1 - ibu0);
        ibv1 = ibv0 + 0.0625f * (ibv1 - ibv0);
        vertexConsumer.m_252986_(mat, 0.375f, 0.015f, -0.05f).m_6122_(255, 255, 255, 255).m_7421_(ibu0, ibv1).m_86008_(packedOverlay).m_85969_(0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(mat, 0.625f, 0.015f, -0.05f).m_6122_(255, 255, 255, 255).m_7421_(ibu1, ibv1).m_86008_(packedOverlay).m_85969_(0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(mat, 0.625f, -0.015f, -0.05f).m_6122_(255, 255, 255, 255).m_7421_(ibu1, ibv0).m_86008_(packedOverlay).m_85969_(0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(mat, 0.375f, -0.015f, -0.05f).m_6122_(255, 255, 255, 255).m_7421_(ibu0, ibv0).m_86008_(packedOverlay).m_85969_(0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
        poseStack.m_252880_(0.0f, -translateForMinMaxIndicatorBarHeight, 0.0f);
        v1 = v1Orig;
        poseStack.m_252880_(0.0f, 1.0f - (16.0f - height - 1.0f) / 16.0f, 0.0f);
        poseStack.m_252781_(new Quaternionf().rotationX(-1.5707964f));
        poseStack.m_252880_(0.0f, -0.875f, -1.0f + (16.0f - height - 1.0f) / 16.0f);
        vertexConsumer.m_252986_(mat, 0.0625f, 0.875f, 0.0f).m_193479_(fluidColorTint).m_7421_(u0, v1).m_86008_(packedOverlay).m_85969_(0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(mat, 0.9375f, 0.875f, 0.0f).m_193479_(fluidColorTint).m_7421_(u1, v1).m_86008_(packedOverlay).m_85969_(0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(mat, 0.9375f, 0.0f, 0.0f).m_193479_(fluidColorTint).m_7421_(u1, v0).m_86008_(packedOverlay).m_85969_(0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(mat, 0.0625f, 0.0f, 0.0f).m_193479_(fluidColorTint).m_7421_(u0, v0).m_86008_(packedOverlay).m_85969_(0xF000F0).m_252939_(poseStack.m_85850_().m_252943_(), 0.0f, 0.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }
}

