/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.config.validation;

import java.util.Collection;
import java.util.List;
import me.jddev0.ep.config.ConfigValidationException;
import me.jddev0.ep.config.validation.ElementOfCollectionValueValidator;
import me.jddev0.ep.config.validation.ValueValidator;
import org.jetbrains.annotations.NotNull;

public final class ValueValidators {
    public static final ValueValidator<String> STRING_NOT_EMPTY = new ValueValidator<String>(){

        @Override
        public void validate(@NotNull String value) throws ConfigValidationException {
            if (value.isEmpty()) {
                throw new ConfigValidationException("Value must not be empty");
            }
        }

        @Override
        @NotNull
        public List<String> getValidationCommentLines() {
            return List.of("Value must not be empty");
        }
    };
    public static final ValueValidator<String> STRING_NOT_BLANK = new ValueValidator<String>(){

        @Override
        public void validate(@NotNull String value) throws ConfigValidationException {
            if (value.isEmpty()) {
                throw new ConfigValidationException("Value must not be blank");
            }
        }

        @Override
        @NotNull
        public List<String> getValidationCommentLines() {
            return List.of("Value must not be blank");
        }
    };

    @NotNull
    public static <T> ElementOfCollectionValueValidator<T> elementOfCollection(@NotNull Collection<T> elements) {
        return new ElementOfCollectionValueValidator<T>(elements);
    }

    private ValueValidators() {
    }
}

