/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.energy;

import me.jddev0.ep.energy.IEnergizedPowerEnergyStorage;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;

public class ExtractOnlyEnergyStorage
implements IEnergizedPowerEnergyStorage {
    protected int energy;
    protected int capacity;
    protected int maxExtract;

    public ExtractOnlyEnergyStorage() {
    }

    public ExtractOnlyEnergyStorage(int energy, int capacity, int maxExtract) {
        this.energy = energy;
        this.capacity = capacity;
        this.maxExtract = maxExtract;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public void setEnergy(int energy) {
        this.energy = energy;
        this.onChange();
    }

    @Override
    public void setEnergyWithoutUpdate(int energy) {
        this.energy = energy;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void setCapacity(int capacity) {
        this.capacity = capacity;
        this.onChange();
    }

    @Override
    public void setCapacityWithoutUpdate(int capacity) {
        this.capacity = capacity;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
        this.onChange();
    }

    public void setMaxExtractWithoutUpdate(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    protected void onChange() {
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int extracted = Math.min(this.energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.energy -= extracted;
            this.onChange();
        }
        return extracted;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    @Override
    public Tag saveNBT() {
        return IntTag.m_128679_((int)this.energy);
    }

    @Override
    public void loadNBT(Tag tag) {
        if (!(tag instanceof IntTag)) {
            this.energy = 0;
            return;
        }
        this.energy = ((IntTag)tag).m_7047_();
    }
}

