/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.curios;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;

public final class CuriosCompatUtils {
    private CuriosCompatUtils() {
    }

    public static boolean isCuriosAvailable() {
        try {
            Class.forName("top.theillusivec4.curios.api.CuriosApi");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static List<ItemStack> getCuriosItemStacks(Inventory inventory) {
        LinkedList<ItemStack> itemStacks = new LinkedList<ItemStack>();
        if (!CuriosCompatUtils.isCuriosAvailable()) {
            return itemStacks;
        }
        ICuriosHelper curiosHelper = CuriosApi.getCuriosHelper();
        if (curiosHelper == null) {
            return itemStacks;
        }
        LazyOptional itemHandlerModifiableLazyOptional = curiosHelper.getEquippedCurios((LivingEntity)inventory.f_35978_);
        if (itemHandlerModifiableLazyOptional == null || !itemHandlerModifiableLazyOptional.isPresent()) {
            return itemStacks;
        }
        IItemHandlerModifiable itemHandlerModifiable = (IItemHandlerModifiable)itemHandlerModifiableLazyOptional.orElseGet(null);
        for (int i = 0; i < itemHandlerModifiable.getSlots(); ++i) {
            ItemStack itemStack = itemHandlerModifiable.getStackInSlot(i);
            if (itemStack.m_41619_()) continue;
            itemStacks.add(itemStack);
        }
        return itemStacks;
    }
}

