/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.PlantGrowthChamberBlockEntity;
import me.jddev0.ep.recipe.PlantGrowthChamberRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class PlantGrowthChamberEMIRecipe
implements EmiRecipe {
    public static final ResourceLocation SIMPLIFIED_TEXTURE = new ResourceLocation("energizedpower", "textures/block/plant_growth_chamber_front.png");
    public static final EmiStack ITEM = EmiStack.of((ItemLike)((ItemLike)ModBlocks.PLANT_GROWTH_CHAMBER_ITEM.get()));
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(new ResourceLocation("energizedpower", "plant_growth_chamber"), (EmiRenderable)ITEM, (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURE, 0, 0, 16, 16, 16, 16, 16, 16));
    private final ResourceLocation id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final PlantGrowthChamberRecipe.OutputItemStackWithPercentages[] outputsWithPercentages;
    private final int ticks;

    public PlantGrowthChamberEMIRecipe(RecipeHolder<PlantGrowthChamberRecipe> recipe) {
        this.id = recipe.f_291676_();
        this.input = List.of(EmiIngredient.of((Ingredient)((PlantGrowthChamberRecipe)recipe.f_291008_()).getInput()));
        this.output = Arrays.stream(((PlantGrowthChamberRecipe)recipe.f_291008_()).getMaxOutputCounts()).map(EmiStack::of).toList();
        this.outputsWithPercentages = ((PlantGrowthChamberRecipe)recipe.f_291008_()).getOutputs();
        this.ticks = (int)((float)((PlantGrowthChamberRecipe)recipe.f_291008_()).getTicks() * PlantGrowthChamberBlockEntity.RECIPE_DURATION_MULTIPLIER);
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 108;
    }

    public int getDisplayHeight() {
        return 48;
    }

    public void addWidgets(WidgetHolder widgets) {
        int i;
        ResourceLocation texture = new ResourceLocation("energizedpower", "textures/gui/container/plant_growth_chamber.png");
        widgets.addTexture(texture, 0, 0, 108, 48, 61, 25);
        widgets.addSlot(this.input.get(0), 0, 9).drawBack(false);
        ArrayList outputSlotEntries = new ArrayList(4);
        for (i = 0; i < 4; ++i) {
            outputSlotEntries.add(new LinkedList());
        }
        for (i = 0; i < this.output.size(); ++i) {
            ((List)outputSlotEntries.get(i % 4)).add(this.output.get(i));
        }
        SlotWidget[] outputSlots = new SlotWidget[]{widgets.addSlot(EmiIngredient.of((List)((List)outputSlotEntries.get(0))), 72, 0).drawBack(false).recipeContext((EmiRecipe)this), widgets.addSlot(EmiIngredient.of((List)((List)outputSlotEntries.get(1))), 90, 0).drawBack(false).recipeContext((EmiRecipe)this), widgets.addSlot(EmiIngredient.of((List)((List)outputSlotEntries.get(2))), 72, 18).drawBack(false).recipeContext((EmiRecipe)this), widgets.addSlot(EmiIngredient.of((List)((List)outputSlotEntries.get(3))), 90, 18).drawBack(false).recipeContext((EmiRecipe)this)};
        for (int i2 = 0; i2 < this.outputsWithPercentages.length; ++i2) {
            SlotWidget outputSlot = outputSlots[i2 % 4];
            MutableComponent oddsText = Component.m_237115_((String)"recipes.energizedpower.transfer.output_percentages");
            if (i2 >= 4 || i2 + 4 < this.outputsWithPercentages.length) {
                outputSlot.appendTooltip((Component)Component.m_237115_((String)this.outputsWithPercentages[i2].output().m_41778_()).m_7220_((Component)Component.m_237113_((String)": ").m_7220_((Component)oddsText)));
            } else {
                outputSlot.appendTooltip((Component)oddsText);
            }
            double[] percentages = this.outputsWithPercentages[i2].percentages();
            for (int j = 0; j < percentages.length; ++j) {
                outputSlot.appendTooltip((Component)Component.m_237113_((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", j + 1, 100.0 * percentages[j])));
            }
            if (i2 + 4 >= this.outputsWithPercentages.length) continue;
            outputSlot.appendTooltip((Component)Component.m_237119_());
        }
        MutableComponent ticksText = Component.m_237110_((String)"recipes.energizedpower.info.ticks", (Object[])new Object[]{this.ticks});
        FormattedCharSequence formattedCharSequence = ticksText.m_7532_();
        int n = widgets.getWidth() - Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)ticksText);
        int n2 = widgets.getHeight();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        widgets.addText(formattedCharSequence, n, n2 - 9, ChatFormatting.WHITE.m_126665_().intValue(), false);
    }
}

