/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.jei;

import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.block.entity.EnergizerBlockEntity;
import me.jddev0.ep.recipe.EnergizerRecipe;
import me.jddev0.ep.util.EnergyUtils;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class EnergizerCategory
implements IRecipeCategory<RecipeHolder<EnergizerRecipe>> {
    public static final ResourceLocation UID = new ResourceLocation("energizedpower", "energizer");
    public static final RecipeType<RecipeHolder<EnergizerRecipe>> TYPE = RecipeType.createFromVanilla((net.minecraft.world.item.crafting.RecipeType)EnergizerRecipe.Type.INSTANCE);
    private final IDrawable background;
    private final IDrawable icon;

    public EnergizerCategory(IGuiHelper helper) {
        ResourceLocation texture = new ResourceLocation("energizedpower", "textures/gui/container/energizer.png");
        this.background = helper.createDrawable(texture, 31, 18, 114, 50);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.ENERGIZER_ITEM.get()));
    }

    public RecipeType<RecipeHolder<EnergizerRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"container.energizedpower.energizer");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayoutBuilder, RecipeHolder<EnergizerRecipe> recipe, IFocusGroup iFocusGroup) {
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 17, 17).addIngredients(((EnergizerRecipe)recipe.f_291008_()).getInput());
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 93, 17).addItemStack(((EnergizerRecipe)recipe.f_291008_()).getOutput());
    }

    public void draw(RecipeHolder<EnergizerRecipe> recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        int energyConsumption = (int)((float)((EnergizerRecipe)recipe.f_291008_()).getEnergyConsumption() * EnergizerBlockEntity.ENERGY_CONSUMPTION_MULTIPLIER);
        MutableComponent component = Component.m_237113_((String)EnergyUtils.getEnergyWithPrefix(energyConsumption)).m_130940_(ChatFormatting.YELLOW);
        int textWidth = font.m_92852_((FormattedText)component);
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)component, 114 - textWidth, 42, -1, false);
    }
}

