/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item;

import java.util.List;
import me.jddev0.ep.block.WrenchConfigurable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class WrenchItem
extends Item {
    public WrenchItem(Item.Properties props) {
        super(props);
    }

    public static Direction getCurrentFace(ItemStack itemStack) {
        Direction currentFace;
        CompoundTag nbt = itemStack.m_41783_();
        Direction direction = currentFace = nbt != null && nbt.m_128441_("currentFace") ? Direction.m_122402_((String)nbt.m_128461_("currentFace")) : Direction.DOWN;
        if (currentFace == null) {
            currentFace = Direction.DOWN;
        }
        return currentFace;
    }

    public static void cycleCurrentFace(ItemStack itemStack, ServerPlayer player) {
        int diff = player.m_6144_() ? -1 : 1;
        Direction currentFace = WrenchItem.getCurrentFace(itemStack);
        currentFace = Direction.values()[(currentFace.ordinal() + diff + Direction.values().length) % Direction.values().length];
        itemStack.m_41784_().m_128359_("currentFace", currentFace.m_7912_());
        player.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237110_((String)"tooltip.energizedpower.wrench.select_face", (Object[])new Object[]{Component.m_237115_((String)("tooltip.energizedpower.direction." + currentFace.m_7912_())).m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})}).m_130940_(ChatFormatting.GRAY)));
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        Level level = useOnContext.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Player player = useOnContext.m_43723_();
        BlockPos blockPos = useOnContext.m_8083_();
        BlockState state = level.m_8055_(blockPos);
        Block block = state.m_60734_();
        if (!(block instanceof WrenchConfigurable)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"tooltip.energizedpower.wrench.not_configurable").m_130940_(ChatFormatting.RED)));
            }
            return InteractionResult.SUCCESS;
        }
        WrenchConfigurable wrenchConfigurableBlock = (WrenchConfigurable)block;
        ItemStack itemStack = useOnContext.m_43722_();
        Direction currentFace = WrenchItem.getCurrentFace(itemStack);
        return wrenchConfigurableBlock.onUseWrench(useOnContext, currentFace, player != null && player.m_6144_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        WrenchItem.cycleCurrentFace(itemStack, (ServerPlayer)player);
        return InteractionResultHolder.m_19090_((Object)itemStack);
    }

    public float m_8102_(ItemStack itemStack, BlockState blockState) {
        return 1000.0f;
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos blockPos, Player player) {
        if (level.f_46443_ || !(player instanceof ServerPlayer)) {
            return false;
        }
        ItemStack itemStack = player.m_21205_();
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null && nbt.m_128441_("attackingCycleCooldown")) {
            return false;
        }
        WrenchItem.cycleCurrentFace(itemStack, (ServerPlayer)player);
        itemStack.m_41784_().m_128405_("attackingCycleCooldown", 5);
        return false;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        Direction currentFace = WrenchItem.getCurrentFace(itemStack);
        components.add((Component)Component.m_237110_((String)"tooltip.energizedpower.wrench.select_face", (Object[])new Object[]{Component.m_237115_((String)("tooltip.energizedpower.direction." + currentFace.m_7912_())).m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD})}).m_130940_(ChatFormatting.GRAY));
        if (Screen.m_96638_()) {
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.wrench.txt.shift").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            components.add((Component)Component.m_237115_((String)"tooltip.energizedpower.shift_details.txt").m_130940_(ChatFormatting.YELLOW));
        }
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(itemStack, level, entity, slot, selected);
        if (level.f_46443_) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null && nbt.m_128441_("attackingCycleCooldown")) {
            int attackingCycleCooldown = nbt.m_128451_("attackingCycleCooldown") - 1;
            if (attackingCycleCooldown <= 0) {
                nbt.m_128473_("attackingCycleCooldown");
            } else {
                nbt.m_128405_("attackingCycleCooldown", attackingCycleCooldown);
            }
        }
    }
}

