/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item.energy;

import java.util.List;
import java.util.function.Supplier;
import me.jddev0.ep.energy.IEnergizedPowerEnergyStorage;
import me.jddev0.ep.item.energy.ItemCapabilityEnergy;
import me.jddev0.ep.util.EnergyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class EnergizedPowerEnergyItem
extends Item {
    private final Supplier<IEnergizedPowerEnergyStorage> energyStorageProvider;

    protected static int getEnergy(ItemStack itemStack) {
        return ((IEnergyStorage)itemStack.getCapability(ForgeCapabilities.ENERGY).orElse(null)).getEnergyStored();
    }

    protected static void setEnergy(ItemStack itemStack, int energy) {
        ((ItemCapabilityEnergy)itemStack.getCapability(ForgeCapabilities.ENERGY).orElse(null)).setEnergy(energy);
    }

    protected static int getCapacity(ItemStack itemStack) {
        return ((IEnergyStorage)itemStack.getCapability(ForgeCapabilities.ENERGY).orElse(null)).getMaxEnergyStored();
    }

    public EnergizedPowerEnergyItem(Item.Properties props, Supplier<IEnergizedPowerEnergyStorage> energyStorageProvider) {
        super(props);
        this.energyStorageProvider = energyStorageProvider;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round((float)EnergizedPowerEnergyItem.getEnergy(stack) * 13.0f / (float)EnergizedPowerEnergyItem.getCapacity(stack));
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)EnergizedPowerEnergyItem.getEnergy(stack) / (float)EnergizedPowerEnergyItem.getCapacity(stack));
        return Mth.m_14169_((float)(f * 0.33f), (float)1.0f, (float)1.0f);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        components.add((Component)Component.m_237110_((String)"tooltip.energizedpower.energy_meter.content.txt", (Object[])new Object[]{EnergyUtils.getEnergyWithPrefix(EnergizedPowerEnergyItem.getEnergy(itemStack)), EnergyUtils.getEnergyWithPrefix(EnergizedPowerEnergyItem.getCapacity(itemStack))}).m_130940_(ChatFormatting.GRAY));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ItemCapabilityEnergy(stack, stack.m_41783_(), this.energyStorageProvider.get());
    }
}

