/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import me.jddev0.ep.block.entity.TimeControllerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class SetTimeFromTimeControllerC2SPacket {
    private final BlockPos pos;
    private final int time;

    public SetTimeFromTimeControllerC2SPacket(BlockPos pos, int time) {
        this.pos = pos;
        this.time = time;
    }

    public SetTimeFromTimeControllerC2SPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.time = buffer.readInt();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.time);
    }

    public boolean handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            Level level = context.getSender().m_9236_();
            if (!level.m_7232_(SectionPos.m_123171_((int)this.pos.m_123341_()), SectionPos.m_123171_((int)this.pos.m_123343_()))) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (!(blockEntity instanceof TimeControllerBlockEntity)) {
                return;
            }
            TimeControllerBlockEntity timeControllerBlockEntity = (TimeControllerBlockEntity)blockEntity;
            LazyOptional energyStorageLazyOptional = timeControllerBlockEntity.getCapability(ForgeCapabilities.ENERGY, null);
            if (!energyStorageLazyOptional.isPresent()) {
                return;
            }
            IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
            if (energyStorage.getEnergyStored() < TimeControllerBlockEntity.CAPACITY) {
                return;
            }
            timeControllerBlockEntity.clearEnergy();
            if (this.time < 0 || this.time > 24000) {
                return;
            }
            long currentTime = context.getSender().m_9236_().m_46468_();
            int currentDayTime = (int)(currentTime % 24000L);
            if (currentDayTime <= this.time) {
                context.getSender().m_284548_().m_8615_(currentTime - (long)currentDayTime + (long)this.time);
            } else {
                context.getSender().m_284548_().m_8615_(currentTime + 24000L - (long)currentDayTime + (long)this.time);
            }
        });
        return true;
    }
}

