/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import me.jddev0.ep.block.WeatherControllerBlock;
import me.jddev0.ep.block.entity.WeatherControllerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class SetWeatherFromWeatherControllerC2SPacket {
    private final BlockPos pos;
    private final int weatherType;

    public SetWeatherFromWeatherControllerC2SPacket(BlockPos pos, int weatherType) {
        this.pos = pos;
        this.weatherType = weatherType;
    }

    public SetWeatherFromWeatherControllerC2SPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.weatherType = buffer.readInt();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeInt(this.weatherType);
    }

    public boolean handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            Level level = context.getSender().m_9236_();
            if (!level.m_7232_(SectionPos.m_123171_((int)this.pos.m_123341_()), SectionPos.m_123171_((int)this.pos.m_123343_()))) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (!(blockEntity instanceof WeatherControllerBlockEntity)) {
                return;
            }
            WeatherControllerBlockEntity weatherControllerBlockEntity = (WeatherControllerBlockEntity)blockEntity;
            LazyOptional energyStorageLazyOptional = weatherControllerBlockEntity.getCapability(ForgeCapabilities.ENERGY, null);
            if (!energyStorageLazyOptional.isPresent()) {
                return;
            }
            IEnergyStorage energyStorage = (IEnergyStorage)energyStorageLazyOptional.orElse(null);
            if (energyStorage.getEnergyStored() < WeatherControllerBlockEntity.CAPACITY) {
                return;
            }
            weatherControllerBlockEntity.clearEnergy();
            switch (this.weatherType) {
                case 0: {
                    context.getSender().m_284548_().m_8606_(WeatherControllerBlock.WEATHER_CHANGED_TICKS, 0, false, false);
                    break;
                }
                case 1: {
                    context.getSender().m_284548_().m_8606_(0, WeatherControllerBlock.WEATHER_CHANGED_TICKS, true, false);
                    break;
                }
                case 2: {
                    context.getSender().m_284548_().m_8606_(0, WeatherControllerBlock.WEATHER_CHANGED_TICKS, true, true);
                }
            }
        });
        return true;
    }
}

