/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.networking.packet;

import me.jddev0.ep.block.entity.StoneSolidifierBlockEntity;
import me.jddev0.ep.recipe.StoneSolidifierRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.jetbrains.annotations.Nullable;

public class SyncStoneSolidifierCurrentRecipeS2CPacket {
    private final BlockPos pos;
    private final RecipeHolder<StoneSolidifierRecipe> currentRecipe;

    public SyncStoneSolidifierCurrentRecipeS2CPacket(BlockPos pos, @Nullable RecipeHolder<StoneSolidifierRecipe> currentRecipe) {
        this.pos = pos;
        this.currentRecipe = currentRecipe;
    }

    public SyncStoneSolidifierCurrentRecipeS2CPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.currentRecipe = buffer.readBoolean() ? new RecipeHolder(buffer.m_130281_(), (Recipe)StoneSolidifierRecipe.Serializer.INSTANCE.fromNetwork(buffer)) : null;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        if (this.currentRecipe == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.m_130085_(this.currentRecipe.f_291676_());
            StoneSolidifierRecipe.Serializer.INSTANCE.toNetwork(buffer, (StoneSolidifierRecipe)this.currentRecipe.f_291008_());
        }
    }

    public boolean handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.pos);
            if (blockEntity instanceof StoneSolidifierBlockEntity) {
                StoneSolidifierBlockEntity stoneSolidifierBlockEntity = (StoneSolidifierBlockEntity)blockEntity;
                stoneSolidifierBlockEntity.setCurrentRecipe(this.currentRecipe);
            }
        });
        return true;
    }
}

