/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.codec.ArrayCodec;
import me.jddev0.ep.codec.CodecFix;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AssemblingMachineRecipe
implements Recipe<SimpleContainer> {
    private final ItemStack output;
    private final IngredientWithCount[] inputs;

    public AssemblingMachineRecipe(ItemStack output, IngredientWithCount[] inputs) {
        this.output = output;
        this.inputs = inputs;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public IngredientWithCount[] getInputs() {
        return this.inputs;
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        boolean[] usedIndices = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            usedIndices[i] = container.m_8020_(i).m_41619_();
        }
        int len = Math.min(this.inputs.length, 4);
        for (int i = 0; i < len; ++i) {
            IngredientWithCount input = this.inputs[i];
            int indexMinCount = -1;
            int minCount = Integer.MAX_VALUE;
            for (int j = 0; j < 4; ++j) {
                if (usedIndices[j]) continue;
                ItemStack item = container.m_8020_(j);
                if (indexMinCount != -1 && item.m_41613_() >= minCount || !input.input.test(item) || item.m_41613_() < input.count) continue;
                indexMinCount = j;
                minCount = item.m_41613_();
            }
            if (indexMinCount == -1) {
                return false;
            }
            usedIndices[indexMinCount] = true;
        }
        for (boolean usedIndex : usedIndices) {
            if (usedIndex) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        return this.output;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.ASSEMBLING_MACHINE_ITEM.get());
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public record IngredientWithCount(Ingredient input, int count) {
        public static final Codec<IngredientWithCount> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.f_290991_.fieldOf("input").forGetter(input -> input.input), (App)ExtraCodecs.f_144629_.optionalFieldOf("count", (Object)1).forGetter(input -> input.count)).apply((Applicative)instance, IngredientWithCount::new));
    }

    public static final class Serializer
    implements RecipeSerializer<AssemblingMachineRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("energizedpower", "assembling_machine");
        private final Codec<AssemblingMachineRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)new ArrayCodec<IngredientWithCount>(IngredientWithCount.CODEC, IngredientWithCount[]::new).fieldOf("inputs").forGetter(recipe -> recipe.inputs)).apply((Applicative)instance, AssemblingMachineRecipe::new));

        private Serializer() {
        }

        public Codec<AssemblingMachineRecipe> m_292673_() {
            return this.CODEC;
        }

        public AssemblingMachineRecipe fromNetwork(FriendlyByteBuf buffer) {
            int len = buffer.readInt();
            IngredientWithCount[] inputs = new IngredientWithCount[len];
            for (int i = 0; i < len; ++i) {
                Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
                int count = buffer.readInt();
                inputs[i] = new IngredientWithCount(input, count);
            }
            ItemStack output = buffer.m_130267_();
            return new AssemblingMachineRecipe(output, inputs);
        }

        public void toNetwork(FriendlyByteBuf buffer, AssemblingMachineRecipe recipe) {
            buffer.writeInt(recipe.inputs.length);
            for (int i = 0; i < recipe.inputs.length; ++i) {
                recipe.inputs[i].input.m_43923_(buffer);
                buffer.writeInt(recipe.inputs[i].count);
            }
            buffer.writeItemStack(recipe.output, false);
        }
    }

    public static final class Type
    implements RecipeType<AssemblingMachineRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "assembling_machine";

        private Type() {
        }
    }
}

