/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import me.jddev0.ep.block.ModBlocks;
import me.jddev0.ep.codec.CodecFix;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CrystalGrowthChamberRecipe
implements Recipe<SimpleContainer> {
    private final OutputItemStackWithPercentages output;
    private final Ingredient input;
    private final int inputCount;
    private final int ticks;

    public CrystalGrowthChamberRecipe(OutputItemStackWithPercentages output, Ingredient input, int inputCount, int ticks) {
        this.output = output;
        this.input = input;
        this.inputCount = inputCount;
        this.ticks = ticks;
    }

    public OutputItemStackWithPercentages getOutput() {
        return this.output;
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public int getTicks() {
        return this.ticks;
    }

    public ItemStack getMaxOutputCount() {
        return this.output.output.m_255036_(this.output.percentages.length);
    }

    public ItemStack generateOutput(RandomSource randomSource) {
        int count = 0;
        for (double percentage : this.output.percentages) {
            if (!(randomSource.m_188500_() <= percentage)) continue;
            ++count;
        }
        return this.output.output.m_255036_(count);
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (level.f_46443_) {
            return false;
        }
        return this.input.test(container.m_8020_(0)) && container.m_8020_(0).m_41613_() >= this.inputCount;
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.CRYSTAL_GROWTH_CHAMBER_ITEM.get());
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public record OutputItemStackWithPercentages(ItemStack output, double[] percentages) {
        private static final Codec<double[]> DOUBLE_ARRAY_CODEC = new Codec<double[]>(){
            private static final Codec<List<Double>> DOUBLE_LIST_CODEC = Codec.doubleRange((double)0.0, (double)1.0).listOf();

            public <T> DataResult<Pair<double[], T>> decode(DynamicOps<T> ops, T input) {
                return DOUBLE_LIST_CODEC.decode(ops, input).map(res -> Pair.of((Object)((List)res.getFirst()).stream().mapToDouble(Double::doubleValue).toArray(), (Object)res.getSecond()));
            }

            public <T> DataResult<T> encode(double[] input, DynamicOps<T> ops, T prefix) {
                return DOUBLE_LIST_CODEC.encode(Arrays.stream(input).boxed().toList(), ops, prefix);
            }
        };
        public static final Codec<OutputItemStackWithPercentages> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecFix.ITEM_STACK_CODEC.fieldOf("output").forGetter(output -> output.output), (App)DOUBLE_ARRAY_CODEC.fieldOf("percentages").forGetter(output -> output.percentages)).apply((Applicative)instance, OutputItemStackWithPercentages::new));
    }

    public static final class Serializer
    implements RecipeSerializer<CrystalGrowthChamberRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("energizedpower", "crystal_growth_chamber");
        private final Codec<CrystalGrowthChamberRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OutputItemStackWithPercentages.CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)Ingredient.f_290991_.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)ExtraCodecs.f_144629_.optionalFieldOf("inputCount", (Object)1).forGetter(recipe -> recipe.inputCount), (App)ExtraCodecs.f_144629_.fieldOf("ticks").forGetter(recipe -> recipe.ticks)).apply((Applicative)instance, CrystalGrowthChamberRecipe::new));

        private Serializer() {
        }

        public Codec<CrystalGrowthChamberRecipe> m_292673_() {
            return this.CODEC;
        }

        public CrystalGrowthChamberRecipe fromNetwork(FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int inputCount = buffer.readInt();
            int ticks = buffer.readInt();
            ItemStack output = buffer.m_130267_();
            int percentageCount = buffer.readInt();
            double[] percentages = new double[percentageCount];
            for (int j = 0; j < percentageCount; ++j) {
                percentages[j] = buffer.readDouble();
            }
            OutputItemStackWithPercentages outputItemStackWithPercentages = new OutputItemStackWithPercentages(output, percentages);
            return new CrystalGrowthChamberRecipe(outputItemStackWithPercentages, input, inputCount, ticks);
        }

        public void toNetwork(FriendlyByteBuf buffer, CrystalGrowthChamberRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.writeInt(recipe.inputCount);
            buffer.writeInt(recipe.ticks);
            buffer.writeItemStack(recipe.output.output, false);
            buffer.writeInt(recipe.output.percentages.length);
            for (double percentage : recipe.output.percentages) {
                buffer.writeDouble(percentage);
            }
        }
    }

    public static final class Type
    implements RecipeType<CrystalGrowthChamberRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "crystal_growth_chamber";

        private Type() {
        }
    }
}

